/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;

public class StringSourceWithMapKey
extends AbstractSource {
    private final Map<String, String> map;

    public StringSourceWithMapKey(String content, Map<String, String> map) {
        this.map = map;
        this.map.put("<query>", content);
    }

    @Override
    public String path() {
        return this.type();
    }

    @Override
    public String type() {
        return "StringWithMapKey";
    }

    @Override
    public Object getKey() {
        return this.map;
    }

    @Override
    public Source.Validity isValid(DBBroker broker) {
        return Source.Validity.VALID;
    }

    @Override
    public Source.Validity isValid(Source other) {
        return Source.Validity.VALID;
    }

    @Override
    public Reader getReader() throws IOException {
        return new StringReader(this.map.get("<query>"));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getContent() throws IOException {
        return this.map.get("<query>");
    }

    @Override
    public void validate(Subject subject, int perm) throws PermissionDeniedException {
    }
}

