/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.Backup;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;
import org.exist.util.FileUtils;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;
import org.xmldb.api.base.XMLDBException;

public class BackupSystemTask
implements SystemTask {
    private static final Logger LOG = LogManager.getLogger(BackupSystemTask.class);
    private final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyyMMddHHmmssS");
    private String user;
    private String password;
    private Path directory;
    private String suffix;
    private XmldbURI collection;
    private String prefix;
    private int zipFilesMax = -1;

    @Override
    public String getName() {
        return "Backup Task";
    }

    @Override
    public void configure(Configuration config, Properties properties) throws EXistException {
        this.user = properties.getProperty("user", "guest");
        this.password = properties.getProperty("password", "guest");
        String collName = properties.getProperty("collection", "xmldb:exist:///db");
        if (!collName.startsWith("xmldb:exist:")) {
            collName = "xmldb:exist://" + collName;
        }
        this.collection = XmldbURI.create(collName);
        LOG.debug("Collection to backup: " + this.collection.toString() + ". User: " + this.user);
        this.suffix = properties.getProperty("suffix", "");
        this.prefix = properties.getProperty("prefix", "");
        String dir = properties.getProperty("dir", "backup");
        this.directory = Paths.get(dir, new String[0]);
        if (!this.directory.isAbsolute()) {
            this.directory = ((Path)config.getProperty("db-connection.data-dir")).resolve(dir);
        }
        try {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new EXistException("Unable to create backup directory: " + this.directory.toAbsolutePath().toString(), ioe);
        }
        String filesMaxStr = properties.getProperty("zip-files-max");
        if (LOG.isDebugEnabled()) {
            LOG.debug("zip-files-max: " + filesMaxStr);
        }
        if (null != filesMaxStr) {
            try {
                this.zipFilesMax = Integer.parseInt(filesMaxStr);
            }
            catch (NumberFormatException e) {
                LOG.debug("zip-files-max property error", (Throwable)e);
            }
        }
    }

    @Override
    public void execute(DBBroker broker) throws EXistException {
        String dateTime = this.creationDateFormat.format(Calendar.getInstance().getTime());
        Path dest = this.directory.resolve(this.prefix + dateTime + this.suffix);
        Backup backup = new Backup(this.user, this.password, dest, this.collection);
        try {
            backup.backup(false, null);
        }
        catch (IOException | SAXException | XMLDBException e) {
            LOG.debug(e.getMessage(), e);
            throw new EXistException(e.getMessage(), e);
        }
        if (".zip".equals(this.suffix) && this.zipFilesMax > 0) {
            try {
                this.purgeZipFiles();
            }
            catch (IOException ioe) {
                throw new EXistException("Unable to purge zip files", ioe);
            }
        }
    }

    public void purgeZipFiles() throws IOException {
        List<Path> files;
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting purgeZipFiles()");
        }
        if (!(files = FileUtils.list(this.directory)).isEmpty()) {
            TreeMap<String, Path> sorted = new TreeMap<String, Path>();
            for (Path file : files) {
                if (!file.getFileName().startsWith(this.prefix) || !FileUtils.fileName(file).endsWith(this.suffix)) continue;
                sorted.put(Long.toString(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()), file);
            }
            if (sorted.size() > this.zipFilesMax) {
                Set keys = sorted.keySet();
                Iterator ki = keys.iterator();
                int i = sorted.size() - this.zipFilesMax;
                while (ki.hasNext()) {
                    Path f = (Path)sorted.get(ki.next());
                    if (i > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Purging backup : " + FileUtils.fileName(f));
                        }
                        FileUtils.deleteQuietly(f);
                    }
                    --i;
                }
            }
        }
    }

    @Override
    public boolean afterCheckpoint() {
        return false;
    }
}

