/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import com.evolvedbinary.j8fu.fsm.AtomicFSM;
import com.evolvedbinary.j8fu.fsm.EventProcessor;
import com.evolvedbinary.j8fu.fsm.FSM;
import com.evolvedbinary.j8fu.fsm.TransitionTable;
import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.CollectionCache;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.triggers.CollectionTrigger;
import org.exist.collections.triggers.CollectionTriggerProxy;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.DocumentTriggerProxy;
import org.exist.collections.triggers.TriggerException;
import org.exist.collections.triggers.TriggerProxy;
import org.exist.config.ConfigurationDocumentTrigger;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.debuggee.Debuggee;
import org.exist.debuggee.DebuggeeFactory;
import org.exist.dom.persistent.SymbolTable;
import org.exist.indexing.IndexManager;
import org.exist.management.AgentFactory;
import org.exist.numbering.DLNFactory;
import org.exist.numbering.NodeIdFactory;
import org.exist.plugin.PluginsManager;
import org.exist.plugin.PluginsManagerImpl;
import org.exist.repo.ClasspathHelper;
import org.exist.repo.ExistRepository;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.impl.QuartzSchedulerImpl;
import org.exist.scheduler.impl.SystemTaskJobImpl;
import org.exist.security.AuthenticationException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.SecurityManagerImpl;
import org.exist.storage.BrokerFactory;
import org.exist.storage.BrokerPoolConstants;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.BrokerPoolServicesManager;
import org.exist.storage.BrokerPoolServicesManagerException;
import org.exist.storage.BrokerPools;
import org.exist.storage.BrokerWatchdog;
import org.exist.storage.CollectionCacheManager;
import org.exist.storage.ConsistencyCheckTask;
import org.exist.storage.DBBroker;
import org.exist.storage.DefaultCacheManager;
import org.exist.storage.MetaStorage;
import org.exist.storage.NotificationService;
import org.exist.storage.ProcessMonitor;
import org.exist.storage.StartupTriggersManager;
import org.exist.storage.SystemTask;
import org.exist.storage.SystemTaskManager;
import org.exist.storage.XQueryPool;
import org.exist.storage.journal.JournalManager;
import org.exist.storage.lock.DeadlockDetection;
import org.exist.storage.lock.FileLockService;
import org.exist.storage.recovery.RecoveryManager;
import org.exist.storage.sync.Sync;
import org.exist.storage.sync.SyncTask;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.util.Stacktrace;
import org.exist.util.TraceableStateChange;
import org.exist.util.TraceableStateChanges;
import org.exist.util.XMLReaderObjectFactory;
import org.exist.util.XMLReaderPool;
import org.exist.xmldb.ShutdownListener;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.PerformanceStats;
import org.exist.xquery.XQuery;
import org.xml.sax.XMLReader;

@ConfigurationClass(value="pool")
public class BrokerPool
extends BrokerPools
implements BrokerPoolConstants,
Database {
    private static final Logger LOG = LogManager.getLogger(BrokerPool.class);
    private final BrokerPoolServicesManager servicesManager = new BrokerPoolServicesManager();
    private StatusReporter statusReporter = null;
    private final XQuery xqueryService = new XQuery();
    public static boolean FORCE_CORRUPTION = false;
    private final boolean recoveryEnabled;
    private final String instanceName;
    private final FSM<State, Event> status = new AtomicFSM((Enum)State.SHUTDOWN, (EventProcessor)TransitionTable.transitionTable(State.class, Event.class).when((Enum)State.SHUTDOWN).on((Enum)Event.INITIALIZE).switchTo((Enum)State.INITIALIZING).when((Enum)State.INITIALIZING).on((Enum)Event.INITIALIZE_SYSTEM_MODE).switchTo((Enum)State.INITIALIZING_SYSTEM_MODE).when((Enum)State.INITIALIZING_SYSTEM_MODE).on((Enum)Event.INITIALIZE_MULTI_USER_MODE).switchTo((Enum)State.INITIALIZING_MULTI_USER_MODE).when((Enum)State.INITIALIZING_MULTI_USER_MODE).on((Enum)Event.READY).switchTo((Enum)State.OPERATIONAL).when((Enum)State.OPERATIONAL).on((Enum)Event.START_SHUTDOWN).switchTo((Enum)State.SHUTTING_DOWN).when((Enum)State.SHUTTING_DOWN).on((Enum)Event.FINISHED_SHUTDOWN).switchTo((Enum)State.SHUTDOWN).build());
    private int brokersCount = 0;
    @ConfigurationFieldAsAttribute(value="min")
    private final int minBrokers;
    @ConfigurationFieldAsAttribute(value="max")
    private final int maxBrokers;
    private final Deque<DBBroker> inactiveBrokers = new ArrayDeque<DBBroker>();
    private final Map<Thread, DBBroker> activeBrokers = new ConcurrentHashMap<Thread, DBBroker>();
    private final Map<String, TraceableStateChanges<TraceableBrokerLeaseChange.BrokerInfo, TraceableBrokerLeaseChange.Change>> brokerLeaseChangeTrace = LOG.isTraceEnabled() ? new HashMap() : null;
    private final Map<String, List<TraceableStateChanges<TraceableBrokerLeaseChange.BrokerInfo, TraceableBrokerLeaseChange.Change>>> brokerLeaseChangeTraceHistory = LOG.isTraceEnabled() ? new HashMap() : null;
    private final Configuration conf;
    private final ConcurrentSkipListSet<Observer> statusObservers = new ConcurrentSkipListSet();
    private boolean syncRequired = false;
    private Sync syncEvent = Sync.MINOR;
    private boolean checkpoint = false;
    @GuardedBy(value="itself")
    private Boolean readOnly = Boolean.FALSE;
    @ConfigurationFieldAsAttribute(value="pageSize")
    private final int pageSize;
    private FileLockService dataLock;
    private Optional<JournalManager> journalManager = Optional.empty();
    private TransactionManager transactionManager = null;
    @ConfigurationFieldAsAttribute(value="wait-before-shutdown")
    private final long maxShutdownWait;
    @ConfigurationFieldAsAttribute(value="scheduler")
    private Scheduler scheduler;
    private IndexManager indexManager;
    private SymbolTable symbols;
    @ConfigurationFieldAsAttribute(value="sync-period")
    private final long majorSyncPeriod;
    private long lastMajorSync = System.currentTimeMillis();
    private final long diskSpaceMin;
    private ShutdownListener shutdownListener = null;
    private SecurityManager securityManager = null;
    private PluginsManagerImpl pluginManager = null;
    private NotificationService notificationService = null;
    private DefaultCacheManager cacheManager;
    private CollectionCacheManager collectionCacheMgr;
    private long reservedMem;
    private XQueryPool xQueryPool;
    private ProcessMonitor processMonitor;
    private PerformanceStats xqueryStats;
    private CollectionConfigurationManager collectionConfigurationManager = null;
    private CollectionCache collectionCache;
    private XMLReaderPool xmlReaderPool;
    private final NodeIdFactory nodeFactory = new DLNFactory();
    private final Lock globalXUpdateLock = new ReentrantLock();
    private Subject serviceModeUser = null;
    private boolean inServiceMode = false;
    private final Calendar startupTime = Calendar.getInstance();
    private final Optional<BrokerWatchdog> watchdog;
    private final ClassLoader classLoader;
    private Optional<ExistRepository> expathRepo = Optional.empty();
    private StartupTriggersManager startupTriggersManager;
    private Debuggee debuggee = null;
    private final List<TriggerProxy<? extends DocumentTrigger>> documentTriggers = new ArrayList<TriggerProxy<? extends DocumentTrigger>>();
    private final List<TriggerProxy<? extends CollectionTrigger>> collectionTriggers = new ArrayList<TriggerProxy<? extends CollectionTrigger>>();
    protected MetaStorage metaStorage = null;

    BrokerPool(String instanceName, int minBrokers, int maxBrokers, Configuration conf, Optional<Observer> statusObserver) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.instanceName = instanceName;
        this.maxShutdownWait = conf.getProperty("wait-before-shutdown", 45000L);
        LOG.info("database instance '" + instanceName + "' will wait  " + nf.format(this.maxShutdownWait) + " ms during shutdown");
        this.recoveryEnabled = conf.getProperty("db-connection.recovery.enabled", true);
        LOG.info("database instance '" + instanceName + "' is enabled for recovery : " + this.recoveryEnabled);
        this.minBrokers = conf.getProperty("db-connection.pool.min", minBrokers);
        this.maxBrokers = conf.getProperty("db-connection.pool.max", maxBrokers);
        LOG.info("database instance '" + instanceName + "' will have between " + nf.format(this.minBrokers) + " and " + nf.format(this.maxBrokers) + " brokers");
        this.majorSyncPeriod = conf.getProperty("db-connection.pool.sync-period", 120000L);
        LOG.info("database instance '" + instanceName + "' will be synchronized every " + nf.format(this.majorSyncPeriod) + " ms");
        this.diskSpaceMin = 0x100000L * (long)conf.getProperty("db-connection.diskSpaceMin", (short)64).shortValue();
        this.pageSize = conf.getProperty("db-connection.page-size", 4096);
        this.conf = conf;
        statusObserver.ifPresent(this.statusObservers::add);
        this.watchdog = Optional.ofNullable(System.getProperty("trace.brokers")).filter(value -> value.equals("yes")).map(value -> new BrokerWatchdog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() throws EXistException, DatabaseConfigurationException {
        try {
            this._initialize();
        }
        catch (Throwable e) {
            Boolean bl = this.readOnly;
            synchronized (bl) {
                if (this.dataLock != null && !this.readOnly.booleanValue()) {
                    this.dataLock.release();
                }
            }
            if (e instanceof EXistException) {
                throw (EXistException)e;
            }
            if (e instanceof DatabaseConfigurationException) {
                throw (DatabaseConfigurationException)e;
            }
            throw new EXistException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initialize() throws EXistException, DatabaseConfigurationException {
        this.status.process((Enum)Event.INITIALIZE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializing database instance '" + this.instanceName + "'...");
        }
        this.scheduler = this.servicesManager.register(new QuartzSchedulerImpl(this));
        this.dataLock = this.servicesManager.register(new FileLockService("dbx_dir.lck", "db-connection.data-dir", "data"));
        this.securityManager = this.servicesManager.register(new SecurityManagerImpl(this));
        this.cacheManager = this.servicesManager.register(new DefaultCacheManager(this));
        this.xQueryPool = this.servicesManager.register(new XQueryPool());
        this.processMonitor = this.servicesManager.register(new ProcessMonitor());
        this.xqueryStats = this.servicesManager.register(new PerformanceStats(this));
        XMLReaderObjectFactory xmlReaderObjectFactory = this.servicesManager.register(new XMLReaderObjectFactory());
        this.xmlReaderPool = this.servicesManager.register(new XMLReaderPool((PoolableObjectFactory<XMLReader>)xmlReaderObjectFactory, 5, 0));
        int bufferSize = Optional.of(this.conf.getInteger("db-connection.collection-cache-size")).filter(size -> size != -1).orElse(64);
        this.collectionCache = this.servicesManager.register(new CollectionCache(this, bufferSize, 1.0E-6));
        this.collectionCacheMgr = this.servicesManager.register(new CollectionCacheManager(this, this.collectionCache));
        this.notificationService = this.servicesManager.register(new NotificationService());
        Optional<Object> optional = this.journalManager = this.recoveryEnabled ? Optional.of(new JournalManager()) : Optional.empty();
        if (this.journalManager.isPresent()) {
            this.servicesManager.register((BrokerPoolService)this.journalManager.get());
        }
        SystemTaskManager systemTaskManager = this.servicesManager.register(new SystemTaskManager(this));
        this.transactionManager = this.servicesManager.register(new TransactionManager(this, this.journalManager, systemTaskManager));
        this.symbols = this.servicesManager.register(new SymbolTable());
        this.expathRepo = Optional.ofNullable(new ExistRepository());
        if (this.expathRepo.isPresent()) {
            this.servicesManager.register((BrokerPoolService)this.expathRepo.get());
        }
        this.servicesManager.register(new ClasspathHelper());
        this.indexManager = this.servicesManager.register(new IndexManager(this));
        this.pluginManager = this.servicesManager.register(new PluginsManagerImpl());
        this.collectionConfigurationManager = this.servicesManager.register(new CollectionConfigurationManager(this));
        this.startupTriggersManager = this.servicesManager.register(new StartupTriggersManager());
        try {
            this.servicesManager.configureServices(this.conf);
        }
        catch (BrokerPoolServiceException e) {
            throw new EXistException(e);
        }
        Runtime rt = Runtime.getRuntime();
        long maxMem = rt.maxMemory();
        long minFree = maxMem / 5L;
        this.reservedMem = this.cacheManager.getTotalMem() + this.collectionCacheMgr.getMaxTotal() + minFree;
        LOG.debug("Reserved memory: " + this.reservedMem + "; max: " + maxMem + "; min: " + minFree);
        try {
            this.servicesManager.prepareServices(this);
        }
        catch (BrokerPoolServiceException e) {
            throw new EXistException(e);
        }
        if (this.majorSyncPeriod > 0L) {
            SyncTask syncTask = new SyncTask();
            syncTask.configure(this.conf, null);
            this.scheduler.createPeriodicJob(2500L, new SystemTaskJobImpl(SyncTask.getJobName(), syncTask), 2500L);
        }
        try {
            this.statusReporter = new StatusReporter("startup");
            this.statusObservers.forEach(this.statusReporter::addObserver);
            Thread statusThread = new Thread(this.statusReporter);
            statusThread.start();
            try {
                boolean exportOnly = this.conf.getProperty("db-connection.emergency", false);
                try {
                    try (DBBroker systemBroker = this.get(Optional.of(this.securityManager.getSystemSubject()));){
                        boolean recovered;
                        block57: {
                            this.status.process((Enum)Event.INITIALIZE_SYSTEM_MODE);
                            if (this.isReadOnly()) {
                                this.journalManager.ifPresent(JournalManager::disableJournalling);
                            }
                            recovered = false;
                            if (this.isRecoveryEnabled() && !(recovered = this.runRecovery(systemBroker))) {
                                try {
                                    if (systemBroker.getCollection(XmldbURI.ROOT_COLLECTION_URI) != null) break block57;
                                    Txn txn = this.transactionManager.beginTransaction();
                                    try {
                                        systemBroker.getOrCreateCollection(txn, XmldbURI.ROOT_COLLECTION_URI);
                                        this.transactionManager.commit(txn);
                                    }
                                    catch (IOException | TriggerException | PermissionDeniedException e) {
                                        this.transactionManager.abort(txn);
                                    }
                                    finally {
                                        this.transactionManager.close(txn);
                                    }
                                }
                                catch (PermissionDeniedException pde) {
                                    LOG.fatal(pde.getMessage(), (Throwable)pde);
                                }
                            }
                        }
                        if (!exportOnly) {
                            try {
                                this.initialiseSystemCollections(systemBroker);
                            }
                            catch (PermissionDeniedException pde) {
                                LOG.error(pde.getMessage(), (Throwable)pde);
                                throw new EXistException(pde.getMessage(), pde);
                            }
                        }
                        this.statusReporter.setStatus("ready");
                        try {
                            this.servicesManager.startSystemServices(systemBroker);
                        }
                        catch (BrokerPoolServiceException e) {
                            throw new EXistException(e);
                        }
                        if (this.isRecoveryEnabled() && recovered) {
                            if (!exportOnly) {
                                this.reportStatus("Reindexing database files...");
                                try {
                                    systemBroker.repair();
                                }
                                catch (PermissionDeniedException e) {
                                    LOG.warn("Error during recovery: " + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (((Boolean)this.conf.getProperty("db-connection.recovery.consistency-check")).booleanValue()) {
                                ConsistencyCheckTask task = new ConsistencyCheckTask();
                                Properties props = new Properties();
                                props.setProperty("backup", "no");
                                props.setProperty("output", "sanity");
                                task.configure(this.conf, props);
                                task.execute(systemBroker);
                            }
                        }
                        this.statusReporter.setStatus("writable");
                        if (!exportOnly) {
                            try {
                                this.initialiseTriggersForCollections(systemBroker, XmldbURI.SYSTEM_COLLECTION_URI);
                            }
                            catch (PermissionDeniedException pde) {
                                LOG.error(pde.getMessage(), (Throwable)pde);
                            }
                        }
                        try {
                            systemBroker.cleanUpTempResources(true);
                        }
                        catch (PermissionDeniedException pde) {
                            LOG.error(pde.getMessage(), (Throwable)pde);
                        }
                        this.sync(systemBroker, Sync.MAJOR);
                        try {
                            this.servicesManager.startPreMultiUserSystemServices(systemBroker);
                        }
                        catch (BrokerPoolServiceException e) {
                            throw new EXistException(e);
                        }
                    }
                    for (int i = 1; i < this.minBrokers; ++i) {
                        this.createBroker();
                    }
                    this.status.process((Enum)Event.INITIALIZE_MULTI_USER_MODE);
                    AgentFactory.getInstance().initDBInstance(this);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("database instance '" + this.instanceName + "' initialized");
                    }
                    this.servicesManager.startMultiUserServices(this);
                    this.status.process((Enum)Event.READY);
                    this.statusReporter.setStatus("started");
                }
                catch (Throwable t) {
                    this.transactionManager.shutdown();
                    throw t;
                }
            }
            catch (EXistException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new EXistException(t.getMessage(), t);
            }
        }
        finally {
            if (this.statusReporter != null) {
                this.statusReporter.terminate();
                this.statusReporter = null;
            }
        }
    }

    private void initialiseSystemCollection(DBBroker sysBroker, XmldbURI sysCollectionUri, int permissions) throws EXistException, PermissionDeniedException {
        Collection collection = sysBroker.getCollection(sysCollectionUri);
        if (collection == null) {
            TransactionManager transact = this.getTransactionManager();
            try (Txn txn = transact.beginTransaction();){
                collection = sysBroker.getOrCreateCollection(txn, sysCollectionUri);
                if (collection == null) {
                    throw new IOException("Could not create system collection: " + sysCollectionUri);
                }
                collection.setPermissions(permissions);
                sysBroker.saveCollection(txn, collection);
                transact.commit(txn);
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "Initialisation of system collections failed: " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                throw new EXistException(msg, e);
            }
        }
    }

    private void initialiseSystemCollections(DBBroker broker) throws EXistException, PermissionDeniedException {
        this.initialiseSystemCollection(broker, XmldbURI.SYSTEM_COLLECTION_URI, 493);
    }

    private void initialiseTriggersForCollections(DBBroker broker, XmldbURI uri) throws EXistException, PermissionDeniedException {
        Collection collection = broker.getCollection(uri);
        if (collection != null) {
            CollectionConfigurationManager manager = this.getConfigurationManager();
            CollectionConfiguration collConf = manager.getOrCreateCollectionConfiguration(broker, collection);
            DocumentTriggerProxy triggerProxy = new DocumentTriggerProxy((Class<? extends DocumentTrigger>)ConfigurationDocumentTrigger.class);
            collConf.documentTriggers().add(triggerProxy);
        }
    }

    public boolean runRecovery(DBBroker broker) throws EXistException {
        boolean forceRestart = this.conf.getProperty("db-connection.recovery.force-restart", false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ForceRestart = " + forceRestart);
        }
        if (this.journalManager.isPresent()) {
            RecoveryManager recovery = new RecoveryManager(broker, this.journalManager.get(), forceRestart);
            return recovery.recover();
        }
        throw new IllegalStateException("Cannot run recovery without a JournalManager");
    }

    public long getReservedMem() {
        return this.reservedMem - this.cacheManager.getCurrentSize();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isOperational() {
        return this.status.getCurrentState() == State.OPERATIONAL;
    }

    @Override
    public String getId() {
        return this.instanceName;
    }

    public int active() {
        return this.activeBrokers.size();
    }

    @Override
    public int countActiveBrokers() {
        return this.activeBrokers.size();
    }

    public Map<Thread, DBBroker> getActiveBrokers() {
        return new HashMap<Thread, DBBroker>(this.activeBrokers);
    }

    public int available() {
        return this.inactiveBrokers.size();
    }

    public int getMax() {
        return this.maxBrokers;
    }

    public int total() {
        return this.brokersCount;
    }

    public final boolean isInstanceConfigured() {
        return this.conf != null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    public Optional<ExistRepository> getExpathRepo() {
        return this.expathRepo;
    }

    public void registerShutdownListener(ShutdownListener listener) {
        this.shutdownListener = listener;
    }

    @Override
    public NodeIdFactory getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public SymbolTable getSymbols() {
        return this.symbols;
    }

    @Override
    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecoveryEnabled() {
        Boolean bl = this.readOnly;
        synchronized (bl) {
            return this.readOnly == false && this.recoveryEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() {
        Boolean bl = this.readOnly;
        synchronized (bl) {
            long freeSpace;
            if (!this.readOnly.booleanValue() && (freeSpace = FileUtils.measureFileStore(this.dataLock.getFile(), (FunctionE<FileStore, Long, IOException>)((FunctionE)FileStore::getUsableSpace))) != -1L && freeSpace < this.diskSpaceMin) {
                LOG.fatal("Partition containing DATA_DIR: " + this.dataLock.getFile().toAbsolutePath().toString() + " is running out of disk space [" + freeSpace + "]. Switching eXist-db to read only to prevent data loss!");
                this.setReadOnly();
            }
            return this.readOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly() {
        LOG.warn("Switching database into read-only mode!");
        Boolean bl = this.readOnly;
        synchronized (bl) {
            this.readOnly = true;
        }
    }

    public boolean isInServiceMode() {
        return this.inServiceMode;
    }

    public Optional<JournalManager> getJournalManager() {
        return this.journalManager;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public CollectionConfigurationManager getConfigurationManager() {
        return this.collectionConfigurationManager;
    }

    public CollectionCache getCollectionsCache() {
        return this.collectionCache;
    }

    @Override
    public DefaultCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public CollectionCacheManager getCollectionCacheMgr() {
        return this.collectionCacheMgr;
    }

    @Override
    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public XQueryPool getXQueryPool() {
        return this.xQueryPool;
    }

    public XQuery getXQueryService() {
        return this.xqueryService;
    }

    @Override
    public ProcessMonitor getProcessMonitor() {
        return this.processMonitor;
    }

    @Override
    public PerformanceStats getPerformanceStats() {
        return this.xqueryStats;
    }

    public XMLReaderPool getParserPool() {
        return this.xmlReaderPool;
    }

    public Lock getGlobalUpdateLock() {
        return this.globalXUpdateLock;
    }

    protected DBBroker createBroker() throws EXistException {
        DBBroker broker = BrokerFactory.getInstance(this, this.getConfiguration());
        this.inactiveBrokers.push(broker);
        ++this.brokersCount;
        broker.setId(broker.getClass().getName() + '_' + this.instanceName + "_" + this.brokersCount);
        LOG.debug("created broker '" + broker.getId() + " for database instance '" + this.instanceName + "'");
        return broker;
    }

    @Override
    public DBBroker getActiveBroker() {
        DBBroker broker = this.activeBrokers.get(Thread.currentThread());
        if (broker == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Broker was not obtained for thread '");
            sb.append(Thread.currentThread());
            sb.append("'.");
            sb.append(System.getProperty("line.separator"));
            for (Map.Entry<Thread, DBBroker> entry : this.activeBrokers.entrySet()) {
                sb.append(entry.getKey());
                sb.append(" = ");
                sb.append(entry.getValue());
                sb.append(System.getProperty("line.separator"));
            }
            LOG.debug(sb.toString());
            throw new RuntimeException(sb.toString());
        }
        return broker;
    }

    @Override
    public DBBroker authenticate(String username, Object credentials) throws AuthenticationException {
        Subject subject = this.getSecurityManager().authenticate(username, credentials);
        try {
            return this.get(Optional.ofNullable(subject));
        }
        catch (Exception e) {
            throw new AuthenticationException(-1, (Throwable)e);
        }
    }

    @Override
    public DBBroker getBroker() throws EXistException {
        return this.get(Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBBroker get(Optional<Subject> subject) throws EXistException {
        Objects.requireNonNull(subject, "Subject cannot be null, use BrokerPool#getBroker() instead");
        if (!this.isInstanceConfigured()) {
            throw new EXistException("database instance '" + this.instanceName + "' is not available");
        }
        DBBroker broker = this.activeBrokers.get(Thread.currentThread());
        if (broker != null) {
            broker.incReferenceCount();
            broker.pushSubject(subject.orElseGet(broker::getCurrentSubject));
            if (LOG.isTraceEnabled()) {
                if (!this.brokerLeaseChangeTrace.containsKey(broker.getId())) {
                    this.brokerLeaseChangeTrace.put(broker.getId(), new TraceableStateChanges());
                }
                this.brokerLeaseChangeTrace.get(broker.getId()).add(TraceableBrokerLeaseChange.get(new TraceableBrokerLeaseChange.BrokerInfo(broker.getId(), broker.getReferenceCount())));
            }
            return broker;
        }
        while (this.serviceModeUser != null && subject.isPresent() && !subject.equals(Optional.ofNullable(this.serviceModeUser))) {
            try {
                LOG.debug("Db instance is in service mode. Waiting for db to become available again ...");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.inactiveBrokers.isEmpty()) {
                if (this.brokersCount < this.maxBrokers) {
                    this.createBroker();
                } else {
                    while (this.inactiveBrokers.isEmpty()) {
                        LOG.debug("waiting for a broker to become available");
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            broker = this.inactiveBrokers.pop();
            this.activeBrokers.put(Thread.currentThread(), broker);
            if (LOG.isTraceEnabled()) {
                LOG.trace("+++ " + Thread.currentThread() + Stacktrace.top(Thread.currentThread().getStackTrace(), 10));
            }
            if (this.watchdog.isPresent()) {
                this.watchdog.get().add(broker);
            }
            broker.incReferenceCount();
            broker.pushSubject(subject.orElseGet(this.securityManager::getGuestSubject));
            if (LOG.isTraceEnabled()) {
                if (!this.brokerLeaseChangeTrace.containsKey(broker.getId())) {
                    this.brokerLeaseChangeTrace.put(broker.getId(), new TraceableStateChanges());
                }
                this.brokerLeaseChangeTrace.get(broker.getId()).add(TraceableBrokerLeaseChange.get(new TraceableBrokerLeaseChange.BrokerInfo(broker.getId(), broker.getReferenceCount())));
            }
            this.notifyAll();
            return broker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(DBBroker broker) {
        Objects.requireNonNull(broker, "Cannot release nothing");
        if (LOG.isTraceEnabled()) {
            if (!this.brokerLeaseChangeTrace.containsKey(broker.getId())) {
                this.brokerLeaseChangeTrace.put(broker.getId(), new TraceableStateChanges());
            }
            this.brokerLeaseChangeTrace.get(broker.getId()).add(TraceableBrokerLeaseChange.release(new TraceableBrokerLeaseChange.BrokerInfo(broker.getId(), broker.getReferenceCount())));
        }
        broker.decReferenceCount();
        if (broker.getReferenceCount() > 0) {
            broker.popSubject();
            return;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            Subject lastUser;
            for (DBBroker dBBroker : this.inactiveBrokers) {
                if (broker != dBBroker) continue;
                LOG.error("Broker " + broker.getId() + " is already in the inactive list!!!");
                return;
            }
            if (this.activeBrokers.remove(Thread.currentThread()) == null) {
                LOG.error("release() has been called from the wrong thread for broker " + broker.getId());
                for (Map.Entry entry : this.activeBrokers.entrySet()) {
                    if (entry.getValue() != broker) continue;
                    String msg = "release() has been called from '" + Thread.currentThread() + "', but occupied at '" + entry.getKey() + "'.";
                    EXistException ex = new EXistException(msg);
                    LOG.error(msg, (Throwable)ex);
                    this.activeBrokers.remove(entry.getKey());
                    break;
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("--- " + Thread.currentThread() + Stacktrace.top(Thread.currentThread().getStackTrace(), 10));
            }
            if ((lastUser = broker.popSubject()) == null || broker.getCurrentSubject() != null) {
                LOG.warn("Broker " + broker.getId() + " was returned with extraneous Subjects, cleaning...", new IllegalStateException("DBBroker pushSubject/popSubject mismatch").fillInStackTrace());
                if (LOG.isTraceEnabled()) {
                    broker.traceSubjectChanges();
                }
                while (broker.getCurrentSubject() != null) {
                    lastUser = broker.popSubject();
                }
            }
            this.inactiveBrokers.push(broker);
            this.watchdog.ifPresent(wd -> wd.remove(broker));
            if (LOG.isTraceEnabled()) {
                if (!this.brokerLeaseChangeTraceHistory.containsKey(broker.getId())) {
                    this.brokerLeaseChangeTraceHistory.put(broker.getId(), new ArrayList());
                }
                try {
                    this.brokerLeaseChangeTraceHistory.get(broker.getId()).add((TraceableStateChanges)this.brokerLeaseChangeTrace.get(broker.getId()).clone());
                    this.brokerLeaseChangeTrace.get(broker.getId()).clear();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    LOG.error((Object)cloneNotSupportedException);
                }
                broker.clearSubjectChangesTrace();
            }
            if (this.activeBrokers.size() == 0) {
                if (this.syncRequired) {
                    this.sync(broker, this.syncEvent);
                    this.syncRequired = false;
                    this.checkpoint = false;
                }
                if (this.serviceModeUser != null && !lastUser.equals(this.serviceModeUser)) {
                    this.inServiceMode = true;
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBBroker enterServiceMode(Subject user) throws PermissionDeniedException {
        if (!user.hasDbaRole()) {
            throw new PermissionDeniedException("Only users of group dba can switch the db to service mode");
        }
        this.serviceModeUser = user;
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.activeBrokers.size() != 0) {
                while (!this.inServiceMode) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.inServiceMode = true;
        DBBroker broker = this.inactiveBrokers.peek();
        this.checkpoint = true;
        this.sync(broker, Sync.MAJOR);
        this.checkpoint = false;
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitServiceMode(Subject user) throws PermissionDeniedException {
        if (!user.equals(this.serviceModeUser)) {
            throw new PermissionDeniedException("The db has been locked by a different user");
        }
        this.serviceModeUser = null;
        this.inServiceMode = false;
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            this.notifyAll();
        }
    }

    public void reportStatus(String message) {
        if (this.statusReporter != null) {
            this.statusReporter.setStatus(message);
        }
    }

    public long getMajorSyncPeriod() {
        return this.majorSyncPeriod;
    }

    public long getLastMajorSync() {
        return this.lastMajorSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(DBBroker broker, Sync syncEvent) {
        block9: {
            broker.sync(syncEvent);
            try {
                broker.pushSubject(this.securityManager.getSystemSubject());
                if (syncEvent == Sync.MAJOR) {
                    LOG.debug("Major sync");
                    try {
                        if (!FORCE_CORRUPTION) {
                            this.transactionManager.checkpoint(this.checkpoint);
                        }
                    }
                    catch (TransactionException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                    this.cacheManager.checkCaches();
                    if (this.pluginManager != null) {
                        this.pluginManager.sync(broker);
                    }
                    this.lastMajorSync = System.currentTimeMillis();
                    if (LOG.isDebugEnabled()) {
                        this.notificationService.debug();
                    }
                    break block9;
                }
                this.cacheManager.checkDistribution();
            }
            finally {
                broker.popSubject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSync(Sync syncEvent) {
        State s = (State)this.status.getCurrentState();
        if (s == State.SHUTDOWN || s == State.SHUTTING_DOWN) {
            return;
        }
        LOG.debug("Triggering sync: " + (Object)((Object)syncEvent));
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.inactiveBrokers.size() == this.brokersCount) {
                DBBroker broker = this.inactiveBrokers.pop();
                this.sync(broker, syncEvent);
                this.inactiveBrokers.push(broker);
                this.syncRequired = false;
            } else {
                this.syncEvent = syncEvent;
                this.syncRequired = true;
            }
        }
    }

    public void triggerSystemTask(SystemTask task) {
        State s = (State)this.status.getCurrentState();
        if (s == State.SHUTTING_DOWN) {
            LOG.info("Skipping SystemTask: '" + task.getName() + "' as database is shutting down...");
            return;
        }
        if (s == State.SHUTDOWN) {
            LOG.warn("Unable to execute SystemTask: '" + task.getName() + "' as database is shut down!");
            return;
        }
        this.transactionManager.triggerSystemTask(task);
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    public boolean isShuttingDown() {
        return this.status.getCurrentState() == State.SHUTTING_DOWN;
    }

    public boolean isShutDown() {
        return this.status.getCurrentState() == State.SHUTDOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean killed) {
        try {
            this.status.process((Enum)Event.START_SHUTDOWN);
        }
        catch (IllegalStateException e) {
            LOG.warn((Object)e);
            return;
        }
        try {
            LOG.info("Database is shutting down ...");
            this.processMonitor.stopRunningJobs();
            this.scheduler.shutdown(true);
            Lock lock = this.transactionManager.getLock();
            try {
                lock.lock();
                BrokerPool brokerPool = this;
                synchronized (brokerPool) {
                    this.statusReporter = new StatusReporter("shutdown");
                    this.statusObservers.forEach(this.statusReporter::addObserver);
                    Thread statusThread = new Thread(this.statusReporter);
                    statusThread.start();
                    lock.unlock();
                    if (LOG.isDebugEnabled()) {
                        this.notificationService.debug();
                    }
                    this.processMonitor.killAll(500L);
                    if (this.isRecoveryEnabled()) {
                        this.journalManager.ifPresent(jm -> jm.flush(true, true));
                    }
                    long waitStart = System.currentTimeMillis();
                    if (this.activeBrokers.size() > 0) {
                        this.printSystemInfo();
                        LOG.info("Waiting " + this.maxShutdownWait + "ms for remaining threads to shut down...");
                        while (this.activeBrokers.size() > 0) {
                            try {
                                this.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (this.maxShutdownWait <= -1L || System.currentTimeMillis() - waitStart <= this.maxShutdownWait) continue;
                            LOG.warn("Not all threads returned. Forcing shutdown ...");
                            break;
                        }
                    }
                    LOG.debug("Calling shutdown ...");
                    DBBroker broker = null;
                    if (this.inactiveBrokers.isEmpty()) {
                        try {
                            broker = this.createBroker();
                        }
                        catch (EXistException e) {
                            LOG.warn("could not create instance for shutdown. Giving up.");
                        }
                    } else {
                        broker = this.inactiveBrokers.peek();
                    }
                    try {
                        if (broker != null) {
                            broker.pushSubject(this.securityManager.getSystemSubject());
                        }
                        try {
                            this.servicesManager.stopServices(broker);
                        }
                        catch (BrokerPoolServicesManagerException e) {
                            for (BrokerPoolServiceException bpse : e.getServiceExceptions()) {
                                LOG.error(bpse.getMessage(), (Throwable)bpse);
                            }
                        }
                        broker.shutdown();
                    }
                    finally {
                        if (broker != null) {
                            broker.popSubject();
                        }
                    }
                    this.servicesManager.shutdown();
                    AgentFactory.getInstance().closeDBInstance(this);
                    BrokerPool.removeInstance(this.instanceName);
                    Boolean bl = this.readOnly;
                    synchronized (bl) {
                        if (!this.readOnly.booleanValue()) {
                            this.dataLock.release();
                        }
                    }
                    this.clearThreadLocals();
                    LOG.info("shutdown complete !");
                    if (this.shutdownListener != null) {
                        this.shutdownListener.shutdown(this.instanceName, BrokerPool.instancesCount());
                    }
                    this.statusReporter.terminate();
                    this.statusReporter = null;
                }
            }
            finally {
                Configurator.clear(this);
                this.transactionManager = null;
                this.collectionCache = null;
                this.collectionCacheMgr = null;
                this.xQueryPool = null;
                this.processMonitor = null;
                this.collectionConfigurationManager = null;
                this.notificationService = null;
                this.indexManager = null;
                this.xmlReaderPool = null;
                this.shutdownListener = null;
                this.securityManager = null;
                this.notificationService = null;
                this.statusObservers.clear();
            }
        }
        finally {
            this.status.process((Enum)Event.FINISHED_SHUTDOWN);
        }
    }

    @Override
    public void addStatusObserver(Observer statusObserver) {
        this.statusObservers.add(statusObserver);
    }

    @Override
    public boolean removeStatusObserver(Observer statusObserver) {
        return this.statusObservers.remove(statusObserver);
    }

    private void clearThreadLocals() {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            try {
                this.cleanThreadLocalsForThread(thread);
            }
            catch (EXistException ex) {
                LOG.warn("Could not clear ThreadLocals for thread: " + thread.getName());
            }
        }
    }

    private void cleanThreadLocalsForThread(Thread thread) throws EXistException {
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Object threadLocalTable = threadLocalsField.get(thread);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = threadLocalMapClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Object table = tableField.get(threadLocalTable);
            Field referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
            for (int i = 0; i < Array.getLength(table); ++i) {
                Object entry = Array.get(table, i);
                if (entry == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)referentField.get(entry);
                threadLocal.remove();
            }
        }
        catch (Exception e) {
            throw new EXistException(e);
        }
    }

    public Optional<BrokerWatchdog> getWatchdog() {
        return this.watchdog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCheckpoint() {
        if (this.syncRequired) {
            return;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            this.syncEvent = Sync.MAJOR;
            this.syncRequired = true;
            this.checkpoint = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Debuggee getDebuggee() {
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.debuggee == null) {
                this.debuggee = DebuggeeFactory.getInstance();
            }
        }
        return this.debuggee;
    }

    public Calendar getStartupTime() {
        return this.startupTime;
    }

    public void printSystemInfo() {
        try (StringWriter sout = new StringWriter();
             PrintWriter writer = new PrintWriter(sout);){
            writer.println("SYSTEM INFO");
            writer.format("Database instance: %s\n", this.getId());
            writer.println("-------------------------------------------------------------------");
            this.watchdog.ifPresent(wd -> wd.dump(writer));
            DeadlockDetection.debug(writer);
            String s = sout.toString();
            LOG.info(s);
            System.err.println(s);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public Path getStoragePlace() {
        return (Path)this.conf.getProperty("db-connection.data-dir");
    }

    public List<TriggerProxy<? extends DocumentTrigger>> getDocumentTriggers() {
        return this.documentTriggers;
    }

    public List<TriggerProxy<? extends CollectionTrigger>> getCollectionTriggers() {
        return this.collectionTriggers;
    }

    @Override
    public void registerDocumentTrigger(Class<? extends DocumentTrigger> clazz) {
        this.documentTriggers.add(new DocumentTriggerProxy(clazz));
    }

    @Override
    public void registerCollectionTrigger(Class<? extends CollectionTrigger> clazz) {
        this.collectionTriggers.add(new CollectionTriggerProxy(clazz));
    }

    @Override
    public PluginsManager getPluginsManager() {
        return this.pluginManager;
    }

    @Override
    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    private static class TraceableBrokerLeaseChange
    extends TraceableStateChange<BrokerInfo, Change> {
        private TraceableBrokerLeaseChange(Change change, BrokerInfo brokerInfo) {
            super(change, brokerInfo);
        }

        @Override
        public String getId() {
            return ((BrokerInfo)this.getState()).id;
        }

        @Override
        public String describeState() {
            return Integer.toString(((BrokerInfo)this.getState()).referenceCount);
        }

        static TraceableBrokerLeaseChange get(BrokerInfo brokerInfo) {
            return new TraceableBrokerLeaseChange(Change.GET, brokerInfo);
        }

        static TraceableBrokerLeaseChange release(BrokerInfo brokerInfo) {
            return new TraceableBrokerLeaseChange(Change.RELEASE, brokerInfo);
        }

        public static class BrokerInfo {
            final String id;
            final int referenceCount;

            public BrokerInfo(String id, int referenceCount) {
                this.id = id;
                this.referenceCount = referenceCount;
            }
        }

        public static enum Change {
            GET,
            RELEASE;

        }
    }

    private static class StatusReporter
    extends Observable
    implements Runnable {
        private String status;
        private volatile boolean terminate = false;

        public StatusReporter(String status) {
            this.status = status;
        }

        public synchronized void setStatus(String status) {
            this.status = status;
            this.setChanged();
            this.notifyObservers(status);
        }

        public synchronized void terminate() {
            this.terminate = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.terminate) {
                StatusReporter statusReporter = this;
                synchronized (statusReporter) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.setChanged();
                this.notifyObservers(this.status);
            }
        }
    }

    private static enum Event {
        INITIALIZE,
        INITIALIZE_SYSTEM_MODE,
        INITIALIZE_MULTI_USER_MODE,
        READY,
        START_SHUTDOWN,
        FINISHED_SHUTDOWN;

    }

    private static enum State {
        SHUTTING_DOWN,
        SHUTDOWN,
        INITIALIZING,
        INITIALIZING_SYSTEM_MODE,
        INITIALIZING_MULTI_USER_MODE,
        OPERATIONAL;

    }
}

