/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import com.evolvedbinary.j8fu.fsm.AtomicFSM;
import com.evolvedbinary.j8fu.fsm.EventProcessor;
import com.evolvedbinary.j8fu.fsm.FSM;
import com.evolvedbinary.j8fu.fsm.TransitionTable;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.exist.security.UnixStylePermission;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.BrokerPoolServicesManagerException;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;

@NotThreadSafe
class BrokerPoolServicesManager {
    private FSM<ManagerState, ManagerEvent> states = new AtomicFSM((Enum)ManagerState.REGISTRATION, (EventProcessor)TransitionTable.transitionTable(ManagerState.class, ManagerEvent.class).when((Enum)ManagerState.REGISTRATION).on((Enum)ManagerEvent.CONFIGURE).switchTo((Enum)ManagerState.CONFIGURATION).on((Enum)ManagerEvent.PREPARE).switchTo((Enum)ManagerState.PREPARATION).on((Enum)ManagerEvent.ENTER_SYSTEM_MODE).switchTo((Enum)ManagerState.SYSTEM).on((Enum)ManagerEvent.PREPARE_ENTER_MULTI_USER_MODE).switchTo((Enum)ManagerState.PRE_MULTI_USER).on((Enum)ManagerEvent.ENTER_MULTI_USER_MODE).switchTo((Enum)ManagerState.MULTI_USER).on((Enum)ManagerEvent.STOP).switchTo((Enum)ManagerState.STOPPING).on((Enum)ManagerEvent.SHUTDOWN).switchTo((Enum)ManagerState.SHUTTING_DOWN).build());
    final List<BrokerPoolService> brokerPoolServices = new ArrayList<BrokerPoolService>();

    BrokerPoolServicesManager() {
    }

    <T extends BrokerPoolService> T register(T brokerPoolService) {
        ManagerState currentState = (ManagerState)this.states.getCurrentState();
        if (currentState != ManagerState.REGISTRATION) {
            throw new IllegalStateException("Services may only be registered during the registration state. Current state is: " + currentState.name());
        }
        this.brokerPoolServices.add(brokerPoolService);
        if (UnixStylePermission.LOG.isTraceEnabled()) {
            UnixStylePermission.LOG.trace("Registered service: " + brokerPoolService.getClass().getSimpleName() + "...");
        }
        return brokerPoolService;
    }

    void configureServices(Configuration configuration) throws BrokerPoolServiceException {
        this.states.process((Enum)ManagerEvent.CONFIGURE);
        for (BrokerPoolService brokerPoolService : this.brokerPoolServices) {
            if (UnixStylePermission.LOG.isTraceEnabled()) {
                UnixStylePermission.LOG.trace("Configuring service: " + brokerPoolService.getClass().getSimpleName() + "...");
            }
            brokerPoolService.configure(configuration);
        }
    }

    void prepareServices(BrokerPool brokerPool) throws BrokerPoolServiceException {
        this.states.process((Enum)ManagerEvent.PREPARE);
        for (BrokerPoolService brokerPoolService : this.brokerPoolServices) {
            if (UnixStylePermission.LOG.isTraceEnabled()) {
                UnixStylePermission.LOG.trace("Preparing service: " + brokerPoolService.getClass().getSimpleName() + "...");
            }
            brokerPoolService.prepare(brokerPool);
        }
    }

    void startSystemServices(DBBroker systemBroker) throws BrokerPoolServiceException {
        this.states.process((Enum)ManagerEvent.ENTER_SYSTEM_MODE);
        for (BrokerPoolService brokerPoolService : this.brokerPoolServices) {
            if (UnixStylePermission.LOG.isTraceEnabled()) {
                UnixStylePermission.LOG.trace("Notifying service: " + brokerPoolService.getClass().getSimpleName() + " of start system...");
            }
            brokerPoolService.startSystem(systemBroker);
        }
    }

    void startPreMultiUserSystemServices(DBBroker systemBroker) throws BrokerPoolServiceException {
        this.states.process((Enum)ManagerEvent.PREPARE_ENTER_MULTI_USER_MODE);
        for (BrokerPoolService brokerPoolService : this.brokerPoolServices) {
            if (UnixStylePermission.LOG.isTraceEnabled()) {
                UnixStylePermission.LOG.trace("Notifying service: " + brokerPoolService.getClass().getSimpleName() + " of start pre-multi-user...");
            }
            brokerPoolService.startPreMultiUserSystem(systemBroker);
        }
    }

    void startMultiUserServices(BrokerPool brokerPool) throws BrokerPoolServiceException {
        this.states.process((Enum)ManagerEvent.ENTER_MULTI_USER_MODE);
        for (BrokerPoolService brokerPoolService : this.brokerPoolServices) {
            if (UnixStylePermission.LOG.isTraceEnabled()) {
                UnixStylePermission.LOG.trace("Notifying service: " + brokerPoolService.getClass().getSimpleName() + " of start multi-user...");
            }
            brokerPoolService.startMultiUser(brokerPool);
        }
    }

    void stopServices(DBBroker systemBroker) throws BrokerPoolServicesManagerException {
        this.states.process((Enum)ManagerEvent.STOP);
        ArrayList<BrokerPoolServiceException> serviceExceptions = null;
        for (int i = this.brokerPoolServices.size() - 1; i >= 0; --i) {
            BrokerPoolService brokerPoolService = this.brokerPoolServices.get(i);
            if (UnixStylePermission.LOG.isTraceEnabled()) {
                UnixStylePermission.LOG.trace("Stopping service: " + brokerPoolService.getClass().getSimpleName() + "...");
            }
            try {
                brokerPoolService.stop(systemBroker);
                continue;
            }
            catch (BrokerPoolServiceException e) {
                if (serviceExceptions == null) {
                    serviceExceptions = new ArrayList<BrokerPoolServiceException>();
                }
                serviceExceptions.add(e);
            }
        }
        if (serviceExceptions != null) {
            throw new BrokerPoolServicesManagerException(serviceExceptions);
        }
    }

    void shutdown() {
        this.states.process((Enum)ManagerEvent.SHUTDOWN);
        for (int i = this.brokerPoolServices.size() - 1; i >= 0; --i) {
            BrokerPoolService brokerPoolService = this.brokerPoolServices.get(i);
            if (UnixStylePermission.LOG.isTraceEnabled()) {
                UnixStylePermission.LOG.trace("Shutting down service: " + brokerPoolService.getClass().getSimpleName() + "...");
            }
            brokerPoolService.shutdown();
        }
    }

    private static enum ManagerEvent {
        CONFIGURE,
        PREPARE,
        ENTER_SYSTEM_MODE,
        PREPARE_ENTER_MULTI_USER_MODE,
        ENTER_MULTI_USER_MODE,
        STOP,
        SHUTDOWN;

    }

    private static enum ManagerState {
        REGISTRATION,
        CONFIGURATION,
        PREPARATION,
        SYSTEM,
        PRE_MULTI_USER,
        MULTI_USER,
        STOPPING,
        SHUTTING_DOWN;

    }
}

