/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import org.exist.EXistException;
import org.exist.storage.DBBroker;

public class BrokerWatchdog {
    public static final String TRACE_BROKERS_PROPERTY_NAME = "trace.brokers";
    private static final DateFormat df = DateFormat.getDateTimeInstance();
    private static final String EOL = System.getProperty("line.separator");
    private final Map<DBBroker, WatchedBroker> watched = new IdentityHashMap<DBBroker, WatchedBroker>();

    public void add(DBBroker broker) throws EXistException {
        WatchedBroker old = this.watched.get(broker);
        if (old == null) {
            this.checkForTimeout();
            this.watched.put(broker, new WatchedBroker(broker));
        } else {
            old.timeAdded = System.currentTimeMillis();
            old.trace();
        }
    }

    public void remove(DBBroker broker) {
        this.watched.remove(broker);
    }

    public String get(DBBroker broker) {
        WatchedBroker w = this.watched.get(broker);
        if (w != null) {
            return w.trace.toString();
        }
        return "";
    }

    public void checkForTimeout() throws EXistException {
        for (WatchedBroker broker : this.watched.values()) {
            if (System.currentTimeMillis() - broker.timeAdded <= 30000L) continue;
            throw new EXistException("Broker: " + broker.broker.getId() + " did not return for 30sec." + EOL + EOL + broker.trace.toString());
        }
    }

    public void dump(PrintWriter writer) {
        writer.println("Active brokers:");
        for (WatchedBroker broker : this.watched.values()) {
            writer.format("%20s: %s%s", "Broker", broker.broker.getId(), EOL);
            writer.format("%20s: %s%s", "Active since", df.format(new Date(broker.timeAdded)), EOL);
            writer.println("");
            writer.println("Stack:");
            writer.println(broker.trace);
            writer.println("----------------------------------------------------------------");
        }
    }

    private static class WatchedBroker {
        private final DBBroker broker;
        private long timeAdded;
        private final StringBuilder trace;

        WatchedBroker(DBBroker broker) {
            this.broker = broker;
            this.timeAdded = System.currentTimeMillis();
            this.trace = new StringBuilder();
            this.trace();
        }

        void trace() {
            this.trace.append("Reference count: ").append(this.broker.getReferenceCount()).append(EOL);
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            int showElementCount = stack.length > 20 ? 20 : stack.length;
            for (int i = 4; i < showElementCount; ++i) {
                this.trace.append(stack[i].toString()).append(EOL);
            }
            this.trace.append(EOL);
        }
    }
}

