/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.ConsistencyCheck;
import org.exist.backup.ErrorReport;
import org.exist.backup.SystemExport;
import org.exist.management.Agent;
import org.exist.management.AgentFactory;
import org.exist.management.TaskStatus;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.ProcessMonitor;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;
import org.exist.xquery.TerminatedException;

public class ConsistencyCheckTask
implements SystemTask {
    private static final Logger LOG = LogManager.getLogger(ConsistencyCheckTask.class);
    private String exportDir;
    private boolean createBackup = false;
    private boolean createZip = true;
    private boolean paused = false;
    private boolean incremental = false;
    private boolean incrementalCheck = false;
    private boolean checkDocs = false;
    private int maxInc = -1;
    private Path lastExportedBackup = null;
    private ProcessMonitor.Monitor monitor = new ProcessMonitor.Monitor();
    public static final String OUTPUT_PROP_NAME = "output";
    public static final String ZIP_PROP_NAME = "zip";
    public static final String BACKUP_PROP_NAME = "backup";
    public static final String INCREMENTAL_PROP_NAME = "incremental";
    public static final String INCREMENTAL_CHECK_PROP_NAME = "incremental-check";
    public static final String MAX_PROP_NAME = "max";
    public static final String CHECK_DOCS_PROP_NAME = "check-documents";
    private static final LoggingCallback logCallback = new LoggingCallback();

    @Override
    public boolean afterCheckpoint() {
        return false;
    }

    @Override
    public String getName() {
        return "Consistency Check Task";
    }

    @Override
    public void configure(Configuration config, Properties properties) throws EXistException {
        this.exportDir = properties.getProperty(OUTPUT_PROP_NAME, "export");
        Path dir = Paths.get(this.exportDir, new String[0]);
        if (!dir.isAbsolute()) {
            dir = ((Path)config.getProperty("db-connection.data-dir")).resolve(this.exportDir);
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new EXistException("Unable to create export directory: " + this.exportDir, ioe);
        }
        this.exportDir = dir.toAbsolutePath().toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using output directory " + this.exportDir);
        }
        String backup = properties.getProperty(BACKUP_PROP_NAME, "no");
        this.createBackup = backup.equalsIgnoreCase("YES");
        String zip = properties.getProperty(ZIP_PROP_NAME, "yes");
        this.createZip = zip.equalsIgnoreCase("YES");
        String inc = properties.getProperty(INCREMENTAL_PROP_NAME, "no");
        this.incremental = inc.equalsIgnoreCase("YES");
        String incCheck = properties.getProperty(INCREMENTAL_CHECK_PROP_NAME, "yes");
        this.incrementalCheck = incCheck.equalsIgnoreCase("YES");
        String max = properties.getProperty(MAX_PROP_NAME, "5");
        try {
            this.maxInc = Integer.parseInt(max);
        }
        catch (NumberFormatException e) {
            throw new EXistException("Parameter 'max' has to be an integer");
        }
        String check = properties.getProperty(CHECK_DOCS_PROP_NAME, "no");
        this.checkDocs = check.equalsIgnoreCase("YES");
    }

    @Override
    public void execute(DBBroker broker) throws EXistException {
        Agent agentInstance = AgentFactory.getInstance();
        BrokerPool brokerPool = broker.getBrokerPool();
        TaskStatus endStatus = new TaskStatus(TaskStatus.Status.STOPPED_OK);
        agentInstance.changeStatus(brokerPool, new TaskStatus(TaskStatus.Status.INIT));
        if (this.paused) {
            LOG.info("Consistency check is paused.");
            agentInstance.changeStatus(brokerPool, new TaskStatus(TaskStatus.Status.PAUSED));
            return;
        }
        brokerPool.getProcessMonitor().startJob(BACKUP_PROP_NAME, null, this.monitor);
        PrintWriter report = null;
        try {
            boolean doBackup = this.createBackup;
            List<ErrorReport> errors = null;
            if (!this.incremental || this.incrementalCheck) {
                LOG.info("Starting consistency check...");
                report = this.openLog();
                CheckCallback cb = new CheckCallback(report);
                ConsistencyCheck check = new ConsistencyCheck(broker, false, this.checkDocs);
                agentInstance.changeStatus(brokerPool, new TaskStatus(TaskStatus.Status.RUNNING_CHECK));
                errors = check.checkAll(cb);
                if (!errors.isEmpty()) {
                    endStatus.setStatus(TaskStatus.Status.STOPPED_ERROR);
                    endStatus.setReason(errors);
                    LOG.error("Errors found: " + errors.size());
                    doBackup = true;
                    if (this.fatalErrorsFound(errors)) {
                        LOG.error("Fatal errors were found: pausing the consistency check task.");
                        this.paused = true;
                    }
                }
                LOG.info("Finished consistency check");
            }
            if (doBackup) {
                LOG.info("Starting backup...");
                SystemExport sysexport = new SystemExport(broker, logCallback, this.monitor, false);
                this.lastExportedBackup = sysexport.export(this.exportDir, this.incremental, this.maxInc, this.createZip, errors);
                agentInstance.changeStatus(brokerPool, new TaskStatus(TaskStatus.Status.RUNNING_BACKUP));
                if (this.lastExportedBackup != null) {
                    LOG.info("Created backup to file: " + this.lastExportedBackup.toAbsolutePath().toString());
                }
                LOG.info("Finished backup");
            }
        }
        catch (PermissionDeniedException | TerminatedException e) {
            throw new EXistException(e.getMessage(), e);
        }
        finally {
            if (report != null) {
                report.close();
            }
            agentInstance.changeStatus(brokerPool, endStatus);
            brokerPool.getProcessMonitor().endJob();
        }
    }

    public Path getLastExportedBackup() {
        return this.lastExportedBackup;
    }

    private boolean fatalErrorsFound(List<ErrorReport> errors) {
        for (ErrorReport error : errors) {
            switch (error.getErrcode()) {
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return false;
    }

    private PrintWriter openLog() throws EXistException {
        try {
            Path file = SystemExport.getUniqueFile("report", ".log", this.exportDir);
            return new PrintWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new EXistException("ERROR: failed to create report file in " + this.exportDir, e);
        }
    }

    private class CheckCallback
    implements ConsistencyCheck.ProgressCallback,
    SystemExport.StatusCallback {
        private final PrintWriter log;
        private boolean errorFound = false;

        private CheckCallback(PrintWriter log) {
            this.log = log;
        }

        @Override
        public void startDocument(String name, int current, int count) throws TerminatedException {
            if (!ConsistencyCheckTask.this.monitor.proceed()) {
                throw new TerminatedException("consistency check terminated");
            }
            if (current % 1000 == 0 || current == count) {
                this.log.write("  DOCUMENT: ");
                this.log.write(Integer.toString(current));
                this.log.write(" of ");
                this.log.write(Integer.valueOf(count).toString());
                this.log.write(10);
                this.log.flush();
            }
        }

        @Override
        public void startCollection(String path) throws TerminatedException {
            if (!ConsistencyCheckTask.this.monitor.proceed()) {
                throw new TerminatedException("consistency check terminated");
            }
            if (this.errorFound) {
                this.log.write("----------------------------------------------\n");
            }
            this.errorFound = false;
            this.log.write("COLLECTION: ");
            this.log.write(path);
            this.log.write(10);
            this.log.flush();
        }

        @Override
        public void error(ErrorReport error) {
            this.log.write("----------------------------------------------\n");
            this.log.write(error.toString());
            this.log.write(10);
            this.log.flush();
        }

        @Override
        public void error(String message, Throwable exception) {
            this.log.write("----------------------------------------------\n");
            this.log.write("EXPORT ERROR: ");
            this.log.write(message);
            this.log.write(10);
            exception.printStackTrace(this.log);
            this.log.flush();
        }
    }

    private static class LoggingCallback
    implements SystemExport.StatusCallback {
        private LoggingCallback() {
        }

        @Override
        public void startCollection(String path) throws TerminatedException {
        }

        @Override
        public void startDocument(String name, int current, int count) throws TerminatedException {
        }

        @Override
        public void error(String message, Throwable exception) {
            LOG.error(message, exception);
        }
    }
}

