/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class CreateBinaryLoggable
extends AbstractLoggable {
    private Path original;

    public CreateBinaryLoggable(DBBroker broker, Txn txn, Path original) {
        super((byte)65, txn.getId());
        this.original = original;
    }

    public CreateBinaryLoggable(DBBroker broker, long transactionId) {
        super((byte)65, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        String originalPath = this.original.toAbsolutePath().toString();
        byte[] data = originalPath.getBytes(StandardCharsets.UTF_8);
        out.putInt(data.length);
        out.put(data);
    }

    @Override
    public void read(ByteBuffer in) {
        int size = in.getInt();
        byte[] data = new byte[size];
        in.get(data);
        this.original = Paths.get(new String(data, StandardCharsets.UTF_8), new String[0]);
    }

    @Override
    public int getLogSize() {
        return 4 + this.original.toAbsolutePath().toString().getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public void redo() throws LogException {
    }

    @Override
    public void undo() throws LogException {
        try {
            Files.delete(this.original);
        }
        catch (IOException ioe) {
            throw new LogException("Cannot delete binary resource: " + this.original.toAbsolutePath().toString(), ioe);
        }
    }

    @Override
    public String dump() {
        return super.dump() + " - create binary " + this.original;
    }
}

