/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.management.Agent;
import org.exist.management.AgentFactory;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.CacheManager;
import org.exist.storage.cache.Cache;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;

public class DefaultCacheManager
implements CacheManager,
BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(DefaultCacheManager.class);
    public static final double MAX_MEM_USE = 0.9;
    public static final double MIN_SHRINK_FACTOR = 0.5;
    public static final double SHRINK_FACTOR = 0.7;
    public static final int DEFAULT_SHRINK_THRESHOLD = 10000;
    public static final String DEFAULT_SHRINK_THRESHOLD_STRING = "10000";
    public static final int DEFAULT_CACHE_SIZE = 64;
    public static final String CACHE_SIZE_ATTRIBUTE = "cacheSize";
    public static final String PROPERTY_CACHE_SIZE = "db-connection.cache-size";
    public static final String DEFAULT_CACHE_CHECK_MAX_SIZE_STRING = "true";
    public static final String CACHE_CHECK_MAX_SIZE_ATTRIBUTE = "checkMaxCacheSize";
    public static final String PROPERTY_CACHE_CHECK_MAX_SIZE = "db-connection.check-max-cache-size";
    public static final String SHRINK_THRESHOLD_ATTRIBUTE = "cacheShrinkThreshold";
    public static final String SHRINK_THRESHOLD_PROPERTY = "db-connection.cache-shrink-threshold";
    private List<Cache> caches = new ArrayList<Cache>();
    private long totalMem;
    private int totalPageCount;
    private int currentPageCount = 0;
    private int maxCacheSize;
    private int pageSize;
    private int shrinkThreshold = 10000;
    private Cache lastRequest = null;
    private String instanceName;

    public DefaultCacheManager(BrokerPool pool) {
        int buffers;
        int cacheSize;
        this.instanceName = pool.getId();
        Configuration configuration = pool.getConfiguration();
        this.pageSize = configuration.getInteger("db-connection.page-size");
        if (this.pageSize < 0) {
            this.pageSize = 4096;
        }
        if ((cacheSize = configuration.getInteger(PROPERTY_CACHE_SIZE)) < 0) {
            cacheSize = 64;
        }
        this.shrinkThreshold = configuration.getInteger(SHRINK_THRESHOLD_PROPERTY);
        this.totalMem = (long)cacheSize * 1024L * 1024L;
        Boolean checkMaxCache = (Boolean)configuration.getProperty(PROPERTY_CACHE_CHECK_MAX_SIZE);
        if (checkMaxCache == null || checkMaxCache.booleanValue()) {
            long maxCache;
            long max = Runtime.getRuntime().maxMemory();
            long l = maxCache = max >= 0x30000000L ? max / 2L : max / 3L;
            if (this.totalMem > maxCache) {
                this.totalMem = maxCache;
                LOG.warn("The cacheSize=\"" + cacheSize + "\" setting in conf.xml is too large. Java has only " + max / 1024L + "k available. Cache manager will not use more than " + this.totalMem / 1024L + "k to avoid memory issues which may lead to database corruptions.");
            }
        } else {
            LOG.warn("Checking of Max Cache Size disabled by user, this could cause memory issues which may lead to database corruptions if you don't have enough memory allocated to your JVM!");
        }
        this.totalPageCount = buffers = (int)(this.totalMem / (long)this.pageSize);
        this.maxCacheSize = (int)((double)this.totalPageCount * 0.9);
        NumberFormat nf = NumberFormat.getNumberInstance();
        LOG.info("Cache settings: " + nf.format(this.totalMem / 1024L) + "k; totalPages: " + nf.format(this.totalPageCount) + "; maxCacheSize: " + nf.format(this.maxCacheSize) + "; cacheShrinkThreshold: " + nf.format(this.shrinkThreshold));
        this.registerMBean();
    }

    @Override
    public void registerCache(Cache cache) {
        this.currentPageCount += cache.getBuffers();
        this.caches.add(cache);
        cache.setCacheManager(this);
        this.registerMBean(cache);
    }

    @Override
    public void deregisterCache(Cache cache) {
        for (int i = 0; i < this.caches.size(); ++i) {
            Cache next = this.caches.get(i);
            if (cache != next) continue;
            this.caches.remove(i);
            break;
        }
        this.currentPageCount -= cache.getBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestMem(Cache cache) {
        if (this.currentPageCount >= this.totalPageCount) {
            if (cache.getBuffers() < this.maxCacheSize) {
                this.lastRequest = cache;
            }
            return -1;
        }
        if (cache.getGrowthFactor() > 1.0 && cache.getBuffers() < this.maxCacheSize) {
            DefaultCacheManager defaultCacheManager = this;
            synchronized (defaultCacheManager) {
                if (this.currentPageCount >= this.totalPageCount) {
                    return -1;
                }
                int newCacheSize = (int)((double)cache.getBuffers() * cache.getGrowthFactor());
                if (newCacheSize > this.maxCacheSize) {
                    newCacheSize = this.maxCacheSize;
                }
                if (this.currentPageCount + newCacheSize > this.totalPageCount) {
                    newCacheSize = cache.getBuffers() + (this.totalPageCount - this.currentPageCount);
                }
                if (LOG.isDebugEnabled()) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    LOG.debug("Growing cache " + cache.getName() + " (a " + cache.getClass().getName() + ") from " + nf.format(cache.getBuffers()) + " to " + nf.format(newCacheSize));
                }
                this.currentPageCount -= cache.getBuffers();
                cache.resize(newCacheSize);
                this.currentPageCount += newCacheSize;
                return newCacheSize;
            }
        }
        return -1;
    }

    @Override
    public void checkCaches() {
        int minSize = (int)((double)this.totalPageCount * 0.5);
        if (this.shrinkThreshold >= 0) {
            for (int i = 0; i < this.caches.size(); ++i) {
                Cache cache = this.caches.get(i);
                if (!(cache.getGrowthFactor() > 1.0)) continue;
                int load = cache.getLoad();
                if (cache.getBuffers() <= minSize || load >= this.shrinkThreshold) continue;
                if (LOG.isDebugEnabled()) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    LOG.debug("Shrinking cache: " + cache.getName() + " (a " + cache.getClass().getName() + ") to " + nf.format(cache.getBuffers()));
                }
                this.currentPageCount -= cache.getBuffers();
                cache.resize(this.getDefaultInitialSize());
                this.currentPageCount += this.getDefaultInitialSize();
            }
        }
    }

    @Override
    public void checkDistribution() {
        if (this.lastRequest == null) {
            return;
        }
        int minSize = (int)((double)this.totalPageCount * 0.5);
        for (int i = 0; i < this.caches.size(); ++i) {
            Cache cache = this.caches.get(i);
            if (cache.getBuffers() < minSize) continue;
            int newSize = (int)((double)cache.getBuffers() * 0.7);
            if (LOG.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.debug("Shrinking cache: " + cache.getName() + " (a " + cache.getClass().getName() + ") to " + nf.format(newSize));
            }
            this.currentPageCount -= cache.getBuffers();
            cache.resize(newSize);
            this.currentPageCount += newSize;
            break;
        }
        this.lastRequest = null;
    }

    @Override
    public long getMaxTotal() {
        return this.totalPageCount;
    }

    @Override
    public long getCurrentSize() {
        return this.currentPageCount * this.pageSize;
    }

    @Override
    public long getMaxSingle() {
        return this.maxCacheSize;
    }

    public long getTotalMem() {
        return this.totalMem;
    }

    @Override
    public int getDefaultInitialSize() {
        return 64;
    }

    private void registerMBean() {
        Agent agent = AgentFactory.getInstance();
        try {
            agent.addMBean(this.instanceName, "org.exist.management." + this.instanceName + ":type=CacheManager", new org.exist.management.CacheManager(this));
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn("Exception while registering cache mbean.", (Throwable)e);
        }
    }

    private void registerMBean(Cache cache) {
        Agent agent = AgentFactory.getInstance();
        try {
            agent.addMBean(this.instanceName, "org.exist.management." + this.instanceName + ":type=CacheManager.Cache,name=" + cache.getName() + ",cache-type=" + cache.getType(), new org.exist.management.Cache(cache));
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn("Exception while registering cache mbean.", (Throwable)e);
        }
    }
}

