/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.exist.storage.btree.Value;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;

public class ElementValue
extends Value {
    public static final byte UNKNOWN = -1;
    public static final byte ELEMENT = 0;
    public static final byte ATTRIBUTE = 1;
    public static final int LENGTH_TYPE = 1;
    public static final int OFFSET_COLLECTION_ID = 0;
    public static final int OFFSET_TYPE = 4;
    public static final int OFFSET_SYMBOL = 5;
    public static final int OFFSET_NSSYMBOL = 7;
    public static final int OFFSET_ID_STRING_VALUE = 5;
    public static final String[] type = new String[]{"element", "attribute", "id"};

    ElementValue(int collectionId) {
        this.len = 4;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, 0);
        this.pos = 0;
    }

    ElementValue(byte type, int collectionId) {
        this.len = 5;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, 0);
        this.data[4] = type;
        this.pos = 0;
    }

    ElementValue(byte type, int collectionId, short symbol) {
        this.len = 7;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, 0);
        this.data[4] = type;
        ByteConversion.shortToByte(symbol, this.data, 5);
        this.pos = 0;
    }

    ElementValue(byte type, int collectionId, short symbol, short nsSymbol) {
        this.len = 14;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, 0);
        this.data[4] = type;
        ByteConversion.shortToByte(symbol, this.data, 5);
        ByteConversion.shortToByte(nsSymbol, this.data, 7);
        this.pos = 0;
    }

    ElementValue(byte type, int collectionId, String idStringValue) {
        this.len = 5 + UTF8.encoded(idStringValue);
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, 0);
        this.data[4] = type;
        UTF8.encode(idStringValue, this.data, 5);
    }

    int getCollectionId() {
        return ByteConversion.byteToInt(this.data, 0);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Collection id : ").append(ByteConversion.byteToInt(this.data, 0));
        if (this.len > 0) {
            buf.append(" Type : ").append(type[this.data[4]]);
            if (this.len == 7) {
                buf.append(" Symbol id : ").append(ByteConversion.byteToShort(this.data, 5));
            } else if (this.len == 9) {
                buf.append(" Symbol id : ").append(ByteConversion.byteToShort(this.data, 5));
                buf.append(" NSSymbol id : ").append(ByteConversion.byteToShort(this.data, 7));
            } else {
                buf.append("Invalid data length !!!");
            }
        }
        return buf.toString();
    }
}

