/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Map;
import org.exist.storage.NodePath;
import org.exist.storage.RangeIndexSpec;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Type;

public class GeneralRangeIndexSpec
extends RangeIndexSpec {
    private NodePath path;

    public GeneralRangeIndexSpec(Map<String, String> namespaces, String pathStr, String typeStr) throws DatabaseConfigurationException {
        if (pathStr.length() == 0) {
            throw new DatabaseConfigurationException("The path attribute is required in index.create");
        }
        this.path = new NodePath(namespaces, pathStr, false);
        try {
            this.type = GeneralRangeIndexSpec.getSuperType(Type.getType(typeStr));
        }
        catch (XPathException e) {
            throw new DatabaseConfigurationException("Unknown type: " + typeStr);
        }
    }

    public NodePath getPath() {
        return this.path;
    }

    protected boolean matches(NodePath otherPath) {
        return this.path.match(otherPath);
    }

    public String toString() {
        return "General range index\n\ttype : " + Type.getTypeName(this.type) + '\n' + "\tpath : " + this.path.toString() + '\n' + "\thas Qname index : " + GeneralRangeIndexSpec.hasQNameIndex(this.type) + '\n' + "\thas Qname or value index : " + GeneralRangeIndexSpec.hasQNameOrValueIndex(this.type) + '\n' + "\thas range index : " + GeneralRangeIndexSpec.hasRangeIndex(this.type) + '\n';
    }
}

