/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import com.evolvedbinary.j8fu.function.ConsumerE;
import com.evolvedbinary.j8fu.tuple.Tuple2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Optional;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.collections.Collection;
import org.exist.collections.CollectionCache;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.MutableCollection;
import org.exist.collections.triggers.CollectionTrigger;
import org.exist.collections.triggers.CollectionTriggers;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.DocumentTriggers;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.QName;
import org.exist.dom.memtree.DOMIndexer;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.indexing.StreamListener;
import org.exist.indexing.StructuralIndex;
import org.exist.numbering.NodeId;
import org.exist.security.Account;
import org.exist.security.MessageDigester;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SimpleACLPermission;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.BrokerPool;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.CreateBinaryLoggable;
import org.exist.storage.DBBroker;
import org.exist.storage.ElementIndex;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.NativeValueIndex;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.RenameBinaryLoggable;
import org.exist.storage.StorageAddress;
import org.exist.storage.UpdateBinaryLoggable;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.DOMTransaction;
import org.exist.storage.dom.INodeIterator;
import org.exist.storage.dom.NodeIterator;
import org.exist.storage.dom.RawNodeIterator;
import org.exist.storage.index.CollectionStore;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.journal.JournalException;
import org.exist.storage.journal.JournalManager;
import org.exist.storage.journal.LogEntryTypes;
import org.exist.storage.journal.Loggable;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.NativeSerializer;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;
import org.exist.util.UTF8;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;

public class NativeBroker
extends DBBroker {
    public static final String EXIST_STATISTICS_LOGGER = "org.exist.statistics";
    protected static final Logger LOG_STATS = LogManager.getLogger((String)"org.exist.statistics");
    public static final byte LOG_RENAME_BINARY = 64;
    public static final byte LOG_CREATE_BINARY = 65;
    public static final byte LOG_UPDATE_BINARY = 66;
    public static final byte PREPEND_DB_ALWAYS = 0;
    public static final byte PREPEND_DB_NEVER = 1;
    public static final byte PREPEND_DB_AS_NEEDED = 2;
    public static final byte COLLECTIONS_DBX_ID = 0;
    public static final byte VALUES_DBX_ID = 2;
    public static final byte DOM_DBX_ID = 3;
    public static final String PAGE_SIZE_ATTRIBUTE = "pageSize";
    public static final String INDEX_DEPTH_ATTRIBUTE = "index-depth";
    public static final String PROPERTY_INDEX_DEPTH = "indexer.index-depth";
    private static final byte[] ALL_STORAGE_FILES;
    private static final String EXCEPTION_DURING_REINDEX = "exception during reindex";
    private static final String DATABASE_IS_READ_ONLY = "Database is read-only";
    public static final String DEFAULT_DATA_DIR = "data";
    public static final int DEFAULT_INDEX_DEPTH = 1;
    public static final int DEFAULT_NODES_BEFORE_MEMORY_CHECK = 500;
    public static final int OFFSET_COLLECTION_ID = 0;
    public static final String INIT_COLLECTION_CONFIG = "collection.xconf.init";
    private static final int BINARY_RESOURCE_BUF_SIZE = 65536;
    private final CollectionStore collectionsDb;
    private final DOMFile domDb;
    private NativeValueIndex valueIndex;
    private final IndexSpec indexConfiguration;
    private int defaultIndexDepth;
    private final Serializer xmlSerializer;
    private int nodesCount = 0;
    private int nodesCountThreshold = 500;
    private final Path dataDir;
    private final Path fsDir;
    private final Optional<Path> fsJournalDir;
    private int pageSize;
    private final byte prepend;
    private final Runtime run = Runtime.getRuntime();
    private NodeProcessor nodeProcessor = new NodeProcessor();
    private IEmbeddedXMLStreamReader streamReader = null;
    private final Optional<JournalManager> logManager;
    private boolean incrementalDocIds = false;
    long nextReportTS = System.currentTimeMillis();

    public NativeBroker(BrokerPool pool, Configuration config) throws EXistException {
        super(pool, config);
        String docIdProp;
        this.logManager = pool.getJournalManager();
        LOG.debug("Initializing broker " + this.hashCode());
        String prependDB = (String)config.getProperty("db-connection.prepend-db");
        this.prepend = "always".equalsIgnoreCase(prependDB) ? (byte)0 : ("never".equalsIgnoreCase(prependDB) ? (byte)1 : (byte)2);
        this.dataDir = config.getProperty("db-connection.data-dir", Paths.get(DEFAULT_DATA_DIR, new String[0]));
        Path fs = this.dataDir.resolve("fs");
        try {
            this.fsDir = Files.createDirectories(fs, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new EXistException("Cannot make collection filesystem directory: " + fs.toAbsolutePath().toString(), ioe);
        }
        if (pool.isRecoveryEnabled()) {
            Path fsJournal = this.dataDir.resolve("fs.journal");
            try {
                this.fsJournalDir = Optional.of(Files.createDirectories(fsJournal, new FileAttribute[0]));
            }
            catch (IOException ioe) {
                throw new EXistException("Cannot make collection filesystem directory: " + fsJournal.toAbsolutePath().toString(), ioe);
            }
        } else {
            this.fsJournalDir = Optional.empty();
        }
        this.nodesCountThreshold = config.getInteger("db-connection.nodes-buffer");
        if (this.nodesCountThreshold > 0) {
            this.nodesCountThreshold *= 1000;
        }
        this.defaultIndexDepth = config.getInteger(PROPERTY_INDEX_DEPTH);
        if (this.defaultIndexDepth < 0) {
            this.defaultIndexDepth = 1;
        }
        if ((docIdProp = (String)config.getProperty("db-connection.doc-ids.mode")) != null) {
            this.incrementalDocIds = docIdProp.equalsIgnoreCase("incremental");
        }
        this.indexConfiguration = (IndexSpec)config.getProperty("indexer.config");
        this.xmlSerializer = new NativeSerializer(this, config);
        try {
            CollectionStore configuredCollectionsDb;
            this.pushSubject(pool.getSecurityManager().getSystemSubject());
            DOMFile configuredDomFile = (DOMFile)config.getProperty(DOMFile.getConfigKeyForFile());
            this.domDb = configuredDomFile != null ? configuredDomFile : new DOMFile(pool, 3, this.dataDir, config);
            if (this.domDb.isReadOnly()) {
                LOG.warn(FileUtils.fileName(this.domDb.getFile()) + " is read-only!");
                pool.setReadOnly();
            }
            this.collectionsDb = (configuredCollectionsDb = (CollectionStore)config.getProperty(CollectionStore.getConfigKeyForFile())) != null ? configuredCollectionsDb : new CollectionStore(pool, 0, this.dataDir, config);
            if (this.collectionsDb.isReadOnly()) {
                LOG.warn(FileUtils.fileName(this.collectionsDb.getFile()) + " is read-only!");
                pool.setReadOnly();
            }
            this.valueIndex = new NativeValueIndex(this, 2, this.dataDir, config);
            if (this.isReadOnly()) {
                LOG.warn(DATABASE_IS_READ_ONLY);
            }
        }
        catch (DBException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new EXistException(e);
        }
        finally {
            this.popSubject();
        }
    }

    protected Path getFsDir() {
        return this.fsDir;
    }

    @Override
    public ElementIndex getElementIndex() {
        return null;
    }

    @Override
    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
    }

    @Override
    public synchronized void deleteObservers() {
        super.deleteObservers();
    }

    private void notifyRemoveNode(NodeHandle node, NodePath currentPath, String content) {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.removeNode(node, currentPath, content);
        }
    }

    private void notifyStoreText(TextImpl text, NodePath currentPath) {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.storeText(text, currentPath);
        }
    }

    private void notifyDropIndex(Collection collection) {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.dropIndex(collection);
        }
    }

    private void notifyDropIndex(DocumentImpl doc) throws ReadOnlyException {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.dropIndex(doc);
        }
    }

    private void notifyRemove() {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.remove();
        }
    }

    private void notifySync() {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.sync();
        }
    }

    private void notifyFlush() {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            try {
                observer.flush();
            }
            catch (DBException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void notifyPrintStatistics() {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.printStatistics();
        }
    }

    private void notifyClose() throws DBException {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.close();
        }
        this.clearContentLoadingObservers();
    }

    private void notifyCloseAndRemove() {
        for (ContentLoadingObserver observer : this.contentLoadingObservers) {
            observer.closeAndRemove();
        }
        this.clearContentLoadingObservers();
    }

    @Override
    public <T extends IStoredNode> void endElement(IStoredNode<T> node, NodePath currentPath, String content, boolean remove) {
        int indexType = ((ElementImpl)node).getIndexType();
        if (RangeIndexSpec.hasRangeIndex(indexType)) {
            node.setQName(new QName(node.getQName(), 0));
            if (content == null) {
                content = this.getNodeValue(node, false);
            }
            this.valueIndex.setDocument((DocumentImpl)node.getOwnerDocument());
            this.valueIndex.storeElement((ElementImpl)node, content, RangeIndexSpec.indexTypeToXPath(indexType), NativeValueIndex.IndexType.GENERIC, remove);
        }
        if (RangeIndexSpec.hasQNameIndex(indexType)) {
            node.setQName(new QName(node.getQName(), 0));
            if (content == null) {
                content = this.getNodeValue(node, false);
            }
            this.valueIndex.setDocument((DocumentImpl)node.getOwnerDocument());
            this.valueIndex.storeElement((ElementImpl)node, content, RangeIndexSpec.indexTypeToXPath(indexType), NativeValueIndex.IndexType.QNAME, remove);
        }
    }

    @Override
    public void endRemove(Txn transaction) {
        this.notifyRemove();
    }

    @Override
    public boolean isReadOnly() {
        return this.pool.isReadOnly();
    }

    public DOMFile getDOMFile() {
        return this.domDb;
    }

    public BTree getStorage(byte id) {
        switch (id) {
            case 3: {
                return this.domDb;
            }
            case 0: {
                return this.collectionsDb;
            }
            case 2: {
                return this.valueIndex.dbValues;
            }
        }
        return null;
    }

    public byte[] getStorageFileIds() {
        return ALL_STORAGE_FILES;
    }

    public int getDefaultIndexDepth() {
        return this.defaultIndexDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupToArchive(RawDataBackup backup) throws IOException, EXistException {
        for (byte i : ALL_STORAGE_FILES) {
            BTree paged = this.getStorage(i);
            if (paged == null) {
                LOG.warn("Storage file is null: " + i);
                continue;
            }
            try {
                OutputStream os = backup.newEntry(FileUtils.fileName(paged.getFile()));
                paged.backupToStream(os);
            }
            finally {
                backup.closeEntry();
            }
        }
        this.pool.getSymbols().backupToArchive(backup);
        this.backupBinary(backup, this.getFsDir(), "");
        this.pool.getIndexManager().backupToArchive(backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupBinary(RawDataBackup backup, Path file, String path) throws IOException {
        String thisPath = path + "/" + file.getFileName();
        if (Files.isDirectory(file, new LinkOption[0])) {
            for (Path p : FileUtils.list(file)) {
                this.backupBinary(backup, p, thisPath);
            }
        } else {
            try {
                OutputStream os = backup.newEntry(thisPath);
                Files.copy(file, os);
            }
            finally {
                backup.closeEntry();
            }
        }
    }

    @Override
    public IndexSpec getIndexConfiguration() {
        return this.indexConfiguration;
    }

    @Override
    public StructuralIndex getStructuralIndex() {
        return (StructuralIndex)((Object)this.getIndexController().getWorkerByIndexName("structural-index"));
    }

    @Override
    public NativeValueIndex getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public IEmbeddedXMLStreamReader getXMLStreamReader(NodeHandle node, boolean reportAttributes) throws IOException, XMLStreamException {
        if (this.streamReader == null) {
            RawNodeIterator iterator = new RawNodeIterator(this, this.domDb, node);
            this.streamReader = new EmbeddedXMLStreamReader((DBBroker)this, (DocumentImpl)node.getOwnerDocument(), iterator, node, reportAttributes);
        } else {
            this.streamReader.reposition(this, node, reportAttributes);
        }
        return this.streamReader;
    }

    @Override
    public IEmbeddedXMLStreamReader newXMLStreamReader(NodeHandle node, boolean reportAttributes) throws IOException, XMLStreamException {
        RawNodeIterator iterator = new RawNodeIterator(this, this.domDb, node);
        return new EmbeddedXMLStreamReader((DBBroker)this, (DocumentImpl)node.getOwnerDocument(), iterator, null, reportAttributes);
    }

    @Override
    public INodeIterator getNodeIterator(NodeHandle node) {
        if (node == null) {
            throw new IllegalArgumentException("The node parameter cannot be null.");
        }
        try {
            return new NodeIterator(this, this.domDb, node, false);
        }
        catch (IOException | BTreeException e) {
            LOG.warn("failed to create node iterator", (Throwable)e);
            return null;
        }
    }

    @Override
    public Serializer getSerializer() {
        this.xmlSerializer.reset();
        return this.xmlSerializer;
    }

    @Override
    public Serializer newSerializer() {
        return new NativeSerializer(this, this.getConfiguration());
    }

    @Override
    public Serializer newSerializer(List<String> chainOfReceivers) {
        return new NativeSerializer(this, this.getConfiguration(), chainOfReceivers);
    }

    public XmldbURI prepend(XmldbURI uri) {
        switch (this.prepend) {
            case 0: {
                return uri.prepend(XmldbURI.ROOT_COLLECTION_URI);
            }
            case 2: {
                return uri.startsWith(XmldbURI.ROOT_COLLECTION_URI) ? uri : uri.prepend(XmldbURI.ROOT_COLLECTION_URI);
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple2<Boolean, Collection> getOrCreateTempCollection(Txn transaction) throws LockException, PermissionDeniedException, IOException, TriggerException {
        try {
            this.pushSubject(this.pool.getSecurityManager().getSystemSubject());
            Tuple2<Boolean, Collection> temp = this.getOrCreateCollectionExplicit(transaction, XmldbURI.TEMP_COLLECTION_URI);
            if (((Boolean)temp._1).booleanValue()) {
                ((Collection)temp._2).setPermissions(505);
                this.saveCollection(transaction, (Collection)temp._2);
            }
            Tuple2<Boolean, Collection> tuple2 = temp;
            return tuple2;
        }
        finally {
            this.popSubject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String readInitCollectionConfig() {
        Path fInitCollectionConfig = this.pool.getConfiguration().getExistHome().map(h -> h.resolve(INIT_COLLECTION_CONFIG)).orElse(Paths.get(INIT_COLLECTION_CONFIG, new String[0]));
        if (!Files.isRegularFile(fInitCollectionConfig, new LinkOption[0])) return null;
        try (InputStream is = Files.newInputStream(fInitCollectionConfig, new OpenOption[0]);){
            StringBuilder initCollectionConfig = new StringBuilder();
            int read = -1;
            byte[] buf = new byte[1024];
            while ((read = is.read(buf)) != -1) {
                initCollectionConfig.append(new String(buf, 0, read));
            }
            String string = initCollectionConfig.toString();
            return string;
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage(), (Throwable)ioe);
        }
        return null;
    }

    @Override
    public Collection getOrCreateCollection(Txn transaction, XmldbURI name) throws PermissionDeniedException, IOException, TriggerException {
        return (Collection)this.getOrCreateCollectionExplicit((Txn)transaction, (XmldbURI)name)._2;
    }

    private Tuple2<Boolean, Collection> getOrCreateCollectionExplicit(Txn transaction, XmldbURI name) throws PermissionDeniedException, IOException, TriggerException {
        name = this.prepend(name.normalizeCollectionPath());
        CollectionCache collectionsCache = this.pool.getCollectionsCache();
        boolean created = false;
        CollectionCache collectionCache = collectionsCache;
        synchronized (collectionCache) {
            try {
                XmldbURI[] segments = name.getPathSegments();
                XmldbURI path = XmldbURI.ROOT_COLLECTION_URI;
                Collection current = this.getCollection(XmldbURI.ROOT_COLLECTION_URI);
                if (current == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating root collection '" + XmldbURI.ROOT_COLLECTION_URI + "'");
                    }
                    CollectionTriggers trigger = new CollectionTriggers(this);
                    trigger.beforeCreateCollection(this, transaction, XmldbURI.ROOT_COLLECTION_URI);
                    current = new MutableCollection(this, XmldbURI.ROOT_COLLECTION_URI);
                    current.setId(this.getNextCollectionId(transaction));
                    current.setCreationTime(System.currentTimeMillis());
                    if (transaction != null) {
                        transaction.acquireLock(current.getLock(), Lock.LockMode.WRITE_LOCK);
                    }
                    this.saveCollection(transaction, current);
                    created = true;
                    collectionsCache.add(current);
                    trigger.afterCreateCollection(this, transaction, current);
                    try {
                        String initCollectionConfig = this.readInitCollectionConfig();
                        if (initCollectionConfig != null) {
                            CollectionConfigurationManager collectionConfigurationManager = this.pool.getConfigurationManager();
                            if (collectionConfigurationManager == null) {
                                if (this.pool.getConfigurationManager() == null) {
                                    throw new IllegalStateException();
                                }
                                collectionConfigurationManager = this.pool.getConfigurationManager();
                            }
                            if (collectionConfigurationManager != null) {
                                collectionConfigurationManager.addConfiguration(transaction, this, current, initCollectionConfig);
                            }
                        }
                    }
                    catch (CollectionConfigurationException cce) {
                        LOG.error("Could not load initial collection configuration for /db: " + cce.getMessage(), (Throwable)cce);
                    }
                }
                for (int i = 1; i < segments.length; ++i) {
                    XmldbURI temp = segments[i];
                    path = path.append(temp);
                    if (current.hasChildCollectionNoLock(this, temp)) {
                        current = this.getCollection(path);
                        if (current != null) continue;
                        LOG.error("Collection '" + path + "' found in subCollections set but is missing from collections.dbx!");
                        continue;
                    }
                    if (this.isReadOnly()) {
                        throw new IOException(DATABASE_IS_READ_ONLY);
                    }
                    if (!current.getPermissionsNoLock().validate(this.getCurrentSubject(), 2)) {
                        LOG.error("Permission denied to create collection '" + path + "'");
                        throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' not allowed to write to collection '" + current.getURI() + "'");
                    }
                    if (!current.getPermissionsNoLock().validate(this.getCurrentSubject(), 1)) {
                        LOG.error("Permission denied to create collection '" + path + "'");
                        throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' not allowed to execute to collection '" + current.getURI() + "'");
                    }
                    if (current.hasDocument(this, path.lastSegment())) {
                        LOG.error("Collection '" + current.getURI() + "' have document '" + path.lastSegment() + "'");
                        throw new PermissionDeniedException("Collection '" + current.getURI() + "' have document '" + path.lastSegment() + "'.");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating collection '" + path + "'...");
                    }
                    CollectionTriggers trigger = new CollectionTriggers(this, current);
                    trigger.beforeCreateCollection(this, transaction, path);
                    MutableCollection sub = new MutableCollection(this, path);
                    if (current.getPermissions().isSetGid()) {
                        sub.getPermissions().setGroupFrom(current.getPermissions());
                        sub.getPermissions().setSetGid(true);
                    }
                    sub.setId(this.getNextCollectionId(transaction));
                    if (transaction != null) {
                        transaction.acquireLock(sub.getLock(), Lock.LockMode.WRITE_LOCK);
                    }
                    current.addCollection(this, sub, true);
                    this.saveCollection(transaction, current);
                    created = true;
                    collectionsCache.add(sub);
                    trigger.afterCreateCollection(this, transaction, sub);
                    current = sub;
                }
                return new Tuple2((Object)created, (Object)current);
            }
            catch (LockException e) {
                LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
                return null;
            }
            catch (ReadOnlyException e) {
                throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
            }
        }
    }

    @Override
    public Collection getCollection(XmldbURI uri) throws PermissionDeniedException {
        return this.openCollection(uri, Lock.LockMode.NO_LOCK);
    }

    @Override
    public Collection openCollection(XmldbURI uri, Lock.LockMode lockMode) throws PermissionDeniedException {
        return this.openCollection(uri, -1L, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findCollectionsMatching(String regexp) {
        ArrayList<String> collections = new ArrayList<String>();
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher("");
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            ArrayList<Value> keys = this.collectionsDb.getKeys();
            for (Value key : keys) {
                byte[] data = key.getData();
                if (data[0] != 0) continue;
                String collectionName = UTF8.decode(data, 1, data.length - 1).toString();
                m.reset(collectionName);
                if (!m.matches()) continue;
                collections.add(collectionName);
            }
        }
        catch (UnsupportedEncodingException keys) {
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
        }
        catch (IOException | BTreeException | TerminatedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readCollectionEntry(Collection.SubCollectionEntry entry) {
        CollectionCache collectionsCache;
        XmldbURI uri = this.prepend(entry.getUri().toCollectionPathURI());
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            Collection collection = collectionsCache.get(uri);
            if (collection == null) {
                Lock lock = this.collectionsDb.getLock();
                try {
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    CollectionStore.CollectionKey key = new CollectionStore.CollectionKey(uri.toString());
                    VariableByteInput is = this.collectionsDb.getAsStream(key);
                    if (is == null) {
                        LOG.warn("Could not read collection entry for: " + uri);
                        return;
                    }
                    entry.read(is);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Unable to encode '" + uri + "' in UTF-8");
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                }
            } else {
                if (!collection.getURI().equalsInternal(uri)) {
                    LOG.error("The collection received from the cache is not the requested: " + uri + "; received: " + collection.getURI());
                    return;
                }
                entry.read(collection);
                collectionsCache.add(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection openCollection(XmldbURI uri, long address, Lock.LockMode lockMode) throws PermissionDeniedException {
        Collection collection;
        CollectionCache collectionsCache;
        uri = this.prepend(uri.toCollectionPathURI());
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            collection = collectionsCache.get(uri);
            if (collection == null) {
                Collection collection2;
                Lock lock = this.collectionsDb.getLock();
                try {
                    VariableByteInput is;
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    if (address == -1L) {
                        CollectionStore.CollectionKey key = new CollectionStore.CollectionKey(uri.toString());
                        is = this.collectionsDb.getAsStream(key);
                    } else {
                        is = this.collectionsDb.getAsStream(address);
                    }
                    if (is == null) {
                        collection2 = null;
                        return collection2;
                    }
                    collection = MutableCollection.load(this, uri, is);
                    collectionsCache.add(collection);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Unable to encode '" + uri + "' in UTF-8");
                    collection2 = null;
                    return collection2;
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
                    collection2 = null;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    return collection2;
                    catch (IOException e2) {
                        LOG.error(e2.getMessage(), (Throwable)e2);
                        collection2 = null;
                        return collection2;
                    }
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                }
            } else {
                if (!collection.getURI().equalsInternal(uri)) {
                    LOG.error("The collection received from the cache is not the requested: " + uri + "; received: " + collection.getURI());
                }
                collectionsCache.add(collection);
                if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 1)) {
                    throw new PermissionDeniedException("Permission denied to open collection: " + collection.getURI().toString() + " by " + this.getCurrentSubject().getName());
                }
            }
        }
        if (lockMode == Lock.LockMode.NO_LOCK) return collection;
        try {
            collection.getLock().acquire(lockMode);
            return collection;
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on collection '" + uri + "'");
        }
        return collection;
    }

    protected void checkPermissionsForCopy(Collection src, XmldbURI destUri, XmldbURI newName) throws PermissionDeniedException, LockException {
        if (!src.getPermissionsNoLock().validate(this.getCurrentSubject(), 5)) {
            throw new PermissionDeniedException("Permission denied to copy collection " + src.getURI() + " by " + this.getCurrentSubject().getName());
        }
        Collection dest = this.getCollection(destUri);
        XmldbURI newDestUri = destUri.append(newName);
        Collection newDest = this.getCollection(newDestUri);
        if (dest != null) {
            if (!dest.getPermissionsNoLock().validate(this.getCurrentSubject(), 3)) {
                throw new PermissionDeniedException("Permission denied to copy collection " + src.getURI() + " to " + dest.getURI() + " by " + this.getCurrentSubject().getName());
            }
            if (newDest != null && !newDest.getPermissionsNoLock().validate(this.getCurrentSubject(), 3)) {
                throw new PermissionDeniedException("Permission denied to copy collection " + src.getURI() + " to " + newDest.getURI() + " by " + this.getCurrentSubject().getName());
            }
        }
        Iterator<DocumentImpl> itSrcSubDoc = src.iterator(this);
        while (itSrcSubDoc.hasNext()) {
            DocumentImpl newDestSubDoc;
            DocumentImpl srcSubDoc = itSrcSubDoc.next();
            if (!srcSubDoc.getPermissions().validate(this.getCurrentSubject(), 4)) {
                throw new PermissionDeniedException("Permission denied to copy collection " + src.getURI() + " for resource " + srcSubDoc.getURI() + " by " + this.getCurrentSubject().getName());
            }
            if (newDest == null || newDest.isEmpty(this) || (newDestSubDoc = newDest.getDocument(this, srcSubDoc.getFileURI())) == null || newDestSubDoc.getPermissions().validate(this.getCurrentSubject(), 2)) continue;
            throw new PermissionDeniedException("Permission denied to copy collection " + src.getURI() + " for resource " + newDestSubDoc.getURI() + " by " + this.getCurrentSubject().getName());
        }
        Iterator<XmldbURI> itSrcSubColUri = src.collectionIterator(this);
        while (itSrcSubColUri.hasNext()) {
            XmldbURI srcSubColUri = itSrcSubColUri.next();
            Collection srcSubCol = this.getCollection(src.getURI().append(srcSubColUri));
            this.checkPermissionsForCopy(srcSubCol, newDestUri, srcSubColUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyCollection(Txn transaction, Collection collection, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException, IOException, TriggerException, EXistException {
        CollectionCache collectionsCache;
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        if (newName != null && newName.numSegments() != 1) {
            throw new PermissionDeniedException("New collection name must have one segment!");
        }
        XmldbURI srcURI = collection.getURI();
        XmldbURI dstURI = destination.getURI().append(newName);
        if (collection.getURI().equals(dstURI)) {
            throw new PermissionDeniedException("Cannot copy collection to itself '" + collection.getURI() + "'.");
        }
        if (collection.getId() == destination.getId()) {
            throw new PermissionDeniedException("Cannot copy collection to itself '" + collection.getURI() + "'.");
        }
        if (this.isSubCollection(collection, destination)) {
            throw new PermissionDeniedException("Cannot copy collection '" + collection.getURI() + "' to it child collection '" + destination.getURI() + "'.");
        }
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            Lock lock = this.collectionsDb.getLock();
            try {
                this.pool.getProcessMonitor().startJob("copy collection", collection.getURI());
                lock.acquire(Lock.LockMode.WRITE_LOCK);
                if (this.isSubCollection(collection, destination)) {
                    throw new PermissionDeniedException("Cannot copy collection '" + collection.getURI() + "' to it child collection '" + destination.getURI() + "'.");
                }
                XmldbURI parentName = collection.getParentURI();
                Collection parent = parentName == null ? collection : this.getCollection(parentName);
                CollectionTriggers trigger = new CollectionTriggers(this, parent);
                trigger.beforeCopyCollection(this, transaction, collection, dstURI);
                this.checkPermissionsForCopy(collection, destination.getURI(), newName);
                DocumentTriggers docTrigger = new DocumentTriggers(this);
                Collection newCollection = this.doCopyCollection(transaction, docTrigger, collection, destination, newName, false);
                trigger.afterCopyCollection(this, transaction, newCollection, srcURI);
            }
            finally {
                lock.release(Lock.LockMode.WRITE_LOCK);
                this.pool.getProcessMonitor().endJob();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection doCopyCollection(Txn transaction, DocumentTrigger trigger, Collection collection, Collection destination, XmldbURI newName, boolean copyCollectionMode) throws PermissionDeniedException, IOException, EXistException, TriggerException, LockException {
        if (newName == null) {
            newName = collection.getURI().lastSegment();
        }
        newName = destination.getURI().append(newName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copying collection to '" + newName + "'");
        }
        Tuple2<Boolean, Collection> destCollection = this.getOrCreateCollectionExplicit(transaction, newName);
        if (copyCollectionMode && ((Boolean)destCollection._1).booleanValue()) {
            Permission srcPerms = collection.getPermissions();
            Permission destPerms = ((Collection)destCollection._2).getPermissions();
            this.copyModeAndAcl(srcPerms, destPerms);
        }
        Iterator<DocumentImpl> i = collection.iterator(this);
        while (i.hasNext()) {
            DocumentImpl createdDoc;
            DocumentImpl newDoc;
            DocumentImpl child = i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copying resource: '" + child.getURI() + "'");
            }
            XmldbURI newUri = ((Collection)destCollection._2).getURI().append(child.getFileURI());
            trigger.beforeCopyDocument(this, transaction, child, newUri);
            Collection.CollectionEntry oldDoc = ((Collection)destCollection._2).hasDocument(this, child.getFileURI()) ? ((Collection)destCollection._2).getResourceEntry(this, child.getFileURI().toString()) : null;
            if (child.getResourceType() == 0) {
                newDoc = new DocumentImpl(this.pool, (Collection)destCollection._2, child.getFileURI());
                newDoc.copyOf(child, false);
                if (oldDoc != null) {
                    newDoc.setPermissions(oldDoc.getPermissions());
                } else {
                    Permission srcPerm = child.getPermissions();
                    Permission destPerm = newDoc.getPermissions();
                    this.copyModeAndAcl(srcPerm, destPerm);
                }
                newDoc.setDocId(this.getNextResourceId(transaction, destination));
                this.copyXMLResource(transaction, child, newDoc);
                this.storeXMLResource(transaction, newDoc);
                ((Collection)destCollection._2).addDocument(transaction, this, newDoc);
                createdDoc = newDoc;
            } else {
                newDoc = new BinaryDocument(this.pool, (Collection)destCollection._2, child.getFileURI());
                newDoc.copyOf(child, false);
                if (oldDoc != null) {
                    newDoc.setPermissions(oldDoc.getPermissions());
                }
                newDoc.setDocId(this.getNextResourceId(transaction, destination));
                try (InputStream is = this.getBinaryResource((BinaryDocument)child);){
                    this.storeBinaryResource(transaction, (BinaryDocument)newDoc, is);
                }
                this.storeXMLResource(transaction, newDoc);
                ((Collection)destCollection._2).addDocument(transaction, this, newDoc);
                createdDoc = newDoc;
            }
            trigger.afterCopyDocument(this, transaction, createdDoc, child.getURI());
        }
        this.saveCollection(transaction, (Collection)destCollection._2);
        XmldbURI name = collection.getURI();
        Iterator<XmldbURI> i2 = collection.collectionIterator(this);
        while (i2.hasNext()) {
            XmldbURI childName = i2.next();
            Collection child = null;
            try {
                child = this.openCollection(name.append(childName), Lock.LockMode.READ_LOCK);
                if (child == null) {
                    LOG.warn("Child collection '" + childName + "' not found");
                    continue;
                }
                this.doCopyCollection(transaction, trigger, child, (Collection)destCollection._2, childName, true);
            }
            finally {
                if (child == null) continue;
                child.release(Lock.LockMode.READ_LOCK);
            }
        }
        this.saveCollection(transaction, (Collection)destCollection._2);
        this.saveCollection(transaction, destination);
        return (Collection)destCollection._2;
    }

    private void copyModeAndAcl(Permission srcPermission, Permission destPermission) throws PermissionDeniedException {
        destPermission.setMode(srcPermission.getMode());
        if (srcPermission instanceof SimpleACLPermission && destPermission instanceof SimpleACLPermission) {
            ((SimpleACLPermission)destPermission).copyAclOf((SimpleACLPermission)srcPermission);
        }
    }

    private boolean isSubCollection(Collection col, Collection sub) {
        return sub.getURI().startsWith(col.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveCollection(Txn transaction, Collection collection, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException, IOException, TriggerException {
        Collection parent;
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        if (newName != null && newName.numSegments() != 1) {
            throw new PermissionDeniedException("New collection name must have one segment!");
        }
        if (collection.getId() == destination.getId()) {
            throw new PermissionDeniedException("Cannot move collection to itself '" + collection.getURI() + "'.");
        }
        if (collection.getURI().equals(destination.getURI().append(newName))) {
            throw new PermissionDeniedException("Cannot move collection to itself '" + collection.getURI() + "'.");
        }
        if (collection.getURI().equals(XmldbURI.ROOT_COLLECTION_URI)) {
            throw new PermissionDeniedException("Cannot move the db root collection");
        }
        if (this.isSubCollection(collection, destination)) {
            throw new PermissionDeniedException("Cannot move collection '" + collection.getURI() + "' to it child collection '" + destination.getURI() + "'.");
        }
        XmldbURI parentName = collection.getParentURI();
        Collection collection2 = parent = parentName == null ? collection : this.getCollection(parentName);
        if (!parent.getPermissionsNoLock().validate(this.getCurrentSubject(), 3)) {
            throw new PermissionDeniedException("Account " + this.getCurrentSubject().getName() + " have insufficient privileges on collection " + parent.getURI() + " to move collection " + collection.getURI());
        }
        if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Account " + this.getCurrentSubject().getName() + " have insufficient privileges on collection to move collection " + collection.getURI());
        }
        if (!destination.getPermissionsNoLock().validate(this.getCurrentSubject(), 3)) {
            throw new PermissionDeniedException("Account " + this.getCurrentSubject().getName() + " have insufficient privileges on collection " + parent.getURI() + " to move collection " + collection.getURI());
        }
        XmldbURI movedToCollectionUri = destination.getURI().append(newName);
        Collection existingMovedToCollection = this.getCollection(movedToCollectionUri);
        if (existingMovedToCollection != null) {
            this.removeCollection(transaction, existingMovedToCollection);
        }
        this.pool.getProcessMonitor().startJob("move collection", collection.getURI());
        try {
            XmldbURI srcURI = collection.getURI();
            XmldbURI dstURI = destination.getURI().append(newName);
            CollectionTriggers trigger = new CollectionTriggers(this, parent);
            trigger.beforeMoveCollection(this, transaction, collection, dstURI);
            Path fsSourceDir = this.getCollectionFile(this.getFsDir(), collection.getURI(), false);
            this.moveCollectionRecursive(transaction, trigger, collection, destination, newName, false);
            this.moveBinaryFork(transaction, fsSourceDir, destination, newName);
            trigger.afterMoveCollection(this, transaction, collection, srcURI);
        }
        finally {
            this.pool.getProcessMonitor().endJob();
        }
    }

    private void moveBinaryFork(Txn transaction, Path sourceDir, Collection destination, XmldbURI newName) throws IOException {
        Path targetDir = this.getCollectionFile(this.getFsDir(), destination.getURI().append(newName), false);
        if (Files.exists(sourceDir, new LinkOption[0])) {
            if (Files.exists(targetDir, new LinkOption[0])) {
                if (this.fsJournalDir.isPresent()) {
                    Path targetDelDir = this.getCollectionFile(this.fsJournalDir.get(), transaction, destination.getURI().append(newName), true);
                    Files.createDirectories(targetDelDir, new FileAttribute[0]);
                    Files.move(targetDir, targetDelDir, StandardCopyOption.ATOMIC_MOVE);
                    if (this.logManager.isPresent()) {
                        RenameBinaryLoggable loggable = new RenameBinaryLoggable(this, transaction, targetDir, targetDelDir);
                        try {
                            this.logManager.get().journal(loggable);
                        }
                        catch (JournalException e) {
                            LOG.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    FileUtils.delete(targetDir);
                }
            }
            Files.createDirectories(targetDir.getParent(), new FileAttribute[0]);
            Files.move(sourceDir, targetDir, StandardCopyOption.ATOMIC_MOVE);
            if (this.logManager.isPresent()) {
                RenameBinaryLoggable loggable = new RenameBinaryLoggable(this, transaction, sourceDir, targetDir);
                try {
                    this.logManager.get().journal(loggable);
                }
                catch (JournalException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCollectionRecursive(Txn transaction, CollectionTrigger trigger, Collection collection, Collection destination, XmldbURI newName, boolean fireTrigger) throws PermissionDeniedException, IOException, LockException, TriggerException {
        CollectionCache collectionsCache;
        XmldbURI uri = collection.getURI();
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            XmldbURI parentName;
            Collection parent;
            XmldbURI srcURI = collection.getURI();
            XmldbURI dstURI = destination.getURI().append(newName);
            if (this.isSubCollection(collection, destination)) {
                throw new PermissionDeniedException("Cannot move collection '" + srcURI + "' to it child collection '" + dstURI + "'.");
            }
            if (fireTrigger) {
                trigger.beforeMoveCollection(this, transaction, collection, dstURI);
            }
            if ((parent = this.openCollection(parentName = collection.getParentURI(), Lock.LockMode.WRITE_LOCK)) != null) {
                try {
                    parent.removeCollection(this, uri.lastSegment());
                }
                finally {
                    parent.release(Lock.LockMode.WRITE_LOCK);
                }
            }
            Lock lock = this.collectionsDb.getLock();
            try {
                lock.acquire(Lock.LockMode.WRITE_LOCK);
                collectionsCache.remove(collection);
                CollectionStore.CollectionKey key = new CollectionStore.CollectionKey(uri.toString());
                this.collectionsDb.remove(transaction, key);
                collection.setPath(destination.getURI().append(newName));
                collection.setCreationTime(System.currentTimeMillis());
                destination.addCollection(this, collection, false);
                if (parent != null) {
                    this.saveCollection(transaction, parent);
                }
                if (parent != destination) {
                    this.saveCollection(transaction, destination);
                }
                this.saveCollection(transaction, collection);
            }
            finally {
                lock.release(Lock.LockMode.WRITE_LOCK);
            }
            if (fireTrigger) {
                trigger.afterMoveCollection(this, transaction, collection, srcURI);
            }
            Iterator<XmldbURI> i = collection.collectionIterator(this);
            while (i.hasNext()) {
                XmldbURI childName = i.next();
                Collection child = this.openCollection(uri.append(childName), Lock.LockMode.WRITE_LOCK);
                if (child == null) {
                    LOG.warn("Child collection " + childName + " not found");
                    continue;
                }
                try {
                    this.moveCollectionRecursive(transaction, trigger, child, collection, childName, true);
                }
                finally {
                    child.release(Lock.LockMode.WRITE_LOCK);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeCollection(final Txn transaction, Collection collection) throws PermissionDeniedException, IOException, TriggerException {
        boolean bl;
        String collName;
        XmldbURI uri;
        CollectionCache collectionsCache;
        long start;
        CollectionTriggers colTrigger;
        Collection parent;
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        XmldbURI parentName = collection.getParentURI();
        boolean isRoot = parentName == null;
        Collection collection2 = parent = isRoot ? collection : this.getCollection(parentName);
        if (!parent.getPermissionsNoLock().validate(this.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' is not allowed to remove collection '" + collection.getURI() + "'");
        }
        if (!parent.getPermissionsNoLock().validate(this.getCurrentSubject(), 1)) {
            throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' is not allowed to remove collection '" + collection.getURI() + "'");
        }
        if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' is not allowed to remove collection '" + collection.getURI() + "'");
        }
        if (!collection.isEmpty(this)) {
            if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 2)) {
                throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' is not allowed to remove collection '" + collection.getURI() + "'");
            }
            if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 1)) {
                throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' is not allowed to remove collection '" + collection.getURI() + "'");
            }
        }
        try {
            this.pool.getProcessMonitor().startJob("remove collection", collection.getURI());
            colTrigger = new CollectionTriggers(this, parent);
            colTrigger.beforeDeleteCollection(this, transaction, collection);
            start = System.currentTimeMillis();
            CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
            synchronized (collectionCache) {
                uri = collection.getURI();
                collName = uri.getRawCollectionPath();
                CollectionConfigurationManager manager = this.pool.getConfigurationManager();
                if (manager != null) {
                    manager.invalidate(uri, this.getBrokerPool());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing children collections from their parent '" + collName + "'...");
                }
                try {
                    Iterator<XmldbURI> i = collection.collectionIterator(this);
                    while (i.hasNext()) {
                        XmldbURI childName = i.next();
                        Collection childCollection = this.openCollection(uri.append(childName), Lock.LockMode.WRITE_LOCK);
                        try {
                            this.removeCollection(transaction, childCollection);
                        }
                        catch (NullPointerException npe) {
                            LOG.error("childCollection '" + childName + "' is corrupted. Caught NPE to be able to actually remove the parent.");
                        }
                        finally {
                            if (childCollection != null) {
                                childCollection.getLock().release(Lock.LockMode.WRITE_LOCK);
                                continue;
                            }
                            LOG.warn("childCollection is null !");
                        }
                    }
                }
                catch (LockException e) {
                    LOG.error("LockException while removing collection '" + collName + "'", (Throwable)e);
                    boolean childName = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 18, 15] lbl53 : MonitorExitStatement: MONITOREXIT : var10_9
                    this.pool.getProcessMonitor().endJob();
                    return childName;
                }
                this.notifyDropIndex(collection);
            }
        }
        catch (Throwable throwable) {
            this.pool.getProcessMonitor().endJob();
            throw throwable;
        }
        {
            block55: {
                Path fsSourceDir;
                block54: {
                    this.indexController.removeCollection(collection, this, false);
                    if (!isRoot) {
                        Collection parentCollection = null;
                        try {
                            parentCollection = this.openCollection(collection.getParentURI(), Lock.LockMode.WRITE_LOCK);
                            if (parentCollection != null) {
                                if (transaction != null) {
                                    transaction.acquireLock(parentCollection.getLock(), Lock.LockMode.WRITE_LOCK);
                                }
                                LOG.debug("Removing collection '" + collName + "' from its parent...");
                                parentCollection.removeCollection(this, uri.lastSegment());
                                this.saveCollection(transaction, parentCollection);
                            }
                        }
                        catch (LockException e) {
                            LOG.warn("LockException while removing collection '" + collName + "'");
                        }
                        finally {
                            if (parentCollection != null) {
                                parentCollection.getLock().release(Lock.LockMode.WRITE_LOCK);
                            }
                        }
                    }
                    Lock lock = this.collectionsDb.getLock();
                    try {
                        lock.acquire(Lock.LockMode.WRITE_LOCK);
                        CollectionStore.DocumentKey docKey = new CollectionStore.DocumentKey(collection.getId());
                        IndexQuery query = new IndexQuery(7, (Value)docKey);
                        this.collectionsDb.removeAll(transaction, query);
                        if (!isRoot) {
                            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey(collName);
                            this.collectionsDb.remove(transaction, key);
                            collectionsCache.remove(collection);
                            this.collectionsDb.freeCollectionId(collection.getId());
                        } else {
                            this.saveCollection(transaction, collection);
                        }
                    }
                    catch (LockException e) {
                        LOG.warn("Failed to acquire lock on '" + FileUtils.fileName(this.collectionsDb.getFile()) + "'");
                    }
                    catch (IOException | BTreeException e) {
                        LOG.warn("Exception while removing collection: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        lock.release(Lock.LockMode.WRITE_LOCK);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Removing resources in '" + collName + "'...");
                    }
                    DocumentTriggers docTrigger = new DocumentTriggers(this, collection);
                    try {
                        Iterator<DocumentImpl> i = collection.iterator(this);
                        while (i.hasNext()) {
                            final DocumentImpl doc = i.next();
                            docTrigger.beforeDeleteDocument(this, transaction, doc);
                            new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                                @Override
                                public Object start() {
                                    try {
                                        NodeRef ref = new NodeRef(doc.getDocId());
                                        IndexQuery query = new IndexQuery(7, (Value)ref);
                                        NativeBroker.this.domDb.remove(transaction, query, null);
                                    }
                                    catch (BTreeException e) {
                                        DBBroker.LOG.warn("btree error while removing document", (Throwable)e);
                                    }
                                    catch (IOException e) {
                                        DBBroker.LOG.warn("io error while removing document", (Throwable)e);
                                    }
                                    catch (TerminatedException e) {
                                        DBBroker.LOG.warn("method terminated", (Throwable)e);
                                    }
                                    return null;
                                }
                            }.run();
                            new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                                @Override
                                public Object start() {
                                    if (doc.getResourceType() == 1) {
                                        long page = ((BinaryDocument)doc).getPage();
                                        if (page > -1L) {
                                            NativeBroker.this.domDb.removeOverflowValue(transaction, page);
                                        }
                                    } else {
                                        NodeHandle node = (NodeHandle)((Object)doc.getFirstChild());
                                        NativeBroker.this.domDb.removeAll(transaction, node.getInternalAddress());
                                    }
                                    return null;
                                }
                            }.run();
                            docTrigger.afterDeleteDocument(this, transaction, doc.getURI());
                            this.collectionsDb.freeResourceId(doc.getDocId());
                        }
                    }
                    catch (LockException e) {
                        LOG.error("LockException while removing documents from collection '" + collection.getURI() + "'.", (Throwable)e);
                        boolean doc = false;
                        // MONITOREXIT @DISABLED, blocks:[24, 15] lbl124 : MonitorExitStatement: MONITOREXIT : var10_9
                        this.pool.getProcessMonitor().endJob();
                        return doc;
                    }
                    fsSourceDir = this.getCollectionFile(this.getFsDir(), collection.getURI(), false);
                    if (!this.fsJournalDir.isPresent()) break block54;
                    Path fsTargetDir = this.getCollectionFile(this.fsJournalDir.get(), transaction, collection.getURI(), true);
                    if (Files.exists(fsSourceDir, new LinkOption[0])) {
                        Files.createDirectories(fsTargetDir.getParent(), new FileAttribute[0]);
                        Files.move(fsSourceDir, fsTargetDir, StandardCopyOption.ATOMIC_MOVE);
                        if (this.logManager.isPresent()) {
                            RenameBinaryLoggable loggable = new RenameBinaryLoggable(this, transaction, fsSourceDir, fsTargetDir);
                            try {
                                this.logManager.get().journal(loggable);
                            }
                            catch (JournalException e) {
                                LOG.warn(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    break block55;
                }
                FileUtils.delete(fsSourceDir);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing collection '" + collName + "' took " + (System.currentTimeMillis() - start));
            }
            colTrigger.afterDeleteCollection(this, transaction, collection.getURI());
            bl = true;
        }
        this.pool.getProcessMonitor().endJob();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCollection(Txn transaction, Collection collection) throws PermissionDeniedException, IOException, TriggerException {
        if (collection == null) {
            LOG.error("NativeBroker.saveCollection called with collection == null! Aborting.");
            return;
        }
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        this.pool.getCollectionsCache().add(collection);
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            if (collection.getId() == -1) {
                collection.setId(this.getNextCollectionId(transaction));
            }
            CollectionStore.CollectionKey name = new CollectionStore.CollectionKey(collection.getURI().toString());
            try (VariableByteOutputStream os = new VariableByteOutputStream(8);){
                collection.serialize(os);
                long address = this.collectionsDb.put(transaction, (Value)name, os.data(), true);
                if (address == -1L) {
                    LOG.warn("could not store collection data for '" + collection.getURI() + "'");
                    return;
                }
                collection.setAddress(address);
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn(DATABASE_IS_READ_ONLY);
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextCollectionId(Txn transaction) throws ReadOnlyException {
        int nextCollectionId = this.collectionsDb.getFreeCollectionId();
        if (nextCollectionId != -1) {
            return nextCollectionId;
        }
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__next_collection_id");
            Value data = this.collectionsDb.get(key);
            if (data != null) {
                nextCollectionId = ByteConversion.byteToInt(data.getData(), 0);
                ++nextCollectionId;
            }
            byte[] d = new byte[4];
            ByteConversion.intToByte(nextCollectionId, d, 0);
            this.collectionsDb.put(transaction, (Value)key, d, true);
            int n = nextCollectionId;
            return n;
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void reindexCollection(XmldbURI collectionName) throws PermissionDeniedException, IOException {
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        Collection collection = this.getCollection(collectionName = this.prepend(collectionName.toCollectionPathURI()));
        if (collection == null) {
            LOG.debug("collection " + collectionName + " not found!");
            return;
        }
        this.reindexCollection(collection, DBBroker.IndexMode.STORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexCollection(Collection collection, DBBroker.IndexMode mode) throws PermissionDeniedException {
        TransactionManager transact = this.pool.getTransactionManager();
        long start = System.currentTimeMillis();
        try {
            try (Txn transaction = transact.beginTransaction();){
                LOG.info(String.format("Start indexing collection %s", collection.getURI().toString()));
                this.pool.getProcessMonitor().startJob("reindex collection", collection.getURI());
                this.reindexCollection(transaction, collection, mode);
                transact.commit(transaction);
            }
            this.pool.getProcessMonitor().endJob();
        }
        catch (Exception e) {
            try {
                LOG.warn("An error occurred during reindex: " + e.getMessage(), (Throwable)e);
                this.pool.getProcessMonitor().endJob();
            }
            catch (Throwable throwable) {
                this.pool.getProcessMonitor().endJob();
                LOG.info(String.format("Finished indexing collection %s in %s ms.", collection.getURI().toString(), System.currentTimeMillis() - start));
                throw throwable;
            }
            LOG.info(String.format("Finished indexing collection %s in %s ms.", collection.getURI().toString(), System.currentTimeMillis() - start));
        }
        LOG.info(String.format("Finished indexing collection %s in %s ms.", collection.getURI().toString(), System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexCollection(Txn transaction, Collection collection, DBBroker.IndexMode mode) throws PermissionDeniedException, IOException {
        CollectionCache collectionsCache;
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            Comparable<DocumentImpl> next;
            Iterator<Comparable<DocumentImpl>> i;
            if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 2)) {
                throw new PermissionDeniedException("Account " + this.getCurrentSubject().getName() + " have insufficient privileges on collection " + collection.getURI());
            }
            LOG.debug("Reindexing collection " + collection.getURI());
            if (mode == DBBroker.IndexMode.STORE) {
                this.dropCollectionIndex(transaction, collection, true);
            }
            try {
                i = collection.iterator(this);
                while (i.hasNext()) {
                    next = i.next();
                    this.reindexXMLResource(transaction, (DocumentImpl)next, mode);
                }
            }
            catch (LockException e) {
                LOG.error("LockException while reindexing documents of collection '" + collection.getURI() + ". Skipping...", (Throwable)e);
            }
            try {
                i = collection.collectionIterator(this);
                while (i.hasNext()) {
                    next = (XmldbURI)i.next();
                    Collection child = this.getCollection(collection.getURI().append((XmldbURI)next));
                    if (child == null) {
                        LOG.warn("Collection '" + next + "' not found");
                        continue;
                    }
                    this.reindexCollection(transaction, child, mode);
                }
            }
            catch (LockException e) {
                LOG.error("LockException while reindexing child collections of collection '" + collection.getURI() + ". Skipping...", (Throwable)e);
            }
        }
    }

    public void dropCollectionIndex(Txn transaction, Collection collection) throws PermissionDeniedException, IOException {
        this.dropCollectionIndex(transaction, collection, false);
    }

    public void dropCollectionIndex(final Txn transaction, Collection collection, boolean reindex) throws PermissionDeniedException, IOException {
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Account " + this.getCurrentSubject().getName() + " have insufficient privileges on collection " + collection.getURI());
        }
        this.notifyDropIndex(collection);
        this.indexController.removeCollection(collection, this, reindex);
        try {
            Iterator<DocumentImpl> i = collection.iterator(this);
            while (i.hasNext()) {
                final DocumentImpl doc = i.next();
                LOG.debug("Dropping index for document " + doc.getFileURI());
                new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                    @Override
                    public Object start() {
                        try {
                            NodeRef ref = new NodeRef(doc.getDocId());
                            IndexQuery query = new IndexQuery(7, (Value)ref);
                            NativeBroker.this.domDb.remove(transaction, query, null);
                            NativeBroker.this.domDb.flush();
                        }
                        catch (BTreeException e) {
                            DBBroker.LOG.warn("btree error while removing document", (Throwable)e);
                        }
                        catch (DBException e) {
                            DBBroker.LOG.warn("db error while removing document", (Throwable)e);
                        }
                        catch (IOException e) {
                            DBBroker.LOG.warn("io error while removing document", (Throwable)e);
                        }
                        catch (TerminatedException e) {
                            DBBroker.LOG.warn("method terminated", (Throwable)e);
                        }
                        return null;
                    }
                }.run();
            }
        }
        catch (LockException e) {
            LOG.error("LockException while removing index of collection '" + collection.getURI(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DocumentImpl storeTempResource(org.exist.dom.memtree.DocumentImpl doc) throws EXistException, PermissionDeniedException, LockException {
        try {
            DocumentImpl documentImpl;
            Throwable throwable;
            Txn transaction;
            block19: {
                block20: {
                    this.pushSubject(this.pool.getSecurityManager().getSystemSubject());
                    TransactionManager transact = this.pool.getTransactionManager();
                    XmldbURI docName = XmldbURI.create(MessageDigester.md5(Thread.currentThread().getName() + Long.toString(System.currentTimeMillis()), false) + ".xml");
                    transaction = transact.beginTransaction();
                    throwable = null;
                    Tuple2<Boolean, Collection> tuple = this.getOrCreateTempCollection(transaction);
                    Collection temp = (Collection)tuple._2;
                    if (!((Boolean)tuple._1).booleanValue()) {
                        transaction.acquireLock(temp.getLock(), Lock.LockMode.WRITE_LOCK);
                    }
                    DocumentImpl targetDoc = new DocumentImpl(this.pool, temp, docName);
                    targetDoc.getPermissions().setMode(505);
                    long now = System.currentTimeMillis();
                    DocumentMetadata metadata = new DocumentMetadata();
                    metadata.setLastModified(now);
                    metadata.setCreated(now);
                    targetDoc.setMetadata(metadata);
                    targetDoc.setDocId(this.getNextResourceId(transaction, temp));
                    DOMIndexer indexer = new DOMIndexer(this, transaction, doc, targetDoc);
                    indexer.scan();
                    indexer.store();
                    temp.addDocument(transaction, this, targetDoc);
                    this.storeXMLResource(transaction, targetDoc);
                    this.saveCollection(transaction, temp);
                    this.flush();
                    this.closeDocument();
                    transact.commit(transaction);
                    documentImpl = targetDoc;
                    if (transaction == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                transaction.close();
            }
            return documentImpl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (transaction != null) {
                            if (throwable != null) {
                                try {
                                    transaction.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                transaction.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to store temporary fragment: " + e.getMessage(), (Throwable)e);
                    this.popSubject();
                }
            }
        }
        finally {
            this.popSubject();
        }
        return null;
    }

    @Override
    public void cleanUpTempResources(boolean forceRemoval) throws PermissionDeniedException {
        Collection temp = this.getCollection(XmldbURI.TEMP_COLLECTION_URI);
        if (temp == null) {
            return;
        }
        TransactionManager transact = this.pool.getTransactionManager();
        try (Txn transaction = transact.beginTransaction();){
            this.removeCollection(transaction, temp);
            transact.commit(transaction);
        }
        catch (Exception e) {
            LOG.warn("Failed to remove temp collection: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentImpl getResourceById(int collectionId, byte resourceType, int documentId) throws PermissionDeniedException {
        XmldbURI uri = null;
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            String collectionUri = null;
            if (collectionId == 0) {
                collectionUri = "/db";
            } else {
                for (Value collectionDbKey : this.collectionsDb.getKeys()) {
                    VariableByteInput vbi;
                    int id;
                    if (collectionDbKey.data()[0] != 0 || collectionId != (id = (vbi = this.collectionsDb.getAsStream(collectionDbKey)).readInt())) continue;
                    collectionUri = new String(Arrays.copyOfRange(collectionDbKey.data(), 1, collectionDbKey.data().length));
                    break;
                }
            }
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(collectionId, resourceType, documentId);
            VariableByteInput vbi = this.collectionsDb.getAsStream(key);
            vbi.readInt();
            String resourceUri = vbi.readUTF();
            uri = XmldbURI.createInternal(collectionUri + "/" + resourceUri);
        }
        catch (TerminatedException te) {
            LOG.error("Query Terminated", (Throwable)te);
            DocumentImpl documentImpl = null;
            return documentImpl;
        }
        catch (BTreeException bte) {
            LOG.error("Problem reading btree", (Throwable)bte);
            DocumentImpl documentImpl = null;
            return documentImpl;
        }
        catch (LockException e) {
            LOG.error("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
            DocumentImpl documentImpl = null;
            return documentImpl;
        }
        catch (IOException e) {
            LOG.error("IOException while reading resource data", (Throwable)e);
            DocumentImpl documentImpl = null;
            return documentImpl;
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
        return this.getResource(uri, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeXMLResource(Txn transaction, DocumentImpl doc) {
        Lock lock = this.collectionsDb.getLock();
        try (VariableByteOutputStream os = new VariableByteOutputStream(8);){
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            doc.write(os);
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(doc.getCollection().getId(), doc.getResourceType(), doc.getDocId());
            this.collectionsDb.put(transaction, (Value)key, os.data(), true);
        }
        catch (LockException e) {
            LOG.error("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
        }
        catch (IOException e) {
            LOG.error("IOException while writing document data: " + doc.getURI(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void storeMetadata(Txn transaction, DocumentImpl doc) throws TriggerException {
        Collection col = doc.getCollection();
        DocumentTriggers trigger = new DocumentTriggers(this, col);
        trigger.beforeUpdateDocumentMetadata(this, transaction, doc);
        this.storeXMLResource(transaction, doc);
        trigger.afterUpdateDocumentMetadata(this, transaction, doc);
    }

    protected Path getCollectionFile(Path dir, XmldbURI uri, boolean create) throws IOException {
        return this.getCollectionFile(dir, null, uri, create);
    }

    public Path getCollectionBinaryFileFsPath(XmldbURI uri) {
        String suri = uri.getURI().toString();
        if (suri.startsWith("/")) {
            suri = suri.substring(1);
        }
        return this.getFsDir().resolve(suri);
    }

    private Path getCollectionFile(Path dir, Txn transaction, XmldbURI uri, boolean create) throws IOException {
        if (transaction != null) {
            dir = dir.resolve("txn." + transaction.getId());
            if (create && !Files.exists(dir, new LinkOption[0])) {
                dir = Files.createDirectory(dir, new FileAttribute[0]);
            }
            dir = dir.resolve("oper." + UUID.randomUUID().toString());
            if (create && !Files.exists(dir, new LinkOption[0])) {
                dir = Files.createDirectory(dir, new FileAttribute[0]);
            }
        }
        XmldbURI[] segments = uri.getPathSegments();
        Path binFile = dir;
        int last = segments.length - 1;
        for (int i = 0; i < segments.length; ++i) {
            binFile = binFile.resolve(segments[i].toString());
            if (!create || i == last || Files.exists(binFile, new LinkOption[0])) continue;
            Files.createDirectory(binFile, new FileAttribute[0]);
        }
        return binFile;
    }

    @Override
    @Deprecated
    public void storeBinaryResource(Txn transaction, BinaryDocument blob, byte[] data) throws IOException {
        this.storeBinaryResource(transaction, blob, (ConsumerE<Path, IOException>)((ConsumerE)dest -> {
            try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
                Files.copy(is, dest, new CopyOption[0]);
            }
        }));
    }

    @Override
    public void storeBinaryResource(Txn transaction, BinaryDocument blob, InputStream is) throws IOException {
        this.storeBinaryResource(transaction, blob, (ConsumerE<Path, IOException>)((ConsumerE)dest -> Files.copy(is, dest, new CopyOption[0])));
    }

    private void storeBinaryResource(Txn transaction, BinaryDocument blob, ConsumerE<Path, IOException> fWriteData) throws IOException {
        Optional<Object> fLoggable;
        blob.setPage(-1L);
        Path binFile = this.getCollectionFile(this.getFsDir(), blob.getURI(), true);
        boolean exists = Files.exists(binFile, new LinkOption[0]);
        if (this.fsJournalDir.isPresent()) {
            if (exists) {
                Path backupFile = this.getCollectionFile(this.fsJournalDir.get(), transaction, blob.getURI(), true);
                Files.move(binFile, backupFile, StandardCopyOption.ATOMIC_MOVE);
                fLoggable = Optional.of(original -> new UpdateBinaryLoggable(this, transaction, (Path)original, backupFile));
            } else {
                fLoggable = Optional.of(original -> new CreateBinaryLoggable(this, transaction, (Path)original));
            }
        } else {
            Files.deleteIfExists(binFile);
            fLoggable = Optional.empty();
        }
        fWriteData.accept((Object)binFile);
        if (this.logManager.isPresent() && fLoggable.isPresent()) {
            Loggable loggable = (Loggable)((Function)fLoggable.get()).apply(binFile);
            try {
                this.logManager.get().journal(loggable);
            }
            catch (JournalException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Document getXMLResource(XmldbURI fileName) throws PermissionDeniedException {
        return this.getResource(fileName, 4);
    }

    @Override
    public DocumentImpl getResource(XmldbURI fileName, int accessType) throws PermissionDeniedException {
        fileName = this.prepend(fileName.toCollectionPathURI());
        XmldbURI collUri = fileName.removeLastSegment();
        XmldbURI docUri = fileName.lastSegment();
        Collection collection = this.getCollection(collUri);
        if (collection == null) {
            LOG.debug("collection '" + collUri + "' not found!");
            return null;
        }
        DocumentImpl doc = collection.getDocument(this, docUri);
        if (doc == null) {
            LOG.debug("document '" + fileName + "' not found!");
            return null;
        }
        if (!doc.getPermissions().validate(this.getCurrentSubject(), accessType)) {
            throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' not allowed requested access to document '" + fileName + "'");
        }
        if (doc.getResourceType() == 1) {
            BinaryDocument bin = (BinaryDocument)doc;
            try {
                bin.setContentLength(this.getBinaryResourceSize(bin));
            }
            catch (IOException ex) {
                LOG.fatal("Cannot get content size for " + bin.getURI(), (Throwable)ex);
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentImpl getXMLResource(XmldbURI fileName, Lock.LockMode lockMode) throws PermissionDeniedException {
        if (fileName == null) {
            return null;
        }
        fileName = this.prepend(fileName.toCollectionPathURI());
        XmldbURI collUri = fileName.removeLastSegment();
        XmldbURI docUri = fileName.lastSegment();
        Collection collection = null;
        try {
            collection = this.openCollection(collUri, Lock.LockMode.READ_LOCK);
            if (collection == null) {
                LOG.debug("Collection '" + collUri + "' not found!");
                DocumentImpl documentImpl = null;
                return documentImpl;
            }
            DocumentImpl doc = collection.getDocumentWithLock(this, docUri, lockMode);
            if (doc == null) {
                DocumentImpl documentImpl = null;
                return documentImpl;
            }
            if (doc.getResourceType() == 1) {
                BinaryDocument bin = (BinaryDocument)doc;
                try {
                    bin.setContentLength(this.getBinaryResourceSize(bin));
                }
                catch (IOException ex) {
                    LOG.fatal("Cannot get content size for " + bin.getURI(), (Throwable)ex);
                }
            }
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        catch (LockException e) {
            LOG.warn("Could not acquire lock on document " + fileName, (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(Lock.LockMode.READ_LOCK);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBinaryResource(BinaryDocument blob, OutputStream os) throws IOException {
        try (InputStream is = null;){
            int len;
            is = this.getBinaryResource(blob);
            byte[] buffer = new byte[65536];
            while ((len = is.read(buffer)) >= 0) {
                os.write(buffer, 0, len);
            }
        }
    }

    @Override
    public long getBinaryResourceSize(BinaryDocument blob) throws IOException {
        Path binFile = this.getCollectionFile(this.getFsDir(), blob.getURI(), false);
        return Files.size(binFile);
    }

    @Override
    public Path getBinaryFile(BinaryDocument blob) throws IOException {
        return this.getCollectionFile(this.getFsDir(), blob.getURI(), false);
    }

    @Override
    public InputStream getBinaryResource(BinaryDocument blob) throws IOException {
        return Files.newInputStream(this.getCollectionFile(this.getFsDir(), blob.getURI(), false), new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCollectionResources(Collection.InternalAccess collectionInternalAccess) {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(collectionInternalAccess.getId());
            IndexQuery query = new IndexQuery(7, (Value)key);
            this.collectionsDb.query(query, new DocumentCallback(collectionInternalAccess));
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
        }
        catch (IOException | BTreeException | TerminatedException e) {
            LOG.warn("Exception while reading document data", (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getResourcesFailsafe(BTreeCallback callback, boolean fullScan) throws TerminatedException {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey();
            IndexQuery query = new IndexQuery(7, (Value)key);
            if (fullScan) {
                this.collectionsDb.rawScan(query, callback);
            } else {
                this.collectionsDb.query(query, callback);
            }
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
        }
        catch (IOException | BTreeException e) {
            LOG.warn("Exception while reading document data", (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCollectionsFailsafe(BTreeCallback callback) throws TerminatedException {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey();
            IndexQuery query = new IndexQuery(7, (Value)key);
            this.collectionsDb.query(query, callback);
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
        }
        catch (IOException | BTreeException e) {
            LOG.warn("Exception while reading document data", (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    @Override
    public MutableDocumentSet getXMLResourcesByDoctype(String doctypeName, MutableDocumentSet result) throws PermissionDeniedException {
        MutableDocumentSet docs = this.getAllXMLResources(new DefaultDocumentSet());
        Iterator<DocumentImpl> i = docs.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl doc = i.next();
            DocumentType doctype = doc.getDoctype();
            if (doctype == null || !doctypeName.equals(doctype.getName()) || !doc.getCollection().getPermissionsNoLock().validate(this.getCurrentSubject(), 4) || !doc.getPermissions().validate(this.getCurrentSubject(), 4)) continue;
            result.add(doc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableDocumentSet getAllXMLResources(MutableDocumentSet docs) throws PermissionDeniedException {
        long start = System.currentTimeMillis();
        Collection rootCollection = null;
        try {
            rootCollection = this.openCollection(XmldbURI.ROOT_COLLECTION_URI, Lock.LockMode.READ_LOCK);
            rootCollection.allDocs(this, docs, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllDocuments(DocumentSet) - end - loading " + docs.getDocumentCount() + " documents took " + (System.currentTimeMillis() - start) + "ms.");
            }
            MutableDocumentSet mutableDocumentSet = docs;
            return mutableDocumentSet;
        }
        finally {
            if (rootCollection != null) {
                rootCollection.release(Lock.LockMode.READ_LOCK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyResource(Txn transaction, DocumentImpl doc, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException, EXistException, IOException {
        CollectionCache collectionsCache;
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        Collection collection = doc.getCollection();
        if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 1)) {
            throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' has insufficient privileges to copy the resource '" + doc.getFileURI() + "'.");
        }
        if (!doc.getPermissions().validate(this.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' has insufficient privileges to copy the resource '" + doc.getFileURI() + "'.");
        }
        if (newName == null) {
            newName = doc.getFileURI();
        }
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            Lock lock = this.collectionsDb.getLock();
            try {
                lock.acquire(Lock.LockMode.WRITE_LOCK);
                DocumentImpl oldDoc = destination.getDocument(this, newName);
                if (!destination.getPermissionsNoLock().validate(this.getCurrentSubject(), 1)) {
                    throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' does not have execute access on the destination collection '" + destination.getURI() + "'.");
                }
                if (destination.hasChildCollection(this, newName.lastSegment())) {
                    throw new EXistException("The collection '" + destination.getURI() + "' already has a sub-collection named '" + newName.lastSegment() + "', you cannot create a Document with the same name as an existing collection.");
                }
                XmldbURI newURI = destination.getURI().append(newName);
                XmldbURI oldUri = doc.getURI();
                DocumentTriggers trigger = new DocumentTriggers(this, collection);
                if (oldDoc == null) {
                    if (!destination.getPermissionsNoLock().validate(this.getCurrentSubject(), 2)) {
                        throw new PermissionDeniedException("Account '" + this.getCurrentSubject().getName() + "' does not have write access on the destination collection '" + destination.getURI() + "'.");
                    }
                } else {
                    if (doc.getDocId() == oldDoc.getDocId()) {
                        throw new EXistException("Cannot copy resource to itself '" + doc.getURI() + "'.");
                    }
                    if (!oldDoc.getPermissions().validate(this.getCurrentSubject(), 2)) {
                        throw new PermissionDeniedException("A resource with the same name already exists in the target collection '" + oldDoc.getURI() + "', and you do not have write access on that resource.");
                    }
                    trigger.beforeDeleteDocument(this, transaction, oldDoc);
                    trigger.afterDeleteDocument(this, transaction, newURI);
                }
                trigger.beforeCopyDocument(this, transaction, doc, newURI);
                DocumentImpl newDocument = null;
                if (doc.getResourceType() == 1) {
                    try (InputStream is = null;){
                        is = this.getBinaryResource((BinaryDocument)doc);
                        newDocument = destination.addBinaryResource(transaction, this, newName, is, doc.getMetadata().getMimeType(), -1L);
                    }
                }
                DocumentImpl newDoc = new DocumentImpl(this.pool, destination, newName);
                newDoc.copyOf(doc, oldDoc != null);
                newDoc.setDocId(this.getNextResourceId(transaction, destination));
                newDoc.getUpdateLock().acquire(Lock.LockMode.WRITE_LOCK);
                try {
                    this.copyXMLResource(transaction, doc, newDoc);
                    destination.addDocument(transaction, this, newDoc);
                    this.storeXMLResource(transaction, newDoc);
                }
                finally {
                    newDoc.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
                }
                newDocument = newDoc;
                trigger.afterCopyDocument(this, transaction, newDocument, oldUri);
            }
            catch (IOException e) {
                LOG.warn("An error occurred while copying resource", (Throwable)e);
            }
            catch (TriggerException e) {
                throw new PermissionDeniedException(e.getMessage(), e);
            }
            finally {
                lock.release(Lock.LockMode.WRITE_LOCK);
            }
        }
    }

    private void copyXMLResource(Txn transaction, DocumentImpl oldDoc, DocumentImpl newDoc) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copying document " + oldDoc.getFileURI() + " to " + newDoc.getURI());
        }
        long start = System.currentTimeMillis();
        StreamListener listener = this.indexController.getStreamListener(newDoc, StreamListener.ReindexMode.STORE);
        NodeList nodes = oldDoc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            IStoredNode node = (IStoredNode)nodes.item(i);
            try (INodeIterator iterator = this.getNodeIterator(node);){
                iterator.next();
                this.copyNodes(transaction, iterator, node, new NodePath(), newDoc, false, listener);
                continue;
            }
        }
        this.flush();
        this.closeDocument();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copy took " + (System.currentTimeMillis() - start) + "ms.");
        }
    }

    @Override
    public void moveResource(Txn transaction, DocumentImpl doc, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException, IOException, TriggerException {
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        Account docUser = doc.getUserLock();
        if (docUser != null && !this.getCurrentSubject().getName().equals(docUser.getName())) {
            throw new PermissionDeniedException("Cannot move '" + doc.getFileURI() + " because is locked by getUser() '" + docUser.getName() + "'");
        }
        Collection collection = doc.getCollection();
        if (!collection.getPermissionsNoLock().validate(this.getCurrentSubject(), 3)) {
            throw new PermissionDeniedException("Account " + this.getCurrentSubject().getName() + " have insufficient privileges on source Collection to move resource " + doc.getFileURI());
        }
        if (!destination.getPermissionsNoLock().validate(this.getCurrentSubject(), 3)) {
            throw new PermissionDeniedException("Account " + this.getCurrentSubject().getName() + " have insufficient privileges on destination Collection to move resource " + doc.getFileURI());
        }
        Path fsOriginalDocument = this.getCollectionFile(this.getFsDir(), doc.getURI(), true);
        XmldbURI oldName = doc.getFileURI();
        if (newName == null) {
            newName = oldName;
        }
        try {
            if (destination.hasChildCollection(this, newName.lastSegment())) {
                throw new PermissionDeniedException("The collection '" + destination.getURI() + "' have collection '" + newName.lastSegment() + "'. Document with same name can't be created.");
            }
            DocumentTriggers trigger = new DocumentTriggers(this, collection);
            DocumentImpl oldDoc = destination.getDocument(this, newName);
            if (oldDoc != null) {
                if (doc.getDocId() == oldDoc.getDocId()) {
                    throw new PermissionDeniedException("Cannot move resource to itself '" + doc.getURI() + "'.");
                }
                this.removeResource(transaction, oldDoc);
            }
            boolean renameOnly = collection.getId() == destination.getId();
            XmldbURI oldURI = doc.getURI();
            XmldbURI newURI = destination.getURI().append(newName);
            trigger.beforeMoveDocument(this, transaction, doc, newURI);
            if (doc.getResourceType() == 0 && !renameOnly) {
                this.dropIndex(transaction, doc);
            }
            collection.unlinkDocument(this, doc);
            if (!renameOnly) {
                this.saveCollection(transaction, collection);
            }
            this.removeResourceMetadata(transaction, doc);
            doc.setFileURI(newName);
            doc.setCollection(destination);
            destination.addDocument(transaction, this, doc);
            if (doc.getResourceType() == 0) {
                if (!renameOnly) {
                    this.reindexXMLResource(transaction, doc, DBBroker.IndexMode.REPAIR);
                }
            } else {
                Path colDir = this.getCollectionFile(this.getFsDir(), destination.getURI(), true);
                Path binFile = colDir.resolve(newName.lastSegment().toString());
                Path sourceFile = this.getCollectionFile(this.getFsDir(), doc.getURI(), false);
                Files.createDirectories(binFile.getParent(), new FileAttribute[0]);
                Files.move(fsOriginalDocument, binFile, StandardCopyOption.ATOMIC_MOVE);
                if (this.logManager.isPresent()) {
                    RenameBinaryLoggable loggable = new RenameBinaryLoggable(this, transaction, sourceFile, binFile);
                    try {
                        this.logManager.get().journal(loggable);
                    }
                    catch (JournalException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.storeXMLResource(transaction, doc);
            this.saveCollection(transaction, destination);
            trigger.afterMoveDocument(this, transaction, doc, oldURI);
        }
        catch (ReadOnlyException e) {
            throw new PermissionDeniedException(e.getMessage(), e);
        }
    }

    @Override
    public void removeXMLResource(final Txn transaction, final DocumentImpl document, boolean freeDocId) throws PermissionDeniedException, IOException {
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Removing document " + document.getFileURI() + " (" + document.getDocId() + ") ...");
            }
            DocumentTriggers trigger = new DocumentTriggers(this);
            if (freeDocId) {
                trigger.beforeDeleteDocument(this, transaction, document);
            }
            this.dropIndex(transaction, document);
            if (LOG.isDebugEnabled()) {
                LOG.debug("removeDocument() - removing dom");
            }
            try {
                if (!document.getMetadata().isReferenced()) {
                    new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                        @Override
                        public Object start() {
                            NodeHandle node = (NodeHandle)((Object)document.getFirstChild());
                            NativeBroker.this.domDb.removeAll(transaction, node.getInternalAddress());
                            return null;
                        }
                    }.run();
                }
            }
            catch (NullPointerException npe0) {
                LOG.error("Caught NPE in DOMTransaction to actually be able to remove the document.");
            }
            NodeRef ref = new NodeRef(document.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                @Override
                public Object start() {
                    try {
                        NativeBroker.this.domDb.remove(transaction, idx, null);
                    }
                    catch (IOException | BTreeException e) {
                        DBBroker.LOG.warn("start() - error while removing doc", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        DBBroker.LOG.warn("method terminated", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            this.removeResourceMetadata(transaction, document);
            if (freeDocId) {
                this.collectionsDb.freeResourceId(document.getDocId());
                trigger.afterDeleteDocument(this, transaction, document.getURI());
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn("removeDocument(String) - Database is read-only");
        }
        catch (TriggerException e) {
            LOG.warn((Object)e);
        }
    }

    private void dropIndex(Txn transaction, DocumentImpl document) throws ReadOnlyException {
        StreamListener listener = this.indexController.getStreamListener(document, StreamListener.ReindexMode.REMOVE_ALL_NODES);
        listener.startIndexDocument(transaction);
        NodeList nodes = document.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            IStoredNode node = (IStoredNode)nodes.item(i);
            try (INodeIterator iterator = this.getNodeIterator(node);){
                iterator.next();
                this.scanNodes(transaction, iterator, node, new NodePath(), DBBroker.IndexMode.REMOVE, listener);
                continue;
            }
            catch (IOException ioe) {
                LOG.warn("Unable to close node iterator", (Throwable)ioe);
            }
        }
        listener.endIndexDocument(transaction);
        this.notifyDropIndex(document);
        this.indexController.flush();
    }

    @Override
    public void removeBinaryResource(Txn transaction, BinaryDocument blob) throws PermissionDeniedException, IOException {
        Path binFile;
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing binary resource " + blob.getDocId() + "...");
        }
        if (Files.exists(binFile = this.getCollectionFile(this.getFsDir(), blob.getURI(), false), new LinkOption[0])) {
            if (this.fsJournalDir.isPresent()) {
                Path binBackupFile = this.getCollectionFile(this.fsJournalDir.get(), transaction, blob.getURI(), true);
                Files.move(binFile, binBackupFile, StandardCopyOption.ATOMIC_MOVE);
                if (this.logManager.isPresent()) {
                    RenameBinaryLoggable loggable = new RenameBinaryLoggable(this, transaction, binFile, binBackupFile);
                    try {
                        this.logManager.get().journal(loggable);
                    }
                    catch (JournalException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                Files.delete(binFile);
            }
        }
        this.removeResourceMetadata(transaction, blob);
        this.getIndexController().setDocument(blob, StreamListener.ReindexMode.REMOVE_BINARY);
        this.getIndexController().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResourceMetadata(Txn transaction, DocumentImpl document) {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing resource metadata for " + document.getDocId());
            }
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(document.getCollection().getId(), document.getResourceType(), document.getDocId());
            this.collectionsDb.remove(transaction, key);
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()));
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void removeResource(Txn tx, DocumentImpl doc) throws IOException, PermissionDeniedException {
        if (doc instanceof BinaryDocument) {
            this.removeBinaryResource(tx, (BinaryDocument)doc);
        } else {
            this.removeXMLResource(tx, doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextResourceId(Txn transaction, Collection collection) throws EXistException {
        int nextDocId = this.collectionsDb.getFreeResourceId();
        if (nextDocId != -1) {
            return nextDocId;
        }
        nextDocId = 1;
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__next_doc_id");
            Value data = this.collectionsDb.get(key);
            if (data != null) {
                nextDocId = ByteConversion.byteToInt(data.getData(), 0);
                if (++nextDocId == Integer.MAX_VALUE) {
                    this.pool.setReadOnly();
                    throw new EXistException("Max. number of document ids reached. Database is set to read-only state. Please do a complete backup/restore to compact the db and free document ids.");
                }
            }
            byte[] d = new byte[4];
            ByteConversion.intToByte(nextDocId, d, 0);
            this.collectionsDb.put(transaction, (Value)key, d, true);
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
        return nextDocId;
    }

    @Override
    public void reindexXMLResource(Txn txn, DocumentImpl doc) {
        this.reindexXMLResource(txn, doc, DBBroker.IndexMode.REPAIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindexXMLResource(Txn transaction, DocumentImpl doc, DBBroker.IndexMode mode) {
        if (doc.isCollectionConfig()) {
            doc.getCollection().setCollectionConfigEnabled(false);
        }
        StreamListener listener = this.indexController.getStreamListener(doc, StreamListener.ReindexMode.STORE);
        this.indexController.startIndexDocument(transaction, listener);
        try {
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                IStoredNode node = (IStoredNode)nodes.item(i);
                try (INodeIterator iterator = this.getNodeIterator(node);){
                    iterator.next();
                    this.scanNodes(transaction, iterator, node, new NodePath(), mode, listener);
                    continue;
                }
                catch (IOException ioe) {
                    LOG.warn("Unable to close node iterator", (Throwable)ioe);
                }
            }
        }
        finally {
            this.indexController.endIndexDocument(transaction, listener);
        }
        this.flush();
        if (doc.isCollectionConfig()) {
            doc.getCollection().setCollectionConfigEnabled(true);
        }
    }

    @Override
    public void defragXMLResource(final Txn transaction, DocumentImpl doc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("============> Defragmenting document " + doc.getURI());
        }
        long start = System.currentTimeMillis();
        try {
            final long firstChild = doc.getFirstChildAddress();
            this.dropIndex(transaction, doc);
            NodeRef ref = new NodeRef(doc.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                @Override
                public Object start() {
                    try {
                        NativeBroker.this.domDb.remove(transaction, idx, null);
                        NativeBroker.this.domDb.flush();
                    }
                    catch (IOException | DBException e) {
                        DBBroker.LOG.warn("start() - error while removing doc", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        DBBroker.LOG.warn("method terminated", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            DocumentImpl tempDoc = new DocumentImpl(this.pool, doc.getCollection(), doc.getFileURI());
            tempDoc.copyOf(doc, true);
            tempDoc.setDocId(doc.getDocId());
            StreamListener listener = this.indexController.getStreamListener(doc, StreamListener.ReindexMode.STORE);
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                IStoredNode node = (IStoredNode)nodes.item(i);
                try (INodeIterator iterator = this.getNodeIterator(node);){
                    iterator.next();
                    this.copyNodes(transaction, iterator, node, new NodePath(), tempDoc, true, listener);
                    continue;
                }
            }
            this.flush();
            new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                @Override
                public Object start() {
                    NativeBroker.this.domDb.removeAll(transaction, firstChild);
                    try {
                        NativeBroker.this.domDb.flush();
                    }
                    catch (DBException e) {
                        DBBroker.LOG.warn("start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            doc.copyChildren(tempDoc);
            doc.getMetadata().setSplitCount(0);
            doc.getMetadata().setPageCount(tempDoc.getMetadata().getPageCount());
            this.storeXMLResource(transaction, doc);
            this.closeDocument();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Defragmentation took " + (System.currentTimeMillis() - start) + "ms.");
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn(DATABASE_IS_READ_ONLY, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public void checkXMLResourceConsistency(DocumentImpl doc) throws EXistException {
        boolean xupdateConsistencyChecks = false;
        Object property = this.pool.getConfiguration().getProperty("xupdate.consistency-checks");
        if (property != null) {
            xupdateConsistencyChecks = (Boolean)property;
        }
        if (xupdateConsistencyChecks) {
            LOG.debug("Checking document " + doc.getFileURI());
            this.checkXMLResourceTree(doc);
        }
    }

    @Override
    public void checkXMLResourceTree(final DocumentImpl doc) {
        LOG.debug("Checking DOM tree for document " + doc.getFileURI());
        boolean xupdateConsistencyChecks = false;
        Object property = this.pool.getConfiguration().getProperty("xupdate.consistency-checks");
        if (property != null) {
            xupdateConsistencyChecks = (Boolean)property;
        }
        if (xupdateConsistencyChecks) {
            new DOMTransaction(this, this.domDb, Lock.LockMode.READ_LOCK){

                @Override
                public Object start() throws ReadOnlyException {
                    DBBroker.LOG.debug("Pages used: " + NativeBroker.this.domDb.debugPages(doc, false));
                    return null;
                }
            }.run();
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                IStoredNode node = (IStoredNode)nodes.item(i);
                try (INodeIterator iterator = this.getNodeIterator(node);){
                    iterator.next();
                    StringBuilder buf = new StringBuilder();
                    if (this.checkNodeTree(iterator, node, buf)) continue;
                    LOG.debug("node tree: " + buf.toString());
                    throw new RuntimeException("Error in document tree structure");
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
            NodeRef ref = new NodeRef(doc.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb, Lock.LockMode.READ_LOCK){

                @Override
                public Object start() {
                    try {
                        NativeBroker.this.domDb.findKeys(idx);
                    }
                    catch (IOException | BTreeException e) {
                        DBBroker.LOG.warn("start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
        }
    }

    @Override
    public <T extends IStoredNode> void storeNode(final Txn transaction, final IStoredNode<T> node, NodePath currentPath, IndexSpec indexSpec) {
        this.checkAvailableMemory();
        final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        final short nodeType = node.getNodeType();
        final byte[] data = node.serialize();
        new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK, doc){

            @Override
            public Object start() throws ReadOnlyException {
                long address = nodeType == 3 || nodeType == 2 || nodeType == 4 || node.getNodeId().getTreeLevel() > NativeBroker.this.defaultIndexDepth ? NativeBroker.this.domDb.add(transaction, data) : NativeBroker.this.domDb.put(transaction, new NodeRef(doc.getDocId(), node.getNodeId()), data);
                if (address == -1L) {
                    DBBroker.LOG.warn("address is missing");
                }
                node.setInternalAddress(address);
                return null;
            }
        }.run();
        ++this.nodesCount;
        ByteArrayPool.releaseByteArray(data);
        this.nodeProcessor.reset(transaction, node, currentPath, indexSpec);
        this.nodeProcessor.doIndex();
    }

    @Override
    public <T extends IStoredNode> void updateNode(final Txn transaction, final IStoredNode<T> node, boolean reindex) {
        try {
            final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
            final long internalAddress = node.getInternalAddress();
            final byte[] data = node.serialize();
            new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                @Override
                public Object start() throws ReadOnlyException {
                    if (StorageAddress.hasAddress(internalAddress)) {
                        NativeBroker.this.domDb.update(transaction, internalAddress, data);
                    } else {
                        NativeBroker.this.domDb.update(transaction, new NodeRef(doc.getDocId(), node.getNodeId()), data);
                    }
                    return null;
                }
            }.run();
            ByteArrayPool.releaseByteArray(data);
        }
        catch (Exception e) {
            Value oldVal = this.domDb.get(node.getInternalAddress());
            StoredNode old = StoredNode.deserialize(oldVal.data(), oldVal.start(), oldVal.getLength(), (DocumentImpl)node.getOwnerDocument(), false);
            LOG.warn("Exception while storing " + node.getNodeName() + "; gid = " + node.getNodeId() + "; old = " + old.getNodeName(), (Throwable)e);
        }
    }

    @Override
    public void insertNodeAfter(final Txn transaction, final NodeHandle previous, final IStoredNode node) {
        final byte[] data = node.serialize();
        final DocumentImpl doc = (DocumentImpl)previous.getOwnerDocument();
        new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK, doc){

            @Override
            public Object start() {
                long address = previous.getInternalAddress();
                if (address != -1L) {
                    address = NativeBroker.this.domDb.insertAfter(transaction, doc, address, data);
                } else {
                    NodeRef ref = new NodeRef(doc.getDocId(), previous.getNodeId());
                    address = NativeBroker.this.domDb.insertAfter(transaction, doc, ref, data);
                }
                node.setInternalAddress(address);
                return null;
            }
        }.run();
    }

    private <T extends IStoredNode> void copyNodes(Txn transaction, INodeIterator iterator, IStoredNode<T> node, NodePath currentPath, DocumentImpl newDoc, boolean defragment, StreamListener listener) {
        this.copyNodes(transaction, iterator, node, currentPath, newDoc, defragment, listener, null);
    }

    private <T extends IStoredNode> void copyNodes(Txn transaction, INodeIterator iterator, IStoredNode<T> node, NodePath currentPath, DocumentImpl newDoc, boolean defragment, StreamListener listener, NodeId oldNodeId) {
        if (node.getNodeType() == 1) {
            currentPath.addComponent(node.getQName());
        }
        DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        long oldAddress = node.getInternalAddress();
        node.setOwnerDocument(newDoc);
        node.setInternalAddress(-1L);
        this.storeNode(transaction, node, currentPath, null);
        if (defragment && oldNodeId != null) {
            this.pool.getNotificationService().notifyMove(oldNodeId, node);
        }
        if (node.getNodeType() == 1) {
            long address = node.getInternalAddress();
            node.setInternalAddress(oldAddress);
            this.endElement(node, currentPath, null);
            node.setInternalAddress(address);
            node.setDirty(false);
        }
        if (node.getNodeId().getTreeLevel() == 1) {
            newDoc.appendChild(node);
        }
        node.setOwnerDocument(doc);
        if (listener != null) {
            switch (node.getNodeType()) {
                case 3: {
                    listener.characters(transaction, (TextImpl)node, currentPath);
                    break;
                }
                case 1: {
                    listener.startElement(transaction, (ElementImpl)node, currentPath);
                    break;
                }
                case 2: {
                    listener.attribute(transaction, (AttrImpl)node, currentPath);
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    LOG.debug("Unhandled node type: " + node.getNodeType());
                }
            }
        }
        if (node.hasChildNodes() || node.hasAttributes()) {
            int count = node.getChildCount();
            NodeId nodeId = node.getNodeId();
            for (int i = 0; i < count; ++i) {
                IStoredNode child = (IStoredNode)iterator.next();
                oldNodeId = child.getNodeId();
                if (defragment) {
                    nodeId = i == 0 ? nodeId.newChild() : nodeId.nextSibling();
                    child.setNodeId(nodeId);
                }
                this.copyNodes(transaction, iterator, child, currentPath, newDoc, defragment, listener, oldNodeId);
            }
        }
        if (node.getNodeType() == 1) {
            if (listener != null) {
                listener.endElement(transaction, (ElementImpl)node, currentPath);
            }
            currentPath.removeLastComponent();
        }
    }

    @Override
    public <T extends IStoredNode> void removeNode(final Txn transaction, final IStoredNode<T> node, NodePath currentPath, String content) {
        final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK, doc){

            @Override
            public Object start() {
                long address = node.getInternalAddress();
                if (StorageAddress.hasAddress(address)) {
                    NativeBroker.this.domDb.remove(transaction, new NodeRef(doc.getDocId(), node.getNodeId()), address);
                } else {
                    NativeBroker.this.domDb.remove(transaction, new NodeRef(doc.getDocId(), node.getNodeId()));
                }
                return null;
            }
        }.run();
        this.notifyRemoveNode(node, currentPath, content);
        switch (node.getNodeType()) {
            case 1: {
                QNameRangeIndexSpec qnSpec;
                QName qname = new QName(node.getQName(), 0);
                node.setQName(qname);
                GeneralRangeIndexSpec spec1 = doc.getCollection().getIndexByPathConfiguration(this, currentPath);
                if (spec1 != null) {
                    this.valueIndex.setDocument(doc);
                    this.valueIndex.storeElement((ElementImpl)node, content, spec1.getType(), NativeValueIndex.IndexType.GENERIC, false);
                }
                if ((qnSpec = doc.getCollection().getIndexByQNameConfiguration(this, qname)) == null) break;
                this.valueIndex.setDocument(doc);
                this.valueIndex.storeElement((ElementImpl)node, content, qnSpec.getType(), NativeValueIndex.IndexType.QNAME, false);
                break;
            }
            case 2: {
                QNameRangeIndexSpec qnSpec;
                QName qname = new QName(node.getQName(), 1);
                node.setQName(qname);
                currentPath.addComponent(qname);
                AttrImpl attr = (AttrImpl)node;
                switch (attr.getType()) {
                    case 1: {
                        this.valueIndex.setDocument(doc);
                        this.valueIndex.storeAttribute(attr, attr.getValue(), 66, NativeValueIndex.IndexType.GENERIC, false);
                        break;
                    }
                    case 2: {
                        this.valueIndex.setDocument(doc);
                        this.valueIndex.storeAttribute(attr, attr.getValue(), 67, NativeValueIndex.IndexType.GENERIC, false);
                        break;
                    }
                    case 3: {
                        this.valueIndex.setDocument(doc);
                        StringTokenizer tokenizer = new StringTokenizer(attr.getValue(), " ");
                        while (tokenizer.hasMoreTokens()) {
                            this.valueIndex.storeAttribute(attr, tokenizer.nextToken(), 67, NativeValueIndex.IndexType.GENERIC, false);
                        }
                        break;
                    }
                }
                GeneralRangeIndexSpec spec2 = doc.getCollection().getIndexByPathConfiguration(this, currentPath);
                if (spec2 != null) {
                    this.valueIndex.setDocument(doc);
                    this.valueIndex.storeAttribute(attr, null, spec2, false);
                }
                if ((qnSpec = doc.getCollection().getIndexByQNameConfiguration(this, qname)) != null) {
                    this.valueIndex.setDocument(doc);
                    this.valueIndex.storeAttribute(attr, null, qnSpec, false);
                }
                currentPath.removeLastComponent();
                break;
            }
        }
    }

    @Override
    public void removeAllNodes(Txn transaction, IStoredNode node, NodePath currentPath, StreamListener listener) {
        try (INodeIterator iterator = this.getNodeIterator(node);){
            iterator.next();
            Stack<RemovedNode> stack = new Stack<RemovedNode>();
            this.collectNodesForRemoval(transaction, stack, iterator, listener, node, currentPath);
            while (!stack.isEmpty()) {
                RemovedNode next = stack.pop();
                this.removeNode(transaction, next.node, next.path, next.content);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Unable to close node iterator", (Throwable)ioe);
        }
    }

    private <T extends IStoredNode> void collectNodesForRemoval(Txn transaction, Stack<RemovedNode> stack, INodeIterator iterator, StreamListener listener, IStoredNode<T> node, NodePath currentPath) {
        RemovedNode removed;
        switch (node.getNodeType()) {
            case 1: {
                DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                String content = null;
                GeneralRangeIndexSpec spec = doc.getCollection().getIndexByPathConfiguration(this, currentPath);
                if (spec != null) {
                    content = this.getNodeValue(node, false);
                } else {
                    QNameRangeIndexSpec qnIdx = doc.getCollection().getIndexByQNameConfiguration(this, node.getQName());
                    if (qnIdx != null) {
                        content = this.getNodeValue(node, false);
                    }
                }
                removed = new RemovedNode(node, new NodePath(currentPath), content);
                stack.push(removed);
                if (listener != null) {
                    listener.startElement(transaction, (ElementImpl)node, currentPath);
                }
                if (node.hasChildNodes() || node.hasAttributes()) {
                    int childCount = node.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        IStoredNode child = (IStoredNode)iterator.next();
                        if (child.getNodeType() == 1) {
                            currentPath.addComponent(child.getQName());
                        }
                        this.collectNodesForRemoval(transaction, stack, iterator, listener, child, currentPath);
                        if (child.getNodeType() != 1) continue;
                        currentPath.removeLastComponent();
                    }
                }
                if (listener == null) break;
                listener.endElement(transaction, (ElementImpl)node, currentPath);
                break;
            }
            case 3: {
                if (listener == null) break;
                listener.characters(transaction, (TextImpl)node, currentPath);
                break;
            }
            case 2: {
                if (listener == null) break;
                listener.attribute(transaction, (AttrImpl)node, currentPath);
            }
        }
        if (node.getNodeType() != 1) {
            removed = new RemovedNode(node, new NodePath(currentPath), null);
            stack.push(removed);
        }
    }

    @Override
    public void indexNode(Txn transaction, IStoredNode node, NodePath currentPath) {
        this.indexNode(transaction, node, currentPath, DBBroker.IndexMode.STORE);
    }

    public void indexNode(Txn transaction, IStoredNode node, NodePath currentPath, DBBroker.IndexMode repairMode) {
        this.nodeProcessor.reset(transaction, node, currentPath, null);
        this.nodeProcessor.setIndexMode(repairMode);
        this.nodeProcessor.index();
    }

    private boolean checkNodeTree(INodeIterator iterator, IStoredNode node, StringBuilder buf) {
        if (buf != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(node.getNodeId());
        }
        boolean docIsValid = true;
        if (node.hasChildNodes() || node.hasAttributes()) {
            int count = node.getChildCount();
            if (buf != null) {
                buf.append('[').append(count).append(']');
            }
            IStoredNode previous = null;
            for (int i = 0; i < count; ++i) {
                NodeId parentId;
                IStoredNode child = (IStoredNode)iterator.next();
                if (!(i <= 0 || child.getNodeId().isSiblingOf(previous.getNodeId()) && child.getNodeId().compareTo(previous.getNodeId()) > 0)) {
                    LOG.fatal("node " + child.getNodeId() + " cannot be a sibling of " + previous.getNodeId() + "; node read from " + StorageAddress.toString(child.getInternalAddress()));
                    docIsValid = false;
                }
                previous = child;
                if (child == null) {
                    LOG.fatal("child " + i + " not found for node: " + node.getNodeName() + ": " + node.getNodeId() + "; children = " + node.getChildCount());
                    docIsValid = false;
                }
                if (!(parentId = child.getNodeId().getParentId()).equals(node.getNodeId())) {
                    LOG.fatal(child.getNodeId() + " is not a child of " + node.getNodeId());
                    docIsValid = false;
                }
                boolean check = this.checkNodeTree(iterator, child, buf);
                if (!docIsValid) continue;
                docIsValid = check;
            }
        }
        return docIsValid;
    }

    private void scanNodes(Txn transaction, INodeIterator iterator, IStoredNode node, NodePath currentPath, DBBroker.IndexMode mode, StreamListener listener) {
        if (node.getNodeType() == 1) {
            currentPath.addComponent(node.getQName());
        }
        this.indexNode(transaction, node, currentPath, mode);
        if (listener != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    listener.characters(transaction, (AbstractCharacterData)node, currentPath);
                    break;
                }
                case 1: {
                    listener.startElement(transaction, (ElementImpl)node, currentPath);
                    break;
                }
                case 2: {
                    listener.attribute(transaction, (AttrImpl)node, currentPath);
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    LOG.debug("Unhandled node type: " + node.getNodeType());
                }
            }
        }
        if (node.hasChildNodes() || node.hasAttributes()) {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                IStoredNode child = (IStoredNode)iterator.next();
                if (child == null) {
                    LOG.fatal("child " + i + " not found for node: " + node.getNodeName() + "; children = " + node.getChildCount());
                    continue;
                }
                this.scanNodes(transaction, iterator, child, currentPath, mode, listener);
            }
        }
        if (node.getNodeType() == 1) {
            this.endElement(node, currentPath, null, mode == DBBroker.IndexMode.REMOVE);
            if (listener != null) {
                listener.endElement(transaction, (ElementImpl)node, currentPath);
            }
            currentPath.removeLastComponent();
        }
    }

    @Override
    public String getNodeValue(final IStoredNode node, final boolean addWhitespace) {
        return (String)new DOMTransaction(this, this.domDb, Lock.LockMode.READ_LOCK){

            @Override
            public Object start() {
                return NativeBroker.this.domDb.getNodeValue(NativeBroker.this, node, addWhitespace);
            }
        }.run();
    }

    @Override
    public IStoredNode objectWith(final Document doc, final NodeId nodeId) {
        return (IStoredNode)new DOMTransaction(this, this.domDb, Lock.LockMode.READ_LOCK){

            @Override
            public Object start() {
                Value val = NativeBroker.this.domDb.get(NativeBroker.this, new NodeProxy((DocumentImpl)doc, nodeId));
                if (val == null) {
                    if (DBBroker.LOG.isDebugEnabled()) {
                        DBBroker.LOG.debug("Node " + nodeId + " not found. This is usually not an error.");
                    }
                    return null;
                }
                StoredNode node = StoredNode.deserialize(val.getData(), 0, val.getLength(), (DocumentImpl)doc);
                node.setOwnerDocument((DocumentImpl)doc);
                node.setInternalAddress(val.getAddress());
                return node;
            }
        }.run();
    }

    @Override
    public IStoredNode objectWith(final NodeProxy p) {
        if (!StorageAddress.hasAddress(p.getInternalAddress())) {
            return this.objectWith(p.getOwnerDocument(), p.getNodeId());
        }
        return (IStoredNode)new DOMTransaction(this, this.domDb, Lock.LockMode.READ_LOCK){

            @Override
            public Object start() {
                IStoredNode node;
                boolean fakeNodeId = p.getNodeId().equals(NodeId.DOCUMENT_NODE);
                Value val = NativeBroker.this.domDb.get(p.getInternalAddress(), false);
                if (val == null) {
                    DBBroker.LOG.debug("Node " + p.getNodeId() + " not found in document " + p.getOwnerDocument().getURI() + "; docId = " + p.getOwnerDocument().getDocId() + ": " + StorageAddress.toString(p.getInternalAddress()));
                    if (fakeNodeId) {
                        return null;
                    }
                } else {
                    node = StoredNode.deserialize(val.getData(), 0, val.getLength(), p.getOwnerDocument());
                    node.setOwnerDocument(p.getOwnerDocument());
                    node.setInternalAddress(p.getInternalAddress());
                    if (fakeNodeId) {
                        return node;
                    }
                    if (p.getOwnerDocument().getDocId() == ((DocumentImpl)node.getOwnerDocument()).getDocId() && p.getNodeId().equals(node.getNodeId())) {
                        return node;
                    }
                    DBBroker.LOG.debug("Node " + p.getNodeId() + " not found in document " + p.getOwnerDocument().getURI() + "; docId = " + p.getOwnerDocument().getDocId() + ": " + StorageAddress.toString(p.getInternalAddress()) + "; found node " + node.getNodeId() + " instead");
                }
                if ((node = NativeBroker.this.objectWith(p.getOwnerDocument(), p.getNodeId())) != null) {
                    p.setInternalAddress(node.getInternalAddress());
                }
                return node;
            }
        }.run();
    }

    @Override
    public void repair() throws PermissionDeniedException, IOException {
        if (this.isReadOnly()) {
            throw new IOException(DATABASE_IS_READ_ONLY);
        }
        LOG.info("Removing index files ...");
        this.notifyCloseAndRemove();
        try {
            this.pool.getIndexManager().removeIndexes();
        }
        catch (DBException e) {
            LOG.warn("Failed to remove index files during repair: " + e.getMessage(), (Throwable)e);
        }
        LOG.info("Recreating index files ...");
        try {
            this.valueIndex = new NativeValueIndex(this, 2, this.dataDir, this.config);
        }
        catch (DBException e) {
            LOG.warn("Exception during repair: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.pool.getIndexManager().reopenIndexes();
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn("Failed to reopen index files after repair: " + e.getMessage(), (Throwable)e);
        }
        this.initIndexModules();
        LOG.info("Reindexing database files ...");
        this.reindexCollection(null, this.getCollection(XmldbURI.ROOT_COLLECTION_URI), DBBroker.IndexMode.REPAIR);
    }

    @Override
    public void repairPrimary() {
        this.rebuildIndex((byte)3);
        this.rebuildIndex((byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildIndex(byte indexId) {
        BTree btree = this.getStorage(indexId);
        Lock lock = btree.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            LOG.info("Rebuilding index " + FileUtils.fileName(btree.getFile()));
            btree.rebuild();
            LOG.info("Index " + FileUtils.fileName(btree.getFile()) + " was rebuilt.");
        }
        catch (IOException | DBException | LockException | TerminatedException e) {
            LOG.warn("Caught error while rebuilding core index " + FileUtils.fileName(btree.getFile()) + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void flush() {
        this.notifyFlush();
        try {
            this.pool.getSymbols().flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)e);
        }
        this.indexController.flush();
        this.nodesCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(Sync syncEvent) {
        block9: {
            if (this.isReadOnly()) {
                return;
            }
            try {
                new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

                    @Override
                    public Object start() {
                        try {
                            NativeBroker.this.domDb.flush();
                        }
                        catch (DBException e) {
                            DBBroker.LOG.warn("error while flushing dom.dbx", (Throwable)e);
                        }
                        return null;
                    }
                }.run();
                if (syncEvent != Sync.MAJOR) break block9;
                Lock lock = this.collectionsDb.getLock();
                try {
                    lock.acquire(Lock.LockMode.WRITE_LOCK);
                    this.collectionsDb.flush();
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.collectionsDb.getFile()), (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.WRITE_LOCK);
                }
                this.notifySync();
                this.pool.getIndexManager().sync();
                if (System.currentTimeMillis() > this.nextReportTS) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    LOG_STATS.info("Memory: " + nf.format(this.run.totalMemory() / 1024L) + "K total; " + nf.format(this.run.maxMemory() / 1024L) + "K max; " + nf.format(this.run.freeMemory() / 1024L) + "K free");
                    this.domDb.printStatistics();
                    this.collectionsDb.printStatistics();
                    this.notifyPrintStatistics();
                    this.nextReportTS = System.currentTimeMillis() + 600000L;
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
                LOG.warn((Object)dbe);
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            this.flush();
            this.sync(Sync.MAJOR);
            this.domDb.close();
            this.collectionsDb.close();
            this.notifyClose();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        super.shutdown();
    }

    @Override
    public void checkAvailableMemory() {
        if (this.nodesCountThreshold <= 0) {
            if (this.nodesCount > 500) {
                if (this.run.totalMemory() >= this.run.maxMemory() && this.run.freeMemory() < this.pool.getReservedMem()) {
                    this.flush();
                }
                this.nodesCount = 0;
            }
        } else if (this.nodesCount > this.nodesCountThreshold) {
            this.flush();
            this.nodesCount = 0;
        }
    }

    @Override
    public void closeDocument() {
        new DOMTransaction(this, this.domDb, Lock.LockMode.WRITE_LOCK){

            @Override
            public Object start() {
                NativeBroker.this.domDb.closeDocument();
                return null;
            }
        }.run();
    }

    static {
        LogEntryTypes.addEntryType((byte)64, RenameBinaryLoggable::new);
        LogEntryTypes.addEntryType((byte)65, CreateBinaryLoggable::new);
        LogEntryTypes.addEntryType((byte)66, UpdateBinaryLoggable::new);
        ALL_STORAGE_FILES = new byte[]{0, 2, 3};
    }

    private final class DocumentCallback
    implements BTreeCallback {
        private final Collection.InternalAccess collectionInternalAccess;

        private DocumentCallback(Collection.InternalAccess collectionInternalAccess) {
            this.collectionInternalAccess = collectionInternalAccess;
        }

        @Override
        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            try {
                byte type = key.data()[key.start() + 4 + 1];
                VariableByteInput is = NativeBroker.this.collectionsDb.getAsStream(pointer);
                DocumentImpl doc = type == 1 ? new BinaryDocument(NativeBroker.this.pool) : new DocumentImpl(NativeBroker.this.pool);
                doc.read(is);
                this.collectionInternalAccess.addDocument(doc);
            }
            catch (IOException | EXistException e) {
                DBBroker.LOG.error("Exception while reading document data", (Throwable)e);
            }
            return true;
        }
    }

    private class NodeProcessor {
        private Txn transaction;
        private IStoredNode<? extends IStoredNode> node;
        private NodePath currentPath;
        private DocumentImpl doc;
        private long address;
        private IndexSpec idxSpec;
        private int level;
        private DBBroker.IndexMode indexMode = DBBroker.IndexMode.STORE;

        NodeProcessor() {
        }

        public <T extends IStoredNode> void reset(Txn transaction, IStoredNode<T> node, NodePath currentPath, IndexSpec indexSpec) {
            if (node.getNodeId() == null) {
                DBBroker.LOG.warn("illegal node: " + node.getNodeName());
            }
            this.transaction = transaction;
            this.node = node;
            this.currentPath = currentPath;
            this.indexMode = DBBroker.IndexMode.STORE;
            this.doc = (DocumentImpl)node.getOwnerDocument();
            this.address = node.getInternalAddress();
            if (indexSpec == null) {
                indexSpec = this.doc.getCollection().getIndexConfiguration(NativeBroker.this);
            }
            this.idxSpec = indexSpec;
            this.level = node.getNodeId().getTreeLevel();
        }

        public void setIndexMode(DBBroker.IndexMode indexMode) {
            this.indexMode = indexMode;
        }

        public void doIndex() {
            switch (this.node.getNodeType()) {
                case 1: {
                    QNameRangeIndexSpec qnIdx;
                    int indexType = 0;
                    if (this.idxSpec != null && this.idxSpec.getIndexByPath(this.currentPath) != null) {
                        indexType |= this.idxSpec.getIndexByPath(this.currentPath).getIndexType();
                    }
                    if (this.idxSpec != null && (qnIdx = this.idxSpec.getIndexByQName(this.node.getQName())) != null && !RangeIndexSpec.hasRangeIndex(indexType |= 0x10)) {
                        indexType |= qnIdx.getIndexType();
                    }
                    ((ElementImpl)this.node).setIndexType(indexType);
                    break;
                }
                case 2: {
                    QName qname = new QName(this.node.getQName());
                    if (this.currentPath != null) {
                        this.currentPath.addComponent(qname);
                    }
                    int indexType = 0;
                    if (this.idxSpec != null) {
                        QNameRangeIndexSpec qnIdx;
                        GeneralRangeIndexSpec rangeSpec = this.idxSpec.getIndexByPath(this.currentPath);
                        if (rangeSpec != null) {
                            indexType |= rangeSpec.getIndexType();
                        }
                        if (rangeSpec != null) {
                            NativeBroker.this.valueIndex.setDocument((DocumentImpl)this.node.getOwnerDocument());
                            NativeBroker.this.valueIndex.storeAttribute((AttrImpl)this.node, this.currentPath, rangeSpec, this.indexMode == DBBroker.IndexMode.REMOVE);
                        }
                        if ((qnIdx = this.idxSpec.getIndexByQName(this.node.getQName())) != null) {
                            if (!RangeIndexSpec.hasRangeIndex(indexType |= 0x10)) {
                                indexType |= qnIdx.getIndexType();
                            }
                            NativeBroker.this.valueIndex.setDocument((DocumentImpl)this.node.getOwnerDocument());
                            NativeBroker.this.valueIndex.storeAttribute((AttrImpl)this.node, this.currentPath, qnIdx, this.indexMode == DBBroker.IndexMode.REMOVE);
                        }
                    }
                    this.node.setQName(new QName(qname, 1));
                    AttrImpl attr = (AttrImpl)this.node;
                    attr.setIndexType(indexType);
                    switch (attr.getType()) {
                        case 1: {
                            NativeBroker.this.valueIndex.setDocument(this.doc);
                            NativeBroker.this.valueIndex.storeAttribute(attr, attr.getValue(), 66, NativeValueIndex.IndexType.GENERIC, this.indexMode == DBBroker.IndexMode.REMOVE);
                            break;
                        }
                        case 2: {
                            NativeBroker.this.valueIndex.setDocument(this.doc);
                            NativeBroker.this.valueIndex.storeAttribute(attr, attr.getValue(), 67, NativeValueIndex.IndexType.GENERIC, this.indexMode == DBBroker.IndexMode.REMOVE);
                            break;
                        }
                        case 3: {
                            NativeBroker.this.valueIndex.setDocument(this.doc);
                            StringTokenizer tokenizer = new StringTokenizer(attr.getValue(), " ");
                            while (tokenizer.hasMoreTokens()) {
                                NativeBroker.this.valueIndex.storeAttribute(attr, tokenizer.nextToken(), 67, NativeValueIndex.IndexType.GENERIC, this.indexMode == DBBroker.IndexMode.REMOVE);
                            }
                            break;
                        }
                    }
                    if (this.currentPath == null) break;
                    this.currentPath.removeLastComponent();
                    break;
                }
                case 3: {
                    NativeBroker.this.notifyStoreText((TextImpl)this.node, this.currentPath);
                }
            }
        }

        public void store() {
            final DocumentImpl doc = (DocumentImpl)this.node.getOwnerDocument();
            if (this.indexMode == DBBroker.IndexMode.STORE && this.node.getNodeType() == 1 && this.level <= NativeBroker.this.defaultIndexDepth) {
                new DOMTransaction(NativeBroker.this, NativeBroker.this.domDb, Lock.LockMode.WRITE_LOCK){

                    @Override
                    public Object start() throws ReadOnlyException {
                        try {
                            NativeBroker.this.domDb.addValue(NodeProcessor.this.transaction, new NodeRef(doc.getDocId(), NodeProcessor.this.node.getNodeId()), NodeProcessor.this.address);
                        }
                        catch (IOException | BTreeException e) {
                            DBBroker.LOG.warn(NativeBroker.EXCEPTION_DURING_REINDEX, (Throwable)e);
                        }
                        return null;
                    }
                }.run();
            }
        }

        private void checkAvailableMemory() {
            if (this.indexMode != DBBroker.IndexMode.REMOVE && NativeBroker.this.nodesCount > 500) {
                if (NativeBroker.this.run.totalMemory() >= NativeBroker.this.run.maxMemory() && NativeBroker.this.run.freeMemory() < NativeBroker.this.pool.getReservedMem()) {
                    NativeBroker.this.flush();
                }
                NativeBroker.this.nodesCount = 0;
            }
        }

        public void index() {
            ++NativeBroker.this.nodesCount;
            this.checkAvailableMemory();
            this.doIndex();
            this.store();
        }
    }

    private static final class RemovedNode {
        final IStoredNode node;
        final String content;
        final NodePath path;

        RemovedNode(IStoredNode node, NodePath path, String content) {
            this.node = node;
            this.path = path;
            this.content = content;
        }
    }

    public static final class NodeRef
    extends Value {
        public static final int OFFSET_DOCUMENT_ID = 0;
        public static final int OFFSET_NODE_ID = 4;

        public NodeRef(int docId) {
            this.len = 4;
            this.data = new byte[this.len];
            ByteConversion.intToByte(docId, this.data, 0);
            this.pos = 0;
        }

        public NodeRef(int docId, NodeId nodeId) {
            this.len = 4 + nodeId.size();
            this.data = new byte[this.len];
            ByteConversion.intToByte(docId, this.data, 0);
            nodeId.serialize(this.data, 4);
            this.pos = 0;
        }

        int getDocId() {
            return ByteConversion.byteToInt(this.data, 0);
        }
    }
}

