/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import com.evolvedbinary.j8fu.function.FunctionE;
import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.jcip.annotations.GuardedBy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.TypedQNameComparator;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.SymbolTable;
import org.exist.dom.persistent.TextImpl;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.IndexUtils;
import org.exist.indexing.IndexWorker;
import org.exist.numbering.NodeId;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.DBBroker;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.Indexable;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.RegexMatcher;
import org.exist.storage.TermMatcher;
import org.exist.storage.ValueIndexFactory;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.index.BFile;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteConversion;
import org.exist.util.Collations;
import org.exist.util.Configuration;
import org.exist.util.FastQSort;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;
import org.exist.util.UTF8;
import org.exist.util.ValueOccurrences;
import org.exist.util.XMLString;
import org.exist.xquery.Constants;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class NativeValueIndex
implements ContentLoadingObserver {
    private static final Logger LOG = LogManager.getLogger(NativeValueIndex.class);
    public static final String FILE_NAME = "values.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.values";
    private static final double DEFAULT_VALUE_CACHE_GROWTH = 1.25;
    private static final double DEFAULT_VALUE_VALUE_THRESHOLD = 0.04;
    private static final int LENGTH_VALUE_TYPE = 1;
    private static final int LENGTH_NODE_IDS = 4;
    public static final int OFFSET_COLLECTION_ID = 0;
    public static final int OFFSET_VALUE_TYPE = 4;
    public static final int OFFSET_DATA = 5;
    public static final String INDEX_CASE_SENSITIVE_ATTRIBUTE = "caseSensitive";
    public static final String PROPERTY_INDEX_CASE_SENSITIVE = "indexer.case-sensitive";
    private final DBBroker broker;
    @GuardedBy(value="dbValues#getLock()")
    final BFile dbValues;
    private final Configuration config;
    private final PendingChanges<AtomicValue> pendingGeneric = new PendingChanges(IndexType.GENERIC);
    private final PendingChanges<QNameKey> pendingQName = new PendingChanges(IndexType.QNAME);
    private DocumentImpl doc;
    private VariableByteOutputStream os = new VariableByteOutputStream();
    private final boolean caseSensitive;

    public NativeValueIndex(DBBroker broker, byte id, Path dataDir, Configuration config) throws DBException {
        this.broker = broker;
        this.config = config;
        double cacheGrowth = 1.25;
        double cacheValueThresHold = 0.04;
        BFile nativeFile = (BFile)config.getProperty(this.getConfigKeyForFile());
        if (nativeFile == null) {
            Path file = dataDir.resolve(this.getFileName());
            LOG.debug("Creating '" + FileUtils.fileName(file) + "'...");
            nativeFile = new BFile(broker.getBrokerPool(), id, false, file, broker.getBrokerPool().getCacheManager(), 1.25, 0.04);
            config.setProperty(this.getConfigKeyForFile(), nativeFile);
        }
        this.dbValues = nativeFile;
        this.caseSensitive = Optional.ofNullable((Boolean)config.getProperty(PROPERTY_INDEX_CASE_SENSITIVE)).orElse(false);
        broker.addContentLoadingObserver(this.getInstance());
    }

    private String getFileName() {
        return FILE_NAME;
    }

    private String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    private NativeValueIndex getInstance() {
        return this;
    }

    @Override
    public void setDocument(DocumentImpl document) {
        boolean documentChanged;
        boolean bl = documentChanged = this.doc == null && document != null || this.doc.getDocId() != document.getDocId();
        if (!(this.pendingGeneric.changes.isEmpty() && this.pendingQName.changes.isEmpty() || !documentChanged)) {
            LOG.error("Document changed, but there were {} Generic and {} QName changes pending. These have been dropped!", (Object)this.pendingGeneric.changes.size(), (Object)this.pendingQName.changes.size());
            this.pendingGeneric.changes.clear();
            this.pendingQName.changes.clear();
        }
        this.doc = document;
    }

    public void storeElement(ElementImpl node, String content, int xpathType, IndexType indexType, boolean remove) {
        if (this.doc.getDocId() != node.getOwnerDocument().getDocId()) {
            throw new IllegalArgumentException("Document id ('" + this.doc.getDocId() + "') and proxy id ('" + node.getOwnerDocument().getDocId() + "') differ !");
        }
        AtomicValue atomic = this.convertToAtomic(xpathType, content);
        if (atomic == null) {
            return;
        }
        switch (indexType) {
            case GENERIC: {
                this.store(this.pendingGeneric, atomic, node.getNodeId(), remove);
                break;
            }
            case QNAME: {
                this.store(this.pendingQName, new QNameKey(node.getQName(), atomic), node.getNodeId(), remove);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private <T> void store(PendingChanges<T> pending, T key, NodeId value, boolean remove) {
        if (!remove) {
            List<Object> buf;
            if (pending.changes.containsKey(key)) {
                buf = pending.changes.get(key);
            } else {
                buf = new ArrayList(8);
                pending.changes.put(key, buf);
            }
            buf.add(value);
        } else if (!pending.changes.containsKey(key)) {
            pending.changes.put(key, null);
        }
    }

    @Override
    public void storeAttribute(AttrImpl attr, NodePath currentPath, RangeIndexSpec spec, boolean remove) {
        this.storeAttribute(attr, attr.getValue(), spec.getType(), spec.getQName() == null ? IndexType.GENERIC : IndexType.QNAME, remove);
    }

    public void storeAttribute(AttrImpl attr, String value, int xpathType, IndexType indexType, boolean remove) {
        if (this.doc != null && this.doc.getDocId() != attr.getOwnerDocument().getDocId()) {
            throw new IllegalArgumentException("Document id ('" + this.doc.getDocId() + "') and proxy id ('" + attr.getOwnerDocument().getDocId() + "') differ !");
        }
        AtomicValue atomic = this.convertToAtomic(xpathType, value);
        if (atomic == null) {
            return;
        }
        switch (indexType) {
            case GENERIC: {
                this.store(this.pendingGeneric, atomic, attr.getNodeId(), remove);
                break;
            }
            case QNAME: {
                this.store(this.pendingQName, new QNameKey(attr.getQName(), atomic), attr.getNodeId(), remove);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public <T extends IStoredNode> IStoredNode getReindexRoot(IStoredNode<T> node, NodePath nodePath) {
        IStoredNode currentNode;
        this.doc = (DocumentImpl)node.getOwnerDocument();
        NodePath path = new NodePath(nodePath);
        IStoredNode root = null;
        IStoredNode iStoredNode = currentNode = node.getNodeType() == 1 || node.getNodeType() == 2 ? node : node.getParentStoredNode();
        while (currentNode != null) {
            GeneralRangeIndexSpec rSpec = this.doc.getCollection().getIndexByPathConfiguration(this.broker, path);
            QNameRangeIndexSpec qSpec = this.doc.getCollection().getIndexByQNameConfiguration(this.broker, currentNode.getQName());
            if (rSpec != null || qSpec != null) {
                root = currentNode;
            }
            if (this.doc.getCollection().isTempCollection() && currentNode.getNodeId().getTreeLevel() == 2) break;
            currentNode = currentNode.getParentStoredNode();
            path.removeLastComponent();
        }
        return root;
    }

    public void reindex(IStoredNode node) {
        if (node == null) {
            return;
        }
        ValueIndexStreamListener listener = new ValueIndexStreamListener();
        IndexUtils.scanNode(this.broker, null, node, listener);
    }

    @Override
    public void storeText(TextImpl node, NodePath currentPath) {
    }

    @Override
    public void removeNode(NodeHandle node, NodePath currentPath, String content) {
    }

    @Override
    public void sync() {
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.dbValues.flush();
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
        }
        catch (DBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void flush() {
        if (this.doc == null || this.pendingGeneric.changes.isEmpty() && this.pendingQName.changes.isEmpty()) {
            return;
        }
        int collectionId = this.doc.getCollection().getId();
        this.flush(this.pendingGeneric, key -> new SimpleValue(collectionId, (Indexable)key));
        this.flush(this.pendingQName, key -> new QNameValue(collectionId, ((QNameKey)key).qname, ((QNameKey)key).value, this.broker.getBrokerPool().getSymbols()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void flush(PendingChanges<T> pending, FunctionE<T, Value, EXistException> dbKeyFn) {
        for (Map.Entry entry : pending.changes.entrySet()) {
            Object key = entry.getKey();
            List<NodeId> gids = entry.getValue();
            int gidsCount = gids.size();
            FastQSort.sort(gids, 0, gidsCount - 1);
            this.os.clear();
            this.os.writeInt(this.doc.getDocId());
            this.os.writeInt(gidsCount);
            int nodeIDsLength = this.os.position();
            this.os.writeFixedInt(0);
            NodeId previous = null;
            for (NodeId nodeId : gids) {
                try {
                    previous = nodeId.write(previous, this.os);
                }
                catch (IOException e) {
                    LOG.warn("IO error while writing range index: " + e.getMessage(), (Throwable)e);
                }
            }
            this.os.writeFixedInt(nodeIDsLength, this.os.position() - nodeIDsLength - 4);
            Lock lock = this.dbValues.getLock();
            try {
                lock.acquire(Lock.LockMode.WRITE_LOCK);
                Value v = (Value)dbKeyFn.apply(key);
                if (this.dbValues.append(v, this.os.data()) != -1L) continue;
                LOG.warn("Could not append index data for key '" + key + "'");
            }
            catch (IOException | EXistException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
            }
            catch (ReadOnlyException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                lock.release(Lock.LockMode.WRITE_LOCK);
                this.os.clear();
            }
        }
        pending.changes.clear();
    }

    @Override
    public void remove() {
        if (this.doc == null || this.pendingGeneric.changes.isEmpty() && this.pendingQName.changes.isEmpty()) {
            return;
        }
        int collectionId = this.doc.getCollection().getId();
        this.remove(this.pendingGeneric, key -> new SimpleValue(collectionId, (Indexable)key));
        this.remove(this.pendingQName, key -> new QNameValue(collectionId, ((QNameKey)key).qname, ((QNameKey)key).value, this.broker.getBrokerPool().getSymbols()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void remove(PendingChanges<T> pending, FunctionE<T, Value, EXistException> dbKeyFn) {
        for (Map.Entry entry : pending.changes.entrySet()) {
            Object key = entry.getKey();
            List<NodeId> storedGIDList = entry.getValue();
            ArrayList<NodeId> newGIDList = new ArrayList<NodeId>();
            this.os.clear();
            Lock lock = this.dbValues.getLock();
            try {
                lock.acquire(Lock.LockMode.WRITE_LOCK);
                Value searchKey = (Value)dbKeyFn.apply(key);
                Value value = this.dbValues.get(searchKey);
                if (value != null) {
                    VariableByteArrayInput is = new VariableByteArrayInput(value.getData());
                    while (is.available() > 0) {
                        int storedDocId = is.readInt();
                        int gidsCount = is.readInt();
                        int size = is.readFixedInt();
                        if (storedDocId != this.doc.getDocId()) {
                            this.os.writeInt(storedDocId);
                            this.os.writeInt(gidsCount);
                            this.os.writeFixedInt(size);
                            is.copyRaw(this.os, size);
                            continue;
                        }
                        NodeId previous = null;
                        for (int j = 0; j < gidsCount; ++j) {
                            NodeId nodeId;
                            previous = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                            if (NativeValueIndex.containsNode(storedGIDList, nodeId)) continue;
                            newGIDList.add(nodeId);
                        }
                    }
                    if (newGIDList.size() > 0) {
                        int gidsCount = newGIDList.size();
                        FastQSort.sort(newGIDList, 0, gidsCount - 1);
                        this.os.writeInt(this.doc.getDocId());
                        this.os.writeInt(gidsCount);
                        int nodeIDsLength = this.os.position();
                        this.os.writeFixedInt(0);
                        NodeId previous = null;
                        for (NodeId nodeId : newGIDList) {
                            try {
                                previous = nodeId.write(previous, this.os);
                            }
                            catch (IOException e) {
                                LOG.warn("IO error while writing range index: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        this.os.writeFixedInt(nodeIDsLength, this.os.position() - nodeIDsLength - 4);
                    }
                    if (this.dbValues.update(value.getAddress(), searchKey, this.os.data()) != -1L) continue;
                    LOG.error("Could not update index data for value '" + searchKey + "'");
                    continue;
                }
                if (this.dbValues.put(searchKey, this.os.data()) != -1L) continue;
                LOG.error("Could not put index data for value '" + searchKey + "'");
            }
            catch (IOException | EXistException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
            }
            finally {
                lock.release(Lock.LockMode.WRITE_LOCK);
                this.os.clear();
            }
        }
        pending.changes.clear();
    }

    private static boolean containsNode(List<NodeId> list, NodeId nodeId) {
        return list.stream().filter(nodeId::equals).findFirst().isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIndex(Collection collection) {
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.flush();
            Value ref = new SimpleValue(collection.getId());
            this.dbValues.removeAll(null, new IndexQuery(7, ref));
            ref = new QNameValue(collection.getId());
            this.dbValues.removeAll(null, new IndexQuery(7, ref));
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
        }
        catch (IOException | BTreeException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIndex(DocumentImpl document) {
        int collectionId = document.getCollection().getId();
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.dropIndex(document.getDocId(), this.pendingGeneric, key -> new SimpleValue(collectionId, (Indexable)key));
            this.dropIndex(document.getDocId(), this.pendingQName, key -> new QNameValue(collectionId, ((QNameKey)key).qname, ((QNameKey)key).value, this.broker.getBrokerPool().getSymbols()));
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            LOG.warn("Exception while removing range index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.os.clear();
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    private <T> void dropIndex(int docId, PendingChanges<T> pending, FunctionE<T, Value, EXistException> dbKeyFn) throws EXistException, IOException {
        for (Map.Entry entry : pending.changes.entrySet()) {
            Object key = entry.getKey();
            Value v = (Value)dbKeyFn.apply(key);
            Value value = this.dbValues.get(v);
            if (value == null) continue;
            VariableByteArrayInput is = new VariableByteArrayInput(value.getData());
            boolean changed = false;
            this.os.clear();
            while (is.available() > 0) {
                int storedDocId = is.readInt();
                int gidsCount = is.readInt();
                int size = is.readFixedInt();
                if (storedDocId != docId) {
                    this.os.writeInt(storedDocId);
                    this.os.writeInt(gidsCount);
                    this.os.writeFixedInt(size);
                    is.copyRaw(this.os, size);
                    continue;
                }
                is.skipBytes(size);
                changed = true;
            }
            if (!changed) continue;
            if (this.os.data().size() == 0) {
                this.dbValues.remove(v);
                continue;
            }
            if (this.dbValues.put(v, this.os.data()) != -1L) continue;
            LOG.error("Could not put index data for key '" + v + "'");
        }
        pending.changes.clear();
    }

    public NodeSet find(XQueryWatchDog watchDog, Constants.Comparison comparison, DocumentSet docs, NodeSet contextSet, int axis, QName qname, Indexable value) throws TerminatedException {
        return this.find(watchDog, comparison, docs, contextSet, axis, qname, value, false);
    }

    public NodeSet find(XQueryWatchDog watchDog, Constants.Comparison comparison, DocumentSet docs, NodeSet contextSet, int axis, QName qname, Indexable value, boolean mixedIndex) throws TerminatedException {
        NewArrayNodeSet result = new NewArrayNodeSet();
        if (qname == null) {
            this.findAll(watchDog, comparison, docs, contextSet, axis, null, value, result);
        } else {
            LinkedList<QName> qnames = new LinkedList<QName>();
            qnames.add(qname);
            this.findAll(watchDog, comparison, docs, contextSet, axis, qnames, value, result);
            if (mixedIndex) {
                this.findAll(watchDog, comparison, docs, contextSet, axis, null, value, result);
            }
        }
        return result;
    }

    public NodeSet findAll(XQueryWatchDog watchDog, Constants.Comparison comparison, DocumentSet docs, NodeSet contextSet, int axis, Indexable value) throws TerminatedException {
        NewArrayNodeSet result = new NewArrayNodeSet();
        this.findAll(watchDog, comparison, docs, contextSet, axis, this.getDefinedIndexes(docs), value, result);
        this.findAll(watchDog, comparison, docs, contextSet, axis, null, value, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeSet findAll(XQueryWatchDog watchDog, Constants.Comparison comparison, DocumentSet docs, NodeSet contextSet, int axis, List<QName> qnames, Indexable value, NodeSet result) throws TerminatedException {
        SearchCallback cb = new SearchCallback(docs, contextSet, result, axis == 0);
        Lock lock = this.dbValues.getLock();
        int idxOp = this.toIndexQueryOp(comparison);
        Iterator<Collection> iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            int collectionId = iter.next().getId();
            watchDog.proceed(null);
            if (qnames == null) {
                try {
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    SimpleValue searchKey = new SimpleValue(collectionId, value);
                    IndexQuery query = new IndexQuery(idxOp, (Value)searchKey);
                    if (idxOp == 1) {
                        this.dbValues.query(query, cb);
                        continue;
                    }
                    SimplePrefixValue prefixKey = new SimplePrefixValue(collectionId, value.getType());
                    this.dbValues.query(query, prefixKey, cb);
                    continue;
                }
                catch (IOException | EXistException | BTreeException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
                    continue;
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                    continue;
                }
            }
            for (QName qname : qnames) {
                try {
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    QNameValue searchKey = new QNameValue(collectionId, qname, value, this.broker.getBrokerPool().getSymbols());
                    IndexQuery query = new IndexQuery(idxOp, (Value)searchKey);
                    if (idxOp == 1) {
                        this.dbValues.query(query, cb);
                        continue;
                    }
                    QNamePrefixValue prefixKey = new QNamePrefixValue(collectionId, qname, value.getType(), this.broker.getBrokerPool().getSymbols());
                    this.dbValues.query(query, prefixKey, cb);
                }
                catch (IOException | EXistException | BTreeException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        return result;
    }

    public NodeSet match(XQueryWatchDog watchDog, DocumentSet docs, NodeSet contextSet, int axis, String expr, QName qname, int type) throws TerminatedException, EXistException {
        return this.match(watchDog, docs, contextSet, axis, expr, qname, type, null, Constants.StringTruncationOperator.RIGHT);
    }

    public NodeSet match(XQueryWatchDog watchDog, DocumentSet docs, NodeSet contextSet, int axis, String expr, QName qname, int type, Collator collator, Constants.StringTruncationOperator truncation) throws TerminatedException, EXistException {
        return this.match(watchDog, docs, contextSet, axis, expr, qname, type, 0, true, collator, truncation);
    }

    public NodeSet match(XQueryWatchDog watchDog, DocumentSet docs, NodeSet contextSet, int axis, String expr, QName qname, int type, int flags, boolean caseSensitiveQuery) throws TerminatedException, EXistException {
        return this.match(watchDog, docs, contextSet, axis, expr, qname, type, flags, caseSensitiveQuery, null, Constants.StringTruncationOperator.RIGHT);
    }

    public NodeSet match(XQueryWatchDog watchDog, DocumentSet docs, NodeSet contextSet, int axis, String expr, QName qname, int type, int flags, boolean caseSensitiveQuery, Collator collator, Constants.StringTruncationOperator truncation) throws TerminatedException, EXistException {
        NewArrayNodeSet result = new NewArrayNodeSet();
        if (qname == null) {
            this.matchAll(watchDog, docs, contextSet, axis, expr, null, type, flags, caseSensitiveQuery, result, collator, truncation);
        } else {
            LinkedList<QName> qnames = new LinkedList<QName>();
            qnames.add(qname);
            this.matchAll(watchDog, docs, contextSet, axis, expr, qnames, type, flags, caseSensitiveQuery, result, collator, truncation);
        }
        return result;
    }

    public NodeSet matchAll(XQueryWatchDog watchDog, DocumentSet docs, NodeSet contextSet, int axis, String expr, int type, int flags, boolean caseSensitiveQuery) throws TerminatedException, EXistException {
        return this.matchAll(watchDog, docs, contextSet, axis, expr, type, flags, caseSensitiveQuery, null, Constants.StringTruncationOperator.RIGHT);
    }

    public NodeSet matchAll(XQueryWatchDog watchDog, DocumentSet docs, NodeSet contextSet, int axis, String expr, int type, int flags, boolean caseSensitiveQuery, Collator collator, Constants.StringTruncationOperator truncation) throws TerminatedException, EXistException {
        NewArrayNodeSet result = new NewArrayNodeSet();
        this.matchAll(watchDog, docs, contextSet, axis, expr, this.getDefinedIndexes(docs), type, flags, caseSensitiveQuery, result, collator, truncation);
        this.matchAll(watchDog, docs, contextSet, axis, expr, null, type, flags, caseSensitiveQuery, result, collator, truncation);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet matchAll(XQueryWatchDog watchDog, DocumentSet docs, NodeSet contextSet, int axis, String expr, List<QName> qnames, int type, int flags, boolean caseSensitiveQuery, NodeSet result, Collator collator, Constants.StringTruncationOperator truncation) throws TerminatedException, EXistException {
        TermMatcher matcher;
        StringValue startTerm;
        if (type == 1 && expr.startsWith("^") && caseSensitiveQuery == this.caseSensitive) {
            StringBuilder term = new StringBuilder();
            for (int j = 1; j < expr.length() && Character.isLetterOrDigit(expr.charAt(j)); ++j) {
                term.append(expr.charAt(j));
            }
            if (term.length() > 0) {
                startTerm = new StringValue(term.toString());
                LOG.debug("Match will begin index scan at '" + startTerm + "'");
            } else {
                startTerm = null;
            }
        } else if (collator == null && (type == 0 || type == 4)) {
            startTerm = new StringValue(expr);
            LOG.debug("Match will begin index scan at '" + startTerm + "'");
        } else {
            startTerm = null;
        }
        if (collator == null) {
            switch (type) {
                case 0: {
                    matcher = new ExactMatcher(expr);
                    break;
                }
                case 3: {
                    matcher = new ContainsMatcher(expr);
                    break;
                }
                case 4: {
                    matcher = new StartsWithMatcher(expr);
                    break;
                }
                case 5: {
                    matcher = new EndsWithMatcher(expr);
                    break;
                }
                default: {
                    matcher = new RegexMatcher(expr, type, flags);
                    break;
                }
            }
        } else {
            matcher = new CollatorMatcher(expr, truncation, collator);
        }
        MatcherCallback cb = new MatcherCallback(docs, contextSet, result, matcher, axis == 0);
        Lock lock = this.dbValues.getLock();
        Iterator<Collection> iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            int collectionId = iter.next().getId();
            watchDog.proceed(null);
            if (qnames == null) {
                try {
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    Value searchKey = startTerm != null ? new SimpleValue(collectionId, startTerm) : new SimplePrefixValue(collectionId, 22);
                    IndexQuery query = new IndexQuery(7, searchKey);
                    this.dbValues.query(query, cb);
                    continue;
                }
                catch (IOException | BTreeException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
                    continue;
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                    continue;
                }
            }
            for (QName qname : qnames) {
                try {
                    Value searchKey;
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    if (startTerm != null) {
                        searchKey = new QNameValue(collectionId, qname, startTerm, this.broker.getBrokerPool().getSymbols());
                    } else {
                        LOG.debug("Searching with QName prefix");
                        searchKey = new QNamePrefixValue(collectionId, qname, 22, this.broker.getBrokerPool().getSymbols());
                    }
                    IndexQuery query = new IndexQuery(7, searchKey);
                    this.dbValues.query(query, cb);
                }
                catch (IOException | BTreeException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueOccurrences[] scanIndexKeys(DocumentSet docs, NodeSet contextSet, Indexable start) {
        int type = start.getType();
        boolean stringType = Type.subTypeOf(type, 22);
        IndexScanCallback cb = new IndexScanCallback(docs, contextSet, type, false);
        Lock lock = this.dbValues.getLock();
        Iterator<Collection> i = docs.getCollectionIterator();
        while (i.hasNext()) {
            try {
                lock.acquire(Lock.LockMode.READ_LOCK);
                Collection c = i.next();
                int collectionId = c.getId();
                SimpleValue startKey = new SimpleValue(collectionId, start);
                if (stringType) {
                    IndexQuery query = new IndexQuery(7, (Value)startKey);
                    this.dbValues.query(query, cb);
                    continue;
                }
                SimplePrefixValue prefixKey = new SimplePrefixValue(collectionId, start.getType());
                IndexQuery query = new IndexQuery(-3, (Value)startKey);
                this.dbValues.query(query, prefixKey, cb);
            }
            catch (IOException | EXistException | BTreeException | TerminatedException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
            }
            finally {
                lock.release(Lock.LockMode.READ_LOCK);
            }
        }
        Map map = cb.map;
        ValueOccurrences[] result = new ValueOccurrences[map.size()];
        return map.values().toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueOccurrences[] scanIndexKeys(DocumentSet docs, NodeSet contextSet, QName[] qnames, Indexable start) {
        if (qnames == null) {
            List<QName> qnlist = this.getDefinedIndexes(docs);
            qnames = new QName[qnlist.size()];
            qnames = qnlist.toArray(qnames);
        }
        int type = start.getType();
        boolean stringType = Type.subTypeOf(type, 22);
        IndexScanCallback cb = new IndexScanCallback(docs, contextSet, type, true);
        Lock lock = this.dbValues.getLock();
        for (QName qname : qnames) {
            Iterator<Collection> i = docs.getCollectionIterator();
            while (i.hasNext()) {
                try {
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    int collectionId = i.next().getId();
                    QNameValue startKey = new QNameValue(collectionId, qname, start, this.broker.getBrokerPool().getSymbols());
                    if (stringType) {
                        IndexQuery query = new IndexQuery(7, (Value)startKey);
                        this.dbValues.query(query, cb);
                        continue;
                    }
                    QNamePrefixValue prefixKey = new QNamePrefixValue(collectionId, qname, start.getType(), this.broker.getBrokerPool().getSymbols());
                    IndexQuery query = new IndexQuery(-3, (Value)startKey);
                    this.dbValues.query(query, prefixKey, cb);
                }
                catch (IOException | EXistException | BTreeException | TerminatedException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        Map map = cb.map;
        ValueOccurrences[] result = new ValueOccurrences[map.size()];
        return map.values().toArray(result);
    }

    private List<QName> getDefinedIndexes(DocumentSet docs) {
        ArrayList<QName> qnames = new ArrayList<QName>();
        Iterator<Collection> i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(this.broker);
            if (idxConf == null) continue;
            qnames.addAll(idxConf.getIndexedQNames());
        }
        return qnames;
    }

    private int toIndexQueryOp(Constants.Comparison comparison) {
        int indexOp;
        switch (comparison) {
            case LT: {
                indexOp = 3;
                break;
            }
            case LTEQ: {
                indexOp = -2;
                break;
            }
            case GT: {
                indexOp = 2;
                break;
            }
            case GTEQ: {
                indexOp = -3;
                break;
            }
            case NEQ: {
                indexOp = -1;
                break;
            }
            default: {
                indexOp = 1;
            }
        }
        return indexOp;
    }

    private AtomicValue convertToAtomic(int xpathType, String value) {
        AtomicValue atomic;
        if (Type.subTypeOf(xpathType, 22)) {
            try {
                atomic = new StringValue(value, xpathType, false);
            }
            catch (XPathException e) {
                LOG.error((Object)e);
                return null;
            }
        }
        try {
            atomic = new StringValue(value).convertTo(xpathType);
        }
        catch (XPathException e) {
            LOG.error("Node value '" + value + "' cannot be converted to " + Type.getTypeName(xpathType));
            return null;
        }
        return atomic;
    }

    @Override
    public void closeAndRemove() {
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.config.setProperty(this.getConfigKeyForFile(), null);
            this.dbValues.closeAndRemove();
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void close() throws DBException {
        Lock lock = this.dbValues.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.config.setProperty(this.getConfigKeyForFile(), null);
            this.dbValues.close();
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.dbValues.getFile()) + "'", (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void printStatistics() {
        this.dbValues.printStatistics();
    }

    public String toString() {
        return this.getClass().getName() + " at " + FileUtils.fileName(this.dbValues.getFile()) + " owned by " + this.broker.toString() + " (case sensitive = " + this.caseSensitive + ")";
    }

    private class ValueIndexStreamListener
    extends AbstractStreamListener {
        private Deque<XMLString> contentStack = null;

        ValueIndexStreamListener() {
        }

        @Override
        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            GeneralRangeIndexSpec rSpec = NativeValueIndex.this.doc.getCollection().getIndexByPathConfiguration(NativeValueIndex.this.broker, path);
            QNameRangeIndexSpec qSpec = NativeValueIndex.this.doc.getCollection().getIndexByQNameConfiguration(NativeValueIndex.this.broker, element.getQName());
            if (rSpec != null || qSpec != null) {
                if (this.contentStack == null) {
                    this.contentStack = new ArrayDeque<XMLString>();
                }
                XMLString contentBuf = new XMLString();
                this.contentStack.push(contentBuf);
            }
            super.startElement(transaction, element, path);
        }

        @Override
        public void attribute(Txn transaction, AttrImpl attrib, NodePath path) {
            GeneralRangeIndexSpec rSpec = NativeValueIndex.this.doc.getCollection().getIndexByPathConfiguration(NativeValueIndex.this.broker, path);
            QNameRangeIndexSpec qSpec = NativeValueIndex.this.doc.getCollection().getIndexByQNameConfiguration(NativeValueIndex.this.broker, attrib.getQName());
            if (rSpec != null) {
                NativeValueIndex.this.storeAttribute(attrib, path, rSpec, false);
            }
            if (qSpec != null) {
                NativeValueIndex.this.storeAttribute(attrib, path, qSpec, false);
            }
            switch (attrib.getType()) {
                case 1: {
                    NativeValueIndex.this.storeAttribute(attrib, attrib.getValue(), 66, IndexType.GENERIC, false);
                    break;
                }
                case 2: {
                    NativeValueIndex.this.storeAttribute(attrib, attrib.getValue(), 67, IndexType.GENERIC, false);
                    break;
                }
                case 3: {
                    StringTokenizer tokenizer = new StringTokenizer(attrib.getValue(), " ");
                    while (tokenizer.hasMoreTokens()) {
                        NativeValueIndex.this.storeAttribute(attrib, tokenizer.nextToken(), 67, IndexType.GENERIC, false);
                    }
                    break;
                }
            }
            super.attribute(transaction, attrib, path);
        }

        @Override
        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            GeneralRangeIndexSpec rSpec = NativeValueIndex.this.doc.getCollection().getIndexByPathConfiguration(NativeValueIndex.this.broker, path);
            QNameRangeIndexSpec qSpec = NativeValueIndex.this.doc.getCollection().getIndexByQNameConfiguration(NativeValueIndex.this.broker, element.getQName());
            if (rSpec != null || qSpec != null) {
                XMLString content = this.contentStack.pop();
                if (rSpec != null) {
                    NativeValueIndex.this.storeElement(element, content.toString(), RangeIndexSpec.indexTypeToXPath(rSpec.getIndexType()), IndexType.GENERIC, false);
                }
                if (qSpec != null) {
                    NativeValueIndex.this.storeElement(element, content.toString(), RangeIndexSpec.indexTypeToXPath(qSpec.getIndexType()), IndexType.QNAME, false);
                }
            }
            super.endElement(transaction, element, path);
        }

        @Override
        public void characters(Txn transaction, AbstractCharacterData text, NodePath path) {
            XMLString xmlString = text.getXMLString();
            if (this.contentStack != null) {
                this.contentStack.forEach(next -> next.append(xmlString));
            }
            super.characters(transaction, text, path);
        }

        @Override
        public IndexWorker getWorker() {
            return null;
        }
    }

    private static class QNamePrefixValue
    extends Value {
        static final int LENGTH_VALUE_TYPE = 1;

        QNamePrefixValue(int collectionId, QName qname, int type, SymbolTable symbols) {
            this.len = 11;
            this.data = new byte[this.len];
            this.data[0] = IndexType.QNAME.val;
            ByteConversion.intToByte(collectionId, this.data, 1);
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalPart());
            this.data[5] = qname.getNameType();
            ByteConversion.shortToByte(namespaceId, this.data, 6);
            ByteConversion.shortToByte(localNameId, this.data, 8);
            this.data[10] = (byte)type;
            this.pos = 0;
        }
    }

    private static class QNameValue
    extends Value {
        static final int LENGTH_IDX_TYPE = 1;
        static final int LENGTH_QNAME_TYPE = 1;
        static final int OFFSET_IDX_TYPE = 0;
        static final int OFFSET_COLLECTION_ID = 1;
        static final int OFFSET_QNAME_TYPE = 5;
        static final int OFFSET_NS_URI = 6;
        static final int OFFSET_LOCAL_NAME = 8;
        static final int OFFSET_VALUE = 10;

        public QNameValue(int collectionId) {
            this.len = 5;
            this.data = new byte[this.len];
            this.data[0] = IndexType.QNAME.val;
            ByteConversion.intToByte(collectionId, this.data, 1);
            this.pos = 0;
        }

        public QNameValue(int collectionId, QName qname, Indexable atomic, SymbolTable symbols) throws EXistException {
            this.data = atomic.serializeValue(10);
            this.len = this.data.length;
            this.pos = 0;
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalPart());
            this.data[0] = IndexType.QNAME.val;
            ByteConversion.intToByte(collectionId, this.data, 1);
            this.data[5] = qname.getNameType();
            ByteConversion.shortToByte(namespaceId, this.data, 6);
            ByteConversion.shortToByte(localNameId, this.data, 8);
        }

        public static Indexable deserialize(byte[] data, int start, int len) throws EXistException {
            return ValueIndexFactory.deserialize(data, start + 10, len - 10);
        }

        public static byte getType(byte[] data, int start) {
            return data[start + 5];
        }
    }

    private static class SimplePrefixValue
    extends Value {
        static final int LENGTH_VALUE_TYPE = 1;

        SimplePrefixValue(int collectionId, int type) {
            this.len = 6;
            this.data = new byte[this.len];
            this.data[0] = IndexType.GENERIC.val;
            ByteConversion.intToByte(collectionId, this.data, 1);
            this.data[5] = (byte)type;
            this.pos = 0;
        }
    }

    private static final class SimpleValue
    extends Value {
        static final int OFFSET_IDX_TYPE = 0;
        static final int LENGTH_IDX_TYPE = 1;
        static final int OFFSET_COLLECTION_ID = 1;
        static final int OFFSET_VALUE = 5;

        SimpleValue(int collectionId) {
            this.len = 5;
            this.data = new byte[this.len];
            this.data[0] = IndexType.GENERIC.val;
            ByteConversion.intToByte(collectionId, this.data, 1);
            this.pos = 0;
        }

        SimpleValue(int collectionId, Indexable atomic) throws EXistException {
            this.data = atomic.serializeValue(5);
            this.len = this.data.length;
            this.pos = 0;
            this.data[0] = IndexType.GENERIC.val;
            ByteConversion.intToByte(collectionId, this.data, 1);
        }

        public static Indexable deserialize(byte[] data, int start, int len) throws EXistException {
            return ValueIndexFactory.deserialize(data, start + 5, len - 5);
        }
    }

    private static class QNameKey
    implements Comparable<QNameKey> {
        private static final TypedQNameComparator comparator = new TypedQNameComparator();
        private final QName qname;
        private final AtomicValue value;

        public QNameKey(QName qname, AtomicValue atomic) {
            this.qname = qname;
            this.value = atomic;
        }

        @Override
        public int compareTo(QNameKey other) {
            int cmp = comparator.compare(this.qname, other.qname);
            if (cmp == 0) {
                return this.value.compareTo(other.value);
            }
            return cmp;
        }
    }

    private final class IndexScanCallback
    implements BTreeCallback {
        private final DocumentSet docs;
        private final NodeSet contextSet;
        private final int type;
        private final boolean byQName;
        private final Map<AtomicValue, ValueOccurrences> map = new TreeMap<AtomicValue, ValueOccurrences>();

        IndexScanCallback(DocumentSet docs, NodeSet contextSet, int type, boolean byQName) {
            this.docs = docs;
            this.contextSet = contextSet;
            this.type = type;
            this.byQName = byQName;
        }

        @Override
        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            VariableByteInput is;
            AtomicValue atomic;
            try {
                atomic = this.byQName ? (AtomicValue)QNameValue.deserialize(key.data(), key.start(), key.getLength()) : (AtomicValue)SimpleValue.deserialize(key.data(), key.start(), key.getLength());
                if (atomic.getType() != this.type) {
                    return false;
                }
            }
            catch (EXistException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                is = NativeValueIndex.this.dbValues.getAsStream(pointer);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return true;
            }
            ValueOccurrences oc = this.map.get(atomic);
            try {
                while (is.available() > 0) {
                    boolean docAdded = false;
                    int storedDocId = is.readInt();
                    int gidsCount = is.readInt();
                    int size = is.readFixedInt();
                    DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes(size);
                        continue;
                    }
                    NodeId lastParentId = null;
                    NodeId previous = null;
                    for (int j = 0; j < gidsCount; ++j) {
                        NodeId nodeId;
                        previous = nodeId = NativeValueIndex.this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        NodeProxy parentNode = this.contextSet != null ? this.contextSet.get(storedDocument, nodeId) : new NodeProxy(storedDocument, nodeId);
                        if (parentNode == null) continue;
                        if (oc == null) {
                            oc = new ValueOccurrences(atomic);
                            this.map.put(atomic, oc);
                        }
                        if (lastParentId == null || !lastParentId.equals(parentNode.getNodeId())) {
                            oc.addOccurrences(1);
                        }
                        if (!docAdded) {
                            oc.addDocument(storedDocument);
                            docAdded = true;
                        }
                        lastParentId = parentNode.getNodeId();
                    }
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }

    private final class MatcherCallback
    extends SearchCallback {
        private final TermMatcher matcher;
        private final XMLString key;

        MatcherCallback(DocumentSet docs, NodeSet contextSet, NodeSet result, TermMatcher matcher, boolean returnAncestor) {
            super(docs, contextSet, result, returnAncestor);
            this.key = new XMLString(128);
            this.matcher = matcher;
        }

        @Override
        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            int offset = value.data()[value.start()] == IndexType.GENERIC.val ? 6 : 11;
            this.key.reuse();
            UTF8.decode(value.data(), value.start() + offset, value.getLength() - offset, this.key);
            if (this.matcher.matches(this.key)) {
                super.indexInfo(value, pointer);
            }
            return true;
        }
    }

    private class SearchCallback
    implements BTreeCallback {
        private final DocumentSet docs;
        private final NodeSet contextSet;
        private final NodeSet result;
        private final boolean returnAncestor;

        public SearchCallback(DocumentSet docs, NodeSet contextSet, NodeSet result, boolean returnAncestor) {
            this.docs = docs;
            this.contextSet = contextSet;
            this.result = result;
            this.returnAncestor = returnAncestor;
        }

        @Override
        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            VariableByteInput is;
            try {
                is = NativeValueIndex.this.dbValues.getAsStream(pointer);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                while (is.available() > 0) {
                    int storedDocId = is.readInt();
                    int gidsCount = is.readInt();
                    int size = is.readFixedInt();
                    DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes(size);
                        continue;
                    }
                    NodeId previous = null;
                    for (int j = 0; j < gidsCount; ++j) {
                        NodeId nodeId;
                        previous = nodeId = NativeValueIndex.this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        NodeProxy storedNode = new NodeProxy(storedDocument, nodeId);
                        if (this.contextSet != null) {
                            int sizeHint = this.contextSet.getSizeHint(storedDocument);
                            if (this.returnAncestor) {
                                NodeProxy parentNode = this.contextSet.get(storedNode);
                                if (parentNode == null) continue;
                                this.result.add(parentNode, sizeHint);
                                continue;
                            }
                            this.result.add(storedNode, sizeHint);
                            continue;
                        }
                        this.result.add(storedNode, -1);
                    }
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    private static final class CollatorMatcher
    implements TermMatcher {
        private final String expr;
        private final Constants.StringTruncationOperator truncation;
        private final Collator collator;

        CollatorMatcher(String expr, Constants.StringTruncationOperator truncation, Collator collator) throws EXistException {
            if (collator == null) {
                throw new EXistException("Collator must be non-null");
            }
            this.expr = expr;
            this.truncation = truncation;
            this.collator = collator;
        }

        @Override
        public boolean matches(CharSequence term) {
            boolean matches;
            switch (this.truncation) {
                case LEFT: {
                    matches = Collations.endsWith(this.collator, term.toString(), this.expr);
                    break;
                }
                case RIGHT: {
                    matches = Collations.startsWith(this.collator, term.toString(), this.expr);
                    break;
                }
                case BOTH: {
                    matches = Collations.contains(this.collator, term.toString(), this.expr);
                    break;
                }
                default: {
                    matches = Collations.equals(this.collator, term.toString(), this.expr);
                }
            }
            return matches;
        }
    }

    private static final class EndsWithMatcher
    implements TermMatcher {
        private final String expr;

        EndsWithMatcher(String expr) throws EXistException {
            this.expr = expr;
        }

        @Override
        public boolean matches(CharSequence term) {
            return term.toString().endsWith(this.expr);
        }
    }

    private static final class StartsWithMatcher
    implements TermMatcher {
        private final String expr;

        StartsWithMatcher(String expr) throws EXistException {
            this.expr = expr;
        }

        @Override
        public boolean matches(CharSequence term) {
            return term.toString().startsWith(this.expr);
        }
    }

    private static final class ContainsMatcher
    implements TermMatcher {
        private final String expr;

        ContainsMatcher(String expr) throws EXistException {
            this.expr = expr;
        }

        @Override
        public boolean matches(CharSequence term) {
            return term.toString().contains(this.expr);
        }
    }

    private static final class ExactMatcher
    implements TermMatcher {
        private final String expr;

        ExactMatcher(String expr) throws EXistException {
            this.expr = expr;
        }

        @Override
        public boolean matches(CharSequence term) {
            return term.toString().equals(this.expr);
        }
    }

    private static class PendingChanges<K> {
        final IndexType indexType;
        final Map<K, List<NodeId>> changes = new TreeMap<K, List<NodeId>>();

        PendingChanges(IndexType indexType) {
            this.indexType = indexType;
        }
    }

    public static enum IndexType {
        GENERIC(0),
        QNAME(1);

        final byte val;

        private IndexType(byte val) {
            this.val = val;
        }
    }
}

