/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.IdentityHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.UpdateListener;

public class NotificationService
extends IdentityHashMap<UpdateListener, Object>
implements BrokerPoolService {
    private static final long serialVersionUID = -3629584664969740903L;
    private static final Logger LOG = LogManager.getLogger(NotificationService.class);

    public synchronized void subscribe(UpdateListener listener) {
        this.put(listener, new Object());
    }

    public synchronized void unsubscribe(UpdateListener listener) {
        Object i = this.remove(listener);
        if (i == null) {
            throw new RuntimeException(this.hashCode() + " listener not found: " + listener.hashCode());
        }
        listener.unsubscribe();
    }

    public synchronized void notifyUpdate(DocumentImpl document, int event) {
        for (UpdateListener listener : this.keySet()) {
            listener.documentUpdated(document, event);
        }
    }

    public synchronized void notifyMove(NodeId oldNodeId, IStoredNode newNode) {
        for (UpdateListener listener : this.keySet()) {
            listener.nodeMoved(oldNodeId, newNode);
        }
    }

    public void debug() {
        LOG.debug("Registered UpdateListeners:");
        for (UpdateListener listener : this.keySet()) {
            listener.debug();
        }
    }
}

