/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RenameBinaryLoggable
extends AbstractLoggable {
    private static final Logger LOG = LogManager.getLogger(RenameBinaryLoggable.class);
    private Path original;
    private Path backup;

    public RenameBinaryLoggable(DBBroker broker, Txn txn, Path original, Path backup) {
        super((byte)64, txn.getId());
        this.original = original;
        this.backup = backup;
        LOG.debug("Rename binary created " + original + " -> " + backup);
    }

    public RenameBinaryLoggable(DBBroker broker, long transactionId) {
        super((byte)64, transactionId);
        LOG.debug("Rename binary created ...");
    }

    @Override
    public void write(ByteBuffer out) {
        String originalPath = this.original.toAbsolutePath().toString();
        byte[] data = originalPath.getBytes(StandardCharsets.UTF_8);
        out.putInt(data.length);
        out.put(data);
        String backupPath = this.backup.toAbsolutePath().toString();
        data = backupPath.getBytes(StandardCharsets.UTF_8);
        out.putInt(data.length);
        out.put(data);
    }

    @Override
    public void read(ByteBuffer in) {
        int size = in.getInt();
        byte[] data = new byte[size];
        in.get(data);
        this.original = Paths.get(new String(data, StandardCharsets.UTF_8), new String[0]);
        size = in.getInt();
        data = new byte[size];
        in.get(data);
        this.backup = Paths.get(new String(data, StandardCharsets.UTF_8), new String[0]);
        LOG.debug("Rename binary read: " + this.original.toAbsolutePath().toString() + " -> " + this.backup.toAbsolutePath().toString());
    }

    @Override
    public int getLogSize() {
        return 8 + this.original.toAbsolutePath().toString().getBytes(StandardCharsets.UTF_8).length + this.backup.toAbsolutePath().toString().getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public void redo() throws LogException {
    }

    @Override
    public void undo() throws LogException {
        LOG.debug("Undo rename: " + this.original.toAbsolutePath().toString());
        try {
            Files.move(this.backup, this.original, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ioe) {
            throw new LogException("Cannot move backup " + this.backup.toAbsolutePath().toString() + " to original file " + this.original.toAbsolutePath().toString());
        }
    }

    @Override
    public String dump() {
        return super.dump() + " - rename " + this.original + " to " + this.backup;
    }
}

