/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.ByteConversion;

public final class Signatures {
    private static final Logger LOG = LogManager.getLogger(Signatures.class);
    public static final int Char = 0;
    public static final int Elem = 1;
    public static final int Proc = 2;
    public static final int Comm = 3;
    public static final int Attr = 4;
    public static final int Cdata = 5;
    public static final int intContent = 1;
    public static final int byteContent = 3;
    public static final int noContent = 0;
    public static final int shortContent = 2;

    public static final int getLength(int type) {
        switch (type) {
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static final byte getSizeType(int length) {
        if (length > Short.MAX_VALUE) {
            return 1;
        }
        if (length > 127) {
            return 2;
        }
        if (length > 0) {
            return 3;
        }
        return 0;
    }

    public static final short getType(byte signature) {
        byte type = (byte)((signature & 0xE0) >> 5);
        switch (type) {
            case 0: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 8;
            }
            case 5: {
                return 4;
            }
        }
        LOG.error("Unknown node type : " + type);
        return -1;
    }

    public static final int read(int type, byte[] data, int pos) {
        switch (type) {
            case 1: {
                return ByteConversion.byteToInt(data, pos);
            }
            case 2: {
                return ByteConversion.byteToShort(data, pos);
            }
            case 3: {
                return data[pos];
            }
        }
        return 0;
    }

    public static final void write(int type, int size, byte[] data, int pos) {
        switch (type) {
            case 1: {
                ByteConversion.intToByte(size, data, pos);
                break;
            }
            case 2: {
                ByteConversion.shortToByte((short)size, data, pos);
                break;
            }
            case 3: {
                data[pos] = (byte)size;
            }
        }
    }
}

