/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.EOFException;
import java.io.IOException;
import org.exist.dom.persistent.NodeHandle;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class StorageAddress {
    public static final long createPointer(int page, short tid) {
        return (long)tid | ((long)page & 0xFFFFFFFFL) << 32;
    }

    public static final long createPointer(int page, short tid, short flags) {
        return (long)tid | ((long)flags & 0xFFFFL) << 16 | ((long)page & 0xFFFFFFFFL) << 32;
    }

    public static final short tidFromPointer(long pointer) {
        return (short)(pointer & 0xFFFFL);
    }

    public static final int pageFromPointer(long pointer) {
        return (int)(pointer >>> 32 & 0xFFFFFFFFL);
    }

    public static final short indexTypeFromPointer(long pointer) {
        return (short)(pointer >>> 16 & 0xFFFFL);
    }

    public static final long setIndexType(long pointer, short type) {
        return pointer | (long)(type << 16) & 0xFFFF0000L;
    }

    public static final boolean hasAddress(long pointer) {
        return (pointer & 0xFFFFFFFF0000FFFFL) > 0L;
    }

    public static final boolean equals(long p0, long p1) {
        return (p0 & 0xFFFFFFFF0000FFFFL) == (p1 & 0xFFFFFFFF0000FFFFL);
    }

    public static final boolean equals(NodeHandle n0, NodeHandle n1) {
        return StorageAddress.equals(n0.getInternalAddress(), n1.getInternalAddress());
    }

    public static final void write(long pointer, VariableByteOutputStream os) {
        os.writeInt(StorageAddress.pageFromPointer(pointer));
        os.writeShort(StorageAddress.tidFromPointer(pointer));
        os.writeShort(StorageAddress.indexTypeFromPointer(pointer));
    }

    public static final long read(VariableByteInput is) throws IOException, EOFException {
        return StorageAddress.createPointer(is.readInt(), is.readShort(), is.readShort());
    }

    public static final String toString(long pointer) {
        return StorageAddress.pageFromPointer(pointer) + ":" + StorageAddress.tidFromPointer(pointer);
    }

    public static final String toString(NodeHandle nodeHandle) {
        return StorageAddress.toString(nodeHandle.getInternalAddress());
    }
}

