/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import net.jcip.annotations.GuardedBy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.storage.sync.Sync;

public class SystemTaskManager
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(SystemTaskManager.class);
    @GuardedBy(value="itself")
    private final Deque<SystemTask> waitingSystemTasks = new ArrayDeque<SystemTask>();
    private final BrokerPool pool;

    public SystemTaskManager(BrokerPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSystemTask(SystemTask task) {
        Deque<SystemTask> deque = this.waitingSystemTasks;
        synchronized (deque) {
            this.waitingSystemTasks.push(task);
            this.pool.getTransactionManager().processSystemTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTasks() {
        if (this.pool.isShuttingDown() || this.pool.isShutDown()) {
            return;
        }
        Deque<SystemTask> deque = this.waitingSystemTasks;
        synchronized (deque) {
            try (DBBroker broker = this.pool.get(Optional.of(this.pool.getSecurityManager().getSystemSubject()));){
                while (!this.waitingSystemTasks.isEmpty()) {
                    SystemTask task = this.waitingSystemTasks.pop();
                    if (this.pool.isShuttingDown()) {
                        LOG.info("Skipping SystemTask: '" + task.getName() + "' as database is shutting down...");
                        continue;
                    }
                    if (this.pool.isShutDown()) {
                        LOG.warn("Unable to execute SystemTask: '" + task.getName() + "' as database is shut down!");
                        continue;
                    }
                    if (task.afterCheckpoint()) {
                        this.pool.sync(broker, Sync.MAJOR);
                    }
                    this.runSystemTask(task, broker);
                }
            }
            catch (Exception e) {
                LOG.error("System maintenance task reported error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void runSystemTask(SystemTask task, DBBroker broker) throws EXistException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running system maintenance task: " + task.getClass().getName());
        }
        task.execute(broker);
        if (LOG.isDebugEnabled()) {
            LOG.debug("System task completed.");
        }
    }
}

