/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class UpdateBinaryLoggable
extends AbstractLoggable {
    private static final Logger LOG = LogManager.getLogger(UpdateBinaryLoggable.class);
    private Path original;
    private Path backup;

    public UpdateBinaryLoggable(DBBroker broker, Txn txn, Path original, Path backup) {
        super((byte)66, txn.getId());
        this.original = original;
        this.backup = backup;
    }

    public UpdateBinaryLoggable(DBBroker broker, long transactionId) {
        super((byte)66, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        String originalPath = this.original.toAbsolutePath().toString();
        byte[] data = originalPath.getBytes(StandardCharsets.UTF_8);
        out.putInt(data.length);
        out.put(data);
        String backupPath = this.backup.toAbsolutePath().toString();
        data = backupPath.getBytes(StandardCharsets.UTF_8);
        out.putInt(data.length);
        out.put(data);
    }

    @Override
    public void read(ByteBuffer in) {
        int size = in.getInt();
        byte[] data = new byte[size];
        in.get(data);
        this.original = Paths.get(new String(data, StandardCharsets.UTF_8), new String[0]);
        size = in.getInt();
        data = new byte[size];
        in.get(data);
        this.backup = Paths.get(new String(data, StandardCharsets.UTF_8), new String[0]);
    }

    @Override
    public int getLogSize() {
        return 8 + this.original.toAbsolutePath().toString().getBytes(StandardCharsets.UTF_8).length + this.backup.toAbsolutePath().toString().getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public void redo() throws LogException {
    }

    @Override
    public void undo() throws LogException {
        try {
            Files.copy(this.backup, this.original, new CopyOption[0]);
        }
        catch (IOException ioe) {
            throw new LogException("Cannot copy backup " + this.backup.toAbsolutePath().toString() + " to original " + this.original.toAbsolutePath().toString(), ioe);
        }
    }

    @Override
    public String dump() {
        return super.dump() + " - update " + this.original + " to " + this.backup;
    }
}

