/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.exist.EXistException;
import org.exist.storage.Indexable;
import org.exist.storage.btree.Value;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class ValueIndexFactory {
    private static final int LENGTH_VALUE_TYPE = 1;

    public static final Indexable deserialize(byte[] data, int start, int len) throws EXistException {
        byte type = data[start];
        if (Type.subTypeOf(type, 22)) {
            String s = new String(data, start + 1, len - 1, StandardCharsets.UTF_8);
            return new StringValue(s);
        }
        if (Type.subTypeOf(type, 50)) {
            try {
                XMLGregorianCalendar xmlutccal = DatatypeFactory.newInstance().newXMLGregorianCalendar(ByteConversion.byteToIntH(data, start + 1), (int)data[start + 5], (int)data[start + 6], (int)data[start + 7], (int)data[start + 8], (int)data[start + 9], ByteConversion.byteToShortH(data, start + 10), 0);
                return new DateTimeValue(xmlutccal);
            }
            catch (DatatypeConfigurationException dtce) {
                throw new EXistException("Could not deserialize xs:dateTime data typefor range index key: " + Type.getTypeName(type) + " - " + dtce.getMessage());
            }
        }
        if (Type.subTypeOf(type, 51)) {
            try {
                XMLGregorianCalendar xmlutccal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(ByteConversion.byteToIntH(data, start + 1), data[start + 5], data[start + 6], 0);
                return new DateValue(xmlutccal);
            }
            catch (DatatypeConfigurationException dtce) {
                throw new EXistException("Could not deserialize xs:date data type for range index key: " + Type.getTypeName(type) + " - " + dtce.getMessage());
            }
            catch (XPathException xpe) {
                throw new EXistException("Could not deserialize xs:date data type for range index key: " + Type.getTypeName(type) + " - " + xpe.getMessage());
            }
        }
        if (Type.subTypeOf(type, 31)) {
            return new IntegerValue(ByteConversion.byteToLong(data, start + 1) ^ Long.MIN_VALUE);
        }
        if (type == 34) {
            long bits = ByteConversion.byteToLong(data, start + 1) ^ Long.MIN_VALUE;
            double d = Double.longBitsToDouble(bits);
            return new DoubleValue(d);
        }
        if (type == 33) {
            int bits = ByteConversion.byteToInt(data, start + 1) ^ Integer.MIN_VALUE;
            float f = Float.intBitsToFloat(bits);
            return new FloatValue(f);
        }
        if (type == 32) {
            String s = new String(data, start + 1, len - 1, StandardCharsets.UTF_8);
            return new DecimalValue(new BigDecimal(s));
        }
        if (type == 23) {
            return new BooleanValue(data[start + 1] == 1);
        }
        throw new EXistException("Unknown data type for deserialization: " + Type.getTypeName(type));
    }

    public static final byte[] serialize(Indexable value, int offset) throws EXistException {
        return ValueIndexFactory.serialize(value, offset, true);
    }

    public static final byte[] serialize(Indexable value, int offset, boolean caseSensitive) throws EXistException {
        if (Type.subTypeOf(value.getType(), 22)) {
            String val = caseSensitive ? ((StringValue)value).getStringValue() : ((StringValue)value).getStringValue().toLowerCase();
            byte[] data = new byte[offset + 1 + UTF8.encoded(val)];
            data[offset] = (byte)value.getType();
            UTF8.encode(val, data, offset + 1);
            return data;
        }
        if (Type.subTypeOf(value.getType(), 50)) {
            XMLGregorianCalendar utccal = ((AbstractDateTimeValue)value).calendar.normalize();
            byte[] data = new byte[offset + 12];
            data[offset] = 50;
            ByteConversion.intToByteH(utccal.getYear(), data, offset + 1);
            data[offset + 5] = (byte)utccal.getMonth();
            data[offset + 6] = (byte)utccal.getDay();
            data[offset + 7] = (byte)utccal.getHour();
            data[offset + 8] = (byte)utccal.getMinute();
            data[offset + 9] = (byte)utccal.getSecond();
            int ms = utccal.getMillisecond();
            ByteConversion.shortToByteH((short)(ms == Integer.MIN_VALUE ? 0 : ms), data, offset + 10);
            return data;
        }
        if (Type.subTypeOf(value.getType(), 51)) {
            XMLGregorianCalendar utccal = ((AbstractDateTimeValue)value).calendar.normalize();
            byte[] data = new byte[offset + 7];
            data[offset] = 51;
            ByteConversion.intToByteH(utccal.getYear(), data, offset + 1);
            data[offset + 5] = (byte)utccal.getMonth();
            data[offset + 6] = (byte)utccal.getDay();
            return data;
        }
        if (Type.subTypeOf(value.getType(), 31)) {
            byte[] data = new byte[offset + 1 + 8];
            data[offset] = 31;
            long l = ((IntegerValue)value).getValue() - Long.MIN_VALUE;
            ByteConversion.longToByte(l, data, offset + 1);
            return data;
        }
        if (value.getType() == 34) {
            byte[] data = new byte[offset + 1 + 8];
            data[offset] = 34;
            long bits = Double.doubleToLongBits(((DoubleValue)value).getValue()) ^ Long.MIN_VALUE;
            ByteConversion.longToByte(bits, data, offset + 1);
            return data;
        }
        if (value.getType() == 33) {
            byte[] data = new byte[offset + 1 + 4];
            data[offset] = 33;
            int bits = Float.floatToIntBits(((FloatValue)value).getValue()) ^ Integer.MIN_VALUE;
            ByteConversion.intToByteH(bits, data, offset + 1);
            return data;
        }
        if (value.getType() == 23) {
            byte[] data = new byte[offset + 1 + 1];
            data[offset] = 23;
            data[offset + 1] = (byte)(((BooleanValue)value).getValue() ? 1 : 0);
            return data;
        }
        if (value.getType() == 32) {
            BigDecimal dec = ((DecimalValue)value).getValue();
            String val = dec.toString();
            byte[] data = new byte[offset + 1 + UTF8.encoded(val)];
            data[offset] = (byte)value.getType();
            UTF8.encode(val, data, offset + 1);
            return data;
        }
        throw new EXistException("Unknown data type for serialization: " + Type.getTypeName(value.getType()));
    }

    public static void main(String[] args) {
        try {
            DateTimeValue dtv = new DateTimeValue("0753-04-21T01:00:00+01:00");
            byte[] b1 = ValueIndexFactory.serialize(dtv, 0);
            ValueIndexFactory.print(dtv, b1);
            DateTimeValue dtv2 = new DateTimeValue("1960-03-19T19:03:59.782+01:00");
            byte[] b2 = ValueIndexFactory.serialize(dtv2, 0);
            ValueIndexFactory.print(dtv2, b2);
            System.out.println(new Value(b1).compareTo(new Value(b2)));
            DateTimeValue dtv2_ = (DateTimeValue)ValueIndexFactory.deserialize(b2, 0, b2.length);
            if (!dtv2.equals(dtv2_)) {
                System.out.println("ERROR! " + dtv2.toString() + " ne " + dtv2_.toString());
            }
            DateValue dv = new DateValue("1960-03-19Z");
            byte[] b3 = ValueIndexFactory.serialize(dv, 0);
            ValueIndexFactory.print(dv, b3);
            DateValue dv_ = (DateValue)ValueIndexFactory.deserialize(b3, 0, b3.length);
            if (!dv.equals(dv_)) {
                System.out.println("ERROR! " + dv.toString() + " ne " + dv_.toString());
            }
            IntegerValue iv = new IntegerValue(753L);
            byte[] i1 = ValueIndexFactory.serialize(iv, 0);
            ValueIndexFactory.print(iv, i1);
            IntegerValue iv2 = new IntegerValue(1960L);
            byte[] i2 = ValueIndexFactory.serialize(iv2, 0);
            ValueIndexFactory.print(iv2, i2);
            System.out.println(new Value(i1).compareTo(new Value(i2)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void print(AtomicValue dtv, byte[] data) throws XPathException {
        System.out.print(dtv.getStringValue() + " = ");
        for (int i = 0; i < data.length; ++i) {
            System.out.print(" " + Integer.toHexString(data[i] & 0xFF));
        }
        System.out.println();
    }
}

