/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTAbstractLoggable;
import org.exist.storage.btree.Paged;
import org.exist.storage.btree.Value;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class InsertValueLoggable
extends BTAbstractLoggable {
    protected long pageNum;
    protected int idx;
    protected long pointer;
    protected int pointerIdx;
    protected Value key;

    public InsertValueLoggable(Txn transaction, byte fileId, long pageNum, int idx, Value key, int pointerIdx, long pointer) {
        super((byte)32, fileId, transaction);
        this.pageNum = pageNum;
        this.idx = idx;
        this.key = key;
        this.pointerIdx = pointerIdx;
        this.pointer = pointer;
    }

    public InsertValueLoggable(DBBroker broker, long transactionId) {
        super((byte)32, broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
        out.putShort((short)this.idx);
        out.putShort((short)this.pointerIdx);
        out.putLong(this.pointer);
        out.putShort((short)this.key.getLength());
        out.put(this.key.data(), this.key.start(), this.key.getLength());
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
        this.idx = in.getShort();
        this.pointerIdx = in.getShort();
        this.pointer = in.getLong();
        byte[] data = new byte[in.getShort()];
        in.get(data);
        this.key = new Value(data);
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 18 + this.key.getLength();
    }

    @Override
    public void redo() throws LogException {
        this.getStorage().redoInsertValue(this);
    }

    @Override
    public void undo() throws LogException {
        this.getStorage().undoInsertValue(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - insert btree key on page: " + this.pageNum + ": " + Paged.hexDump(this.key.data());
    }
}

