/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTAbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class SetParentLoggable
extends BTAbstractLoggable {
    protected long pageNum;
    protected long parentNum;

    public SetParentLoggable(Txn transaction, byte fileId, long pageNum, long parentNum) {
        super((byte)35, fileId, transaction);
        this.pageNum = pageNum;
        this.parentNum = parentNum;
    }

    public SetParentLoggable(DBBroker broker, long transactionId) {
        super((byte)35, broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putLong(this.pageNum);
        out.putLong(this.parentNum);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getLong();
        this.parentNum = in.getLong();
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 16;
    }

    @Override
    public void redo() throws LogException {
        this.getStorage().redoSetParent(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - set parent for page: " + this.pageNum + ": " + this.parentNum;
    }
}

