/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.exist.storage.btree.BTree;

public class TreeMetrics {
    private int leafPages = 0;
    private int innerPages = 0;
    private int dataPages = 0;
    private String btreeName;

    public TreeMetrics(String name) {
        this.btreeName = name;
    }

    public void addPage(int status) {
        if (status == 2) {
            this.addInnerPage();
        } else {
            this.addLeafPage();
        }
    }

    public void addLeafPage() {
        ++this.leafPages;
    }

    public void addInnerPage() {
        ++this.innerPages;
    }

    public void addDataPage() {
        ++this.dataPages;
    }

    public void print(PrintWriter writer) {
        writer.println("BTree tree metrics for " + this.btreeName);
        writer.println("# inner pages: " + this.innerPages);
        writer.println("# leaf pages: " + this.leafPages);
        writer.println("# data pages: " + this.dataPages);
    }

    public void toLogger() {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.print(writer);
        if (BTree.LOG.isDebugEnabled()) {
            BTree.LOG.debug(sw.toString());
        }
    }
}

