/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import net.jcip.annotations.NotThreadSafe;
import org.exist.storage.cache.BTreeCacheable;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRUCache;
import org.exist.util.hashtable.SequencedLongHashMap;

@NotThreadSafe
public class BTreeCache<T extends BTreeCacheable>
extends LRUCache<T> {
    public BTreeCache(String name, int size, double growthFactor, double growthThreshold, String type) {
        super(name, size, growthFactor, growthThreshold, type);
    }

    @Override
    public void add(T item, int initialRefCount) {
        this.add(item);
    }

    @Override
    public void add(T item) {
        this.map.put(item.getKey(), item);
        if (this.map.size() >= this.max + 1) {
            this.removeNext(item);
        }
    }

    private void removeNext(T item) {
        boolean removed = false;
        boolean mustRemoveInner = false;
        SequencedLongHashMap.Entry next = this.map.getFirstEntry();
        do {
            BTreeCacheable cached;
            if ((cached = (BTreeCacheable)next.getValue()).allowUnload() && cached.getKey() != item.getKey() && (mustRemoveInner || !cached.isInnerPage())) {
                cached.sync(true);
                this.map.remove(next.getKey());
                removed = true;
                continue;
            }
            if ((next = next.getNext()) != null) continue;
            next = this.map.getFirstEntry();
            mustRemoveInner = true;
        } while (!removed);
        this.accounting.replacedPage((Cacheable)item);
        if (this.growthFactor > 1.0 && this.accounting.resizeNeeded()) {
            this.cacheManager.requestMem(this);
        }
    }
}

