/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import java.lang.reflect.Array;
import net.jcip.annotations.NotThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.CacheManager;
import org.exist.storage.cache.Accounting;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.Long2ObjectHashMap;

@NotThreadSafe
public class GClockCache<T extends Cacheable>
implements Cache<T> {
    private static final Logger LOG = LogManager.getLogger(GClockCache.class);
    private final String name;
    private final Class<T> cacheableClazz;
    protected int size;
    private final double growthFactor;
    Accounting accounting;
    private final String type;
    protected T[] items;
    protected Long2ObjectHashMap<T> map;
    protected int count = 0;
    protected int used = 0;
    private int hitsOld = 0;
    protected CacheManager cacheManager = null;

    public GClockCache(String name, Class<T> cacheableClazz, int size, double growthFactor, double growthThreshold, String type) {
        this.name = name;
        this.cacheableClazz = cacheableClazz;
        this.size = size;
        this.growthFactor = growthFactor;
        this.accounting = new Accounting(growthThreshold);
        this.accounting.setTotalSize(size);
        this.type = type;
        this.items = this.createArray(cacheableClazz, size);
        this.map = new Long2ObjectHashMap(size * 2);
    }

    private T[] createArray(Class<T> clazz, int size) {
        return (Cacheable[])Array.newInstance(clazz, size);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void add(T item) {
        this.add(item, 1);
    }

    @Override
    public void add(T item, int initialRefCount) {
        Cacheable old = (Cacheable)this.map.get(item.getKey());
        if (old != null) {
            old.incReferenceCount();
            return;
        }
        item.setReferenceCount(initialRefCount);
        if (this.count < this.size) {
            this.items[this.count++] = item;
            this.map.put(item.getKey(), item);
            ++this.used;
        } else {
            this.removeOne(item);
        }
    }

    @Override
    public T get(T item) {
        return this.get(item.getKey());
    }

    @Override
    public T get(long key) {
        Cacheable item = (Cacheable)this.map.get(key);
        if (item == null) {
            this.accounting.missesIncrement();
        } else {
            this.accounting.hitIncrement();
        }
        return (T)item;
    }

    @Override
    public void remove(T item) {
        long key = item.getKey();
        Cacheable cacheable = (Cacheable)this.map.remove(key);
        if (cacheable == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || this.items[i].getKey() != key) continue;
            this.items[i] = null;
            --this.used;
            return;
        }
        LOG.error("item not found in list");
    }

    @Override
    public boolean flush() {
        boolean flushed = false;
        int written = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].sync(false)) continue;
            ++written;
            flushed = true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(written + " pages written to disk");
        }
        return flushed;
    }

    @Override
    public boolean hasDirtyItems() {
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].isDirty()) continue;
            return true;
        }
        return false;
    }

    protected T removeOne(T item) {
        Cacheable old = null;
        boolean removed = false;
        do {
            int bucket = -1;
            for (int i = 0; i < this.count; ++i) {
                old = (Cacheable)this.items[i];
                if (old == null) {
                    bucket = i;
                    continue;
                }
                if (old.decReferenceCount() >= 1 || bucket >= 0) continue;
                bucket = i;
            }
            if (bucket <= -1) continue;
            old = (Cacheable)this.items[bucket];
            if (old != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.name + " replacing " + old.getKey() + " for " + item.getKey());
                }
                this.map.remove(old.getKey());
                old.sync(true);
            } else {
                ++this.used;
            }
            this.items[bucket] = item;
            this.map.put(item.getKey(), item);
            removed = true;
        } while (!removed);
        if (old != null) {
            this.accounting.replacedPage((Cacheable)item);
            if (this.cacheManager != null && this.accounting.resizeNeeded()) {
                this.cacheManager.requestMem(this);
            }
        }
        return (T)old;
    }

    @Override
    public int getBuffers() {
        return this.size;
    }

    @Override
    public int getUsedBuffers() {
        return this.used;
    }

    @Override
    public double getGrowthFactor() {
        return this.growthFactor;
    }

    @Override
    public int getHits() {
        return this.accounting.getHits();
    }

    @Override
    public int getFails() {
        return this.accounting.getMisses();
    }

    public int getThrashing() {
        return this.accounting.getThrashing();
    }

    @Override
    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    @Override
    public void resize(int newSize) {
        if (newSize < this.size) {
            this.shrink(newSize);
        } else {
            Cacheable[] newItems = this.createArray(this.cacheableClazz, newSize);
            Long2ObjectHashMap<T> newMap = new Long2ObjectHashMap<T>(newSize * 2);
            for (int i = 0; i < this.count; ++i) {
                newItems[i] = this.items[i];
                newMap.put(this.items[i].getKey(), this.items[i]);
            }
            this.size = newSize;
            this.map = newMap;
            this.items = newItems;
            this.accounting.reset();
            this.accounting.setTotalSize(this.size);
        }
    }

    private void shrink(int newSize) {
        this.flush();
        this.items = this.createArray(this.cacheableClazz, newSize);
        this.map = new Long2ObjectHashMap(newSize * 2);
        this.size = newSize;
        this.count = 0;
        this.used = 0;
        this.accounting.reset();
        this.accounting.setTotalSize(this.size);
    }

    @Override
    public int getLoad() {
        if (this.hitsOld == 0) {
            this.hitsOld = this.accounting.getHits();
            return Integer.MAX_VALUE;
        }
        int load = this.accounting.getHits() - this.hitsOld;
        this.hitsOld = this.accounting.getHits();
        return load;
    }
}

