/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import net.jcip.annotations.NotThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.CacheManager;
import org.exist.storage.cache.Accounting;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.SequencedLongHashMap;

@NotThreadSafe
public class LRUCache<T extends Cacheable>
implements Cache<T> {
    private static final Logger LOG = LogManager.getLogger(LRUCache.class);
    private final String name;
    protected int max;
    protected final double growthFactor;
    protected final Accounting accounting;
    protected SequencedLongHashMap<T> map;
    private final String type;
    private int hitsOld = -1;
    protected CacheManager cacheManager = null;

    public LRUCache(String name, int size, double growthFactor, double growthThreshold, String type) {
        this.name = name;
        this.max = size;
        this.growthFactor = growthFactor;
        this.accounting = new Accounting(growthThreshold);
        this.accounting.setTotalSize(this.max);
        this.map = new SequencedLongHashMap(size * 2);
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void add(T item, int initialRefCount) {
        this._add(item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void add(T item) {
        this._add(item);
    }

    private void _add(T item) {
        if (this.map.size() == this.max) {
            this.removeOne(item);
        }
        this.map.put(item.getKey(), item);
    }

    @Override
    public T get(T item) {
        return this.get(item.getKey());
    }

    @Override
    public T get(long key) {
        Cacheable obj = (Cacheable)this.map.get(key);
        if (obj == null) {
            this.accounting.missesIncrement();
        } else {
            this.accounting.hitIncrement();
        }
        return (T)obj;
    }

    @Override
    public void remove(T item) {
        this.map.remove(item.getKey());
    }

    @Override
    public boolean flush() {
        boolean flushed = false;
        for (SequencedLongHashMap.Entry<T> next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
            Cacheable cacheable = (Cacheable)next.getValue();
            if (!cacheable.isDirty()) continue;
            flushed |= cacheable.sync(false);
        }
        return flushed;
    }

    @Override
    public boolean hasDirtyItems() {
        for (SequencedLongHashMap.Entry<T> next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
            Cacheable cacheable = (Cacheable)next.getValue();
            if (!cacheable.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBuffers() {
        return this.max;
    }

    @Override
    public int getUsedBuffers() {
        return this.map.size();
    }

    @Override
    public int getHits() {
        return this.accounting.getHits();
    }

    @Override
    public int getFails() {
        return this.accounting.getMisses();
    }

    public int getThrashing() {
        return this.accounting.getThrashing();
    }

    protected void removeOne(T item) {
        boolean removed = false;
        SequencedLongHashMap.Entry<T> next = this.map.getFirstEntry();
        do {
            Cacheable cached;
            if ((cached = (Cacheable)next.getValue()).allowUnload() && cached.getKey() != item.getKey()) {
                cached.sync(true);
                this.map.remove(next.getKey());
                removed = true;
                continue;
            }
            if ((next = next.getNext()) != null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to remove entry");
            }
            next = this.map.getFirstEntry();
        } while (!removed);
        this.accounting.replacedPage((Cacheable)item);
        if (this.growthFactor > 1.0 && this.accounting.resizeNeeded()) {
            this.cacheManager.requestMem(this);
        }
    }

    @Override
    public double getGrowthFactor() {
        return this.growthFactor;
    }

    @Override
    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    @Override
    public void resize(int newSize) {
        if (newSize < this.max) {
            this.shrink(newSize);
        } else {
            SequencedLongHashMap<Cacheable> newMap = new SequencedLongHashMap<Cacheable>(newSize * 2);
            for (SequencedLongHashMap.Entry<T> next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
                Cacheable cacheable = (Cacheable)next.getValue();
                newMap.put(cacheable.getKey(), cacheable);
            }
            this.max = newSize;
            this.map = newMap;
            this.accounting.reset();
            this.accounting.setTotalSize(this.max);
        }
    }

    protected void shrink(int newSize) {
        this.flush();
        this.map = new SequencedLongHashMap(newSize);
        this.max = newSize;
        this.accounting.reset();
        this.accounting.setTotalSize(this.max);
    }

    @Override
    public int getLoad() {
        if (this.hitsOld == 0) {
            this.hitsOld = this.accounting.getHits();
            return Integer.MAX_VALUE;
        }
        int load = this.accounting.getHits() - this.hitsOld;
        this.hitsOld = this.accounting.getHits();
        return load;
    }
}

