/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.dom.AddValueLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class AddMovedValueLoggable
extends AddValueLoggable {
    protected long backLink;

    public AddMovedValueLoggable(Txn transaction, long pageNum, short tid, byte[] value, long backLink) {
        super((byte)27, transaction, pageNum, tid, value);
        this.backLink = backLink;
    }

    public AddMovedValueLoggable(DBBroker broker, long transactionId) {
        super((byte)27, broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putLong(this.backLink);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.backLink = in.getLong();
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 8;
    }

    @Override
    public void redo() throws LogException {
        this.domDb.redoAddMovedValue(this);
    }

    @Override
    public void undo() throws LogException {
        this.domDb.undoAddMovedValue(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - moved value; tid = " + this.tid + " to page " + this.pageNum + "; len = " + this.value.length;
    }
}

