/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

class ItemId {
    public static final short RELOCATED_MASK = Short.MIN_VALUE;
    public static final short LINK_MASK = 16384;
    public static final short ID_MASK = 16383;
    public static final short LINK_OR_RELOCATED_MASK = -16384;
    public static final byte LINK_FLAG = 1;
    public static final byte RELOCATED_FLAG = 2;
    public static final short UNKNOWN_ID = -1;
    public static final short MAX_ID = 16382;
    public static final short DEFRAG_LIMIT = 12286;

    ItemId() {
    }

    public static final byte getFlags(short id) {
        return (byte)((id & 0xFFFFC000) >>> 14);
    }

    public static final short getId(short id) {
        return (short)(id & 0x3FFF);
    }

    public static final boolean matches(short id, short targetId) {
        return (short)(id & 0x3FFF) == targetId;
    }

    public static final short setIsRelocated(short id) {
        return (short)(id | Short.MIN_VALUE);
    }

    public static final boolean isLink(short id) {
        return (id & 0x4000) == 16384;
    }

    public static final short setIsLink(short id) {
        return (short)(id | 0x4000);
    }

    public static final boolean isRelocated(short id) {
        return (id & Short.MIN_VALUE) == Short.MIN_VALUE;
    }

    public static final boolean isLinkOrRelocated(short id) {
        return (id & 0xFFFFC000) != 0;
    }

    public static final boolean isOrdinaryRecord(short id) {
        return (id & 0xFFFFC000) == 0;
    }
}

