/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.StoredNode;
import org.exist.storage.DBBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.INodeIterator;
import org.exist.storage.dom.ItemId;
import org.exist.storage.dom.RecordPos;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteConversion;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.sanity.SanityCheck;

public final class NodeIterator
implements INodeIterator {
    private static final Logger LOG = LogManager.getLogger(NodeIterator.class);
    private DOMFile db = null;
    private NodeHandle node;
    private DocumentImpl doc = null;
    private int offset;
    private short lastTupleID = (short)-1;
    private DOMFile.DOMPage page = null;
    private long pageNum;
    private long startAddress = -1L;
    private DBBroker broker;
    private boolean useNodePool = false;

    public NodeIterator(DBBroker broker, DOMFile db, NodeHandle node, boolean poolable) throws BTreeException, IOException {
        this.db = db;
        this.doc = (DocumentImpl)node.getOwnerDocument();
        this.useNodePool = poolable;
        this.node = node;
        this.broker = broker;
    }

    public long currentAddress() {
        return StorageAddress.createPointer((int)this.pageNum, ItemId.getId(this.lastTupleID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire(Lock.LockMode.READ_LOCK);
            }
            catch (LockException e) {
                LOG.warn("Failed to acquire read lock on " + FileUtils.fileName(this.db.getFile()));
                boolean bl = false;
                lock.release(Lock.LockMode.READ_LOCK);
                return bl;
            }
            this.db.setOwnerObject(this.broker);
            if (this.gotoNextPosition()) {
                this.db.getPageBuffer().add(this.page);
                DOMFile.DOMFilePageHeader pageHeader = this.page.getPageHeader();
                if (this.offset < pageHeader.getDataLength()) {
                    boolean bl = true;
                    return bl;
                }
                if (pageHeader.getNextDataPage() == -1L) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (BTreeException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStoredNode next() {
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire(Lock.LockMode.READ_LOCK);
            }
            catch (LockException e) {
                LOG.warn("Failed to acquire read lock on " + FileUtils.fileName(this.db.getFile()));
                IStoredNode iStoredNode = null;
                lock.release(Lock.LockMode.READ_LOCK);
                return iStoredNode;
            }
            this.db.setOwnerObject(this.broker);
            StoredNode nextNode = null;
            if (this.gotoNextPosition()) {
                long backLink = 0L;
                do {
                    DOMFile.DOMFilePageHeader pageHeader;
                    if (this.offset >= (pageHeader = this.page.getPageHeader()).getDataLength()) {
                        long nextPageNum = pageHeader.getNextDataPage();
                        if (nextPageNum == -1L) {
                            SanityCheck.TRACE("bad link to next " + this.page.page.getPageInfo() + "; previous: " + pageHeader.getPreviousDataPage() + "; offset = " + this.offset + "; lastTupleID = " + this.lastTupleID);
                            System.out.println(this.db.debugPageContents(this.page));
                            IStoredNode iStoredNode = null;
                            return iStoredNode;
                        }
                        this.pageNum = nextPageNum;
                        this.page = this.db.getDOMPage(nextPageNum);
                        this.db.addToBuffer(this.page);
                        this.offset = 0;
                    }
                    this.lastTupleID = ByteConversion.byteToShort(this.page.data, this.offset);
                    this.offset += 2;
                    if (ItemId.isLink(this.lastTupleID)) {
                        this.offset += 8;
                        continue;
                    }
                    int vlen = ByteConversion.byteToShort(this.page.data, this.offset);
                    this.offset += 2;
                    if (vlen < 0) {
                        LOG.error("Got negative length" + vlen + " at offset " + this.offset + "!!!");
                        LOG.debug(this.db.debugPageContents(this.page));
                    }
                    if (ItemId.isRelocated(this.lastTupleID)) {
                        backLink = ByteConversion.byteToLong(this.page.data, this.offset);
                        this.offset += 8;
                    }
                    if (vlen == 0) {
                        vlen = 8;
                        long overflow = ByteConversion.byteToLong(this.page.data, this.offset);
                        this.offset += 8;
                        try {
                            byte[] overflowValue = this.db.getOverflowValue(overflow);
                            nextNode = StoredNode.deserialize(overflowValue, 0, overflowValue.length, this.doc, this.useNodePool);
                        }
                        catch (Exception e) {
                            LOG.warn("Exception while loading overflow value: " + e.getMessage() + "; originating page: " + this.page.page.getPageInfo());
                        }
                    } else {
                        try {
                            nextNode = StoredNode.deserialize(this.page.data, this.offset, vlen, this.doc, this.useNodePool);
                            this.offset += vlen;
                        }
                        catch (Exception e) {
                            LOG.error("Error while deserializing node: " + e.getMessage(), (Throwable)e);
                            LOG.error("Reading from offset: " + this.offset + "; len = " + vlen);
                            LOG.debug(this.db.debugPageContents(this.page));
                            System.out.println(this.db.debugPageContents(this.page));
                            throw new RuntimeException(e);
                        }
                    }
                    if (nextNode == null) {
                        LOG.error("illegal node on page " + this.page.getPageNum() + "; tid = " + ItemId.getId(this.lastTupleID) + "; next = " + this.page.getPageHeader().getNextDataPage() + "; prev = " + this.page.getPageHeader().getPreviousDataPage() + "; offset = " + (this.offset - vlen) + "; len = " + this.page.getPageHeader().getDataLength());
                        System.out.println(this.db.debugPageContents(this.page));
                        IStoredNode iStoredNode = null;
                        return iStoredNode;
                    }
                    if (ItemId.isRelocated(this.lastTupleID)) {
                        nextNode.setInternalAddress(backLink);
                    } else {
                        nextNode.setInternalAddress(StorageAddress.createPointer((int)this.pageNum, ItemId.getId(this.lastTupleID)));
                    }
                    nextNode.setOwnerDocument(this.doc);
                } while (nextNode == null);
            }
            StoredNode storedNode = nextNode;
            return storedNode;
        }
        catch (BTreeException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
        return null;
    }

    private boolean gotoNextPosition() throws BTreeException, IOException {
        if (this.node != null) {
            RecordPos rec = null;
            if (StorageAddress.hasAddress(this.node.getInternalAddress())) {
                rec = this.db.findRecord(this.node.getInternalAddress());
            }
            if (rec == null) {
                if (this.node.getNodeId() == null) {
                    return false;
                }
                long addr = this.db.findValue(this.broker, new NodeProxy(this.node));
                if (addr == -1L) {
                    return false;
                }
                rec = this.db.findRecord(addr);
            }
            this.pageNum = rec.getPage().getPageNum();
            this.page = rec.getPage();
            this.offset = rec.offset - 2;
            this.node = null;
            return true;
        }
        if (StorageAddress.hasAddress(this.startAddress)) {
            RecordPos rec = this.db.findRecord(this.startAddress);
            if (rec == null) {
                throw new IOException("Node not found at specified address.");
            }
            this.pageNum = rec.getPage().getPageNum();
            this.offset = rec.offset - 2;
            this.page = rec.getPage();
            this.startAddress = -1L;
            return true;
        }
        if (this.pageNum != -1L) {
            this.page = this.db.getDOMPage(this.pageNum);
            this.db.addToBuffer(this.page);
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new RuntimeException("remove() method not implemented");
    }

    public void setTo(long address) {
        this.startAddress = address;
    }

    @Override
    public void close() throws IOException {
    }
}

