/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.storage.DBBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.IRawNodeIterator;
import org.exist.storage.dom.ItemId;
import org.exist.storage.dom.RecordPos;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteConversion;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.sanity.SanityCheck;

public class RawNodeIterator
implements IRawNodeIterator {
    private static final Logger LOG = LogManager.getLogger(RawNodeIterator.class);
    private DBBroker broker;
    private final DOMFile db;
    private int offset;
    private short lastTupleID = (short)-1;
    private DOMFile.DOMPage page = null;
    private long pageNum;

    public RawNodeIterator(DBBroker broker, DOMFile db, NodeHandle node) throws IOException {
        this.broker = broker;
        this.db = db;
        this.seek(node);
    }

    @Override
    public final void seek(NodeHandle node) throws IOException {
        Lock lock = this.db.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            RecordPos rec = null;
            if (StorageAddress.hasAddress(node.getInternalAddress())) {
                rec = this.db.findRecord(node.getInternalAddress());
            }
            if (rec == null) {
                try {
                    long address = this.db.findValue(this.broker, new NodeProxy(node));
                    if (address == -1L) {
                        throw new IOException("Node not found.");
                    }
                    rec = this.db.findRecord(address);
                }
                catch (BTreeException e) {
                    throw new IOException("Node not found: " + e.getMessage());
                }
            }
            this.pageNum = rec.getPage().getPageNum();
            this.offset = rec.offset - 2;
            this.page = rec.getPage();
        }
        catch (LockException e) {
            throw new IOException("Exception while scanning document: " + e.getMessage());
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value next() {
        Value nextValue = null;
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire(Lock.LockMode.READ_LOCK);
            }
            catch (LockException e) {
                LOG.error("Failed to acquire read lock on " + FileUtils.fileName(this.db.getFile()));
                Value value = null;
                lock.release(Lock.LockMode.READ_LOCK);
                return value;
            }
            this.db.setOwnerObject(this.broker);
            long backLink = 0L;
            do {
                DOMFile.DOMFilePageHeader pageHeader;
                if (this.offset >= (pageHeader = this.page.getPageHeader()).getDataLength()) {
                    long nextPage = pageHeader.getNextDataPage();
                    if (nextPage == -1L) {
                        SanityCheck.TRACE("Bad link to next page " + this.page.page.getPageInfo() + "; previous: " + pageHeader.getPreviousDataPage() + "; offset = " + this.offset + "; lastTupleID = " + this.lastTupleID);
                        Value value = null;
                        return value;
                    }
                    this.pageNum = nextPage;
                    this.page = this.db.getDOMPage(nextPage);
                    this.db.addToBuffer(this.page);
                    this.offset = 0;
                }
                this.lastTupleID = ByteConversion.byteToShort(this.page.data, this.offset);
                this.offset += 2;
                if (ItemId.isLink(this.lastTupleID)) {
                    this.offset += 8;
                    continue;
                }
                int valueLength = ByteConversion.byteToShort(this.page.data, this.offset);
                this.offset += 2;
                if (valueLength < 0) {
                    LOG.error("Got negative length" + valueLength + " at offset " + this.offset + "!!!");
                    LOG.debug(this.db.debugPageContents(this.page));
                }
                if (ItemId.isRelocated(this.lastTupleID)) {
                    backLink = ByteConversion.byteToLong(this.page.data, this.offset);
                    this.offset += 8;
                }
                if (valueLength == 0) {
                    valueLength = 8;
                    long overflow = ByteConversion.byteToLong(this.page.data, this.offset);
                    this.offset += 8;
                    try {
                        byte[] odata = this.db.getOverflowValue(overflow);
                        nextValue = new Value(odata);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while loading overflow value: " + e.getMessage() + "; originating page: " + this.page.page.getPageInfo());
                    }
                } else {
                    try {
                        nextValue = new Value(this.page.data, this.offset, valueLength);
                        this.offset += valueLength;
                    }
                    catch (Exception e) {
                        LOG.error("Error while deserializing node: " + e.getMessage(), (Throwable)e);
                        LOG.error("Reading from offset: " + this.offset + "; len = " + valueLength);
                        LOG.debug(this.db.debugPageContents(this.page));
                        throw new RuntimeException(e);
                    }
                }
                if (nextValue == null) {
                    LOG.error("illegal node on page " + this.page.getPageNum() + "; tupleID = " + ItemId.getId(this.lastTupleID) + "; next = " + this.page.getPageHeader().getNextDataPage() + "; prev = " + this.page.getPageHeader().getPreviousDataPage() + "; offset = " + (this.offset - valueLength) + "; len = " + this.page.getPageHeader().getDataLength());
                    Value value = null;
                    return value;
                }
                if (ItemId.isRelocated(this.lastTupleID)) {
                    nextValue.setAddress(backLink);
                    continue;
                }
                nextValue.setAddress(StorageAddress.createPointer((int)this.pageNum, ItemId.getId(this.lastTupleID)));
            } while (nextValue == null);
            Value value = nextValue;
            return value;
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    @Override
    public void close() {
        this.db.closeDocument();
    }

    public long currentAddress() {
        return StorageAddress.createPointer((int)this.pageNum, ItemId.getId(this.lastTupleID));
    }
}

