/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RemoveEmptyPageLoggable
extends AbstractLoggable {
    private DOMFile domDb;
    protected long pageNum;
    protected long prevPage;
    protected long nextPage;

    public RemoveEmptyPageLoggable(Txn transaction, long pageNum, long prevPage, long nextPage) {
        super((byte)19, transaction.getId());
        this.pageNum = pageNum;
        this.prevPage = prevPage;
        this.nextPage = nextPage;
    }

    public RemoveEmptyPageLoggable(DBBroker broker, long transactionId) {
        super((byte)19, transactionId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    @Override
    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putInt((int)this.prevPage);
        out.putInt((int)this.nextPage);
    }

    @Override
    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.prevPage = in.getInt();
        this.nextPage = in.getInt();
    }

    @Override
    public int getLogSize() {
        return 12;
    }

    @Override
    public void redo() throws LogException {
        this.domDb.redoRemoveEmptyPage(this);
    }

    @Override
    public void undo() throws LogException {
        this.domDb.undoRemoveEmptyPage(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - removed page " + this.pageNum;
    }
}

