/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RemovePageLoggable
extends AbstractLoggable {
    private DOMFile domDb;
    protected long pageNum;
    protected long prevPage;
    protected long nextPage;
    protected byte[] oldData;
    protected int oldLen;
    protected short oldTid;
    protected short oldRecCnt;

    public RemovePageLoggable(Txn transaction, long pageNum, long prevPage, long nextPage, byte[] oldData, int oldLen, short oldTid, short oldRecCnt) {
        super((byte)21, transaction.getId());
        this.pageNum = pageNum;
        this.prevPage = prevPage;
        this.nextPage = nextPage;
        this.oldData = oldData;
        this.oldLen = oldLen;
        this.oldTid = oldTid;
        this.oldRecCnt = oldRecCnt;
    }

    public RemovePageLoggable(DBBroker broker, long transactionId) {
        super((byte)21, transactionId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    @Override
    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putInt((int)this.prevPage);
        out.putInt((int)this.nextPage);
        out.putShort(this.oldTid);
        out.putShort(this.oldRecCnt);
        out.putShort((short)this.oldLen);
        out.put(this.oldData, 0, this.oldLen);
    }

    @Override
    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.prevPage = in.getInt();
        this.nextPage = in.getInt();
        this.oldTid = in.getShort();
        this.oldRecCnt = in.getShort();
        this.oldLen = in.getShort();
        this.oldData = new byte[this.domDb.getFileHeader().getWorkSize()];
        in.get(this.oldData, 0, this.oldLen);
    }

    @Override
    public int getLogSize() {
        return 18 + this.oldLen;
    }

    @Override
    public void redo() throws LogException {
        this.domDb.redoRemovePage(this);
    }

    @Override
    public void undo() throws LogException {
        this.domDb.undoRemovePage(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - removed page " + this.pageNum;
    }
}

