/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class UpdateLinkLoggable
extends AbstractLoggable {
    protected long pageNum;
    protected int offset;
    protected long link;
    protected long oldLink;
    private DOMFile domDb = null;

    public UpdateLinkLoggable(Txn transaction, long pageNum, int offset, long link, long oldLink) {
        super((byte)29, transaction.getId());
        this.pageNum = pageNum;
        this.offset = offset;
        this.link = link;
        this.oldLink = oldLink;
    }

    public UpdateLinkLoggable(DBBroker broker, long transactId) {
        super((byte)29, transactId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    @Override
    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putShort((short)this.offset);
        out.putLong(this.link);
        out.putLong(this.oldLink);
    }

    @Override
    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.offset = in.getShort();
        this.link = in.getLong();
        this.oldLink = in.getLong();
    }

    @Override
    public int getLogSize() {
        return 22;
    }

    @Override
    public void redo() throws LogException {
        this.domDb.redoUpdateLink(this);
    }

    @Override
    public void undo() throws LogException {
        this.domDb.undoUpdateLink(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - updated link on page: " + this.pageNum + " at offset: " + this.offset;
    }
}

