/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Stack;
import org.exist.storage.BrokerPool;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.Value;
import org.exist.storage.index.BFile;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.UTF8;

public class CollectionStore
extends BFile {
    public static final String FILE_NAME = "collections.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.collections";
    public static final String FREE_DOC_ID_KEY = "__free_doc_id";
    public static final String NEXT_DOC_ID_KEY = "__next_doc_id";
    public static final String FREE_COLLECTION_ID_KEY = "__free_collection_id";
    public static final String NEXT_COLLECTION_ID_KEY = "__next_collection_id";
    public static final byte KEY_TYPE_COLLECTION = 0;
    public static final byte KEY_TYPE_DOCUMENT = 1;
    private Stack<Integer> freeResourceIds = new Stack();
    private Stack<Integer> freeCollectionIds = new Stack();

    public CollectionStore(BrokerPool pool, byte id, Path dataDir, Configuration config) throws DBException {
        super(pool, id, true, dataDir.resolve(CollectionStore.getFileName()), pool.getCacheManager(), 1.25, 0.03);
        config.setProperty(CollectionStore.getConfigKeyForFile(), this);
    }

    public static String getFileName() {
        return FILE_NAME;
    }

    public static String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    @Override
    protected long getDataSyncPeriod() {
        return 1000L;
    }

    @Override
    public boolean flush() throws DBException {
        boolean flushed = false;
        if (!BrokerPool.FORCE_CORRUPTION) {
            flushed |= this.dataCache.flush();
            flushed |= super.flush();
        }
        return flushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeResourceId(int id) {
        Lock lock = this.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.freeResourceIds.push(id);
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.getFile()), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeResourceId() {
        int freeDocId = -1;
        Lock lock = this.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            if (!this.freeResourceIds.isEmpty()) {
                freeDocId = this.freeResourceIds.pop();
            }
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.getFile()), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
        return freeDocId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCollectionId(int id) {
        Lock lock = this.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.freeCollectionIds.push(id);
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.getFile()), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeCollectionId() {
        int freeCollectionId = -1;
        Lock lock = this.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            if (!this.freeCollectionIds.isEmpty()) {
                freeCollectionId = this.freeCollectionIds.pop();
            }
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock on " + FileUtils.fileName(this.getFile()), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
        return freeCollectionId;
    }

    protected void dumpValue(Writer writer, Value value) throws IOException {
        if (value.getLength() == 9) {
            short collectionId = ByteConversion.byteToShort(value.data(), value.start());
            int docId = ByteConversion.byteToInt(value.data(), value.start() + 1 + 4);
            writer.write(91);
            writer.write("Document: collection = ");
            writer.write(collectionId);
            writer.write(", docId = ");
            writer.write(docId);
            writer.write(93);
        } else {
            writer.write(91);
            writer.write("Collection: ");
            writer.write(new String(value.data(), value.start(), value.getLength(), "UTF-8"));
            writer.write(93);
        }
    }

    public static class CollectionKey
    extends Value {
        public static final int OFFSET_TYPE = 0;
        public static final int LENGTH_TYPE = 1;
        public static final int OFFSET_VALUE = 1;

        public CollectionKey() {
            this.data = new byte[1];
            this.data[0] = 0;
            this.len = 1;
        }

        public CollectionKey(String name) {
            this.len = 1 + UTF8.encoded(name);
            this.data = new byte[this.len];
            this.data[0] = 0;
            UTF8.encode(name, this.data, 1);
            this.pos = 0;
        }
    }

    public static class DocumentKey
    extends Value {
        public static final int OFFSET_TYPE = 0;
        public static final int LENGTH_TYPE = 1;
        public static final int OFFSET_COLLECTION_ID = 1;
        public static final int LENGTH_TYPE_DOCUMENT = 2;
        public static final int OFFSET_DOCUMENT_TYPE = 5;
        public static final int LENGTH_DOCUMENT_TYPE = 1;
        public static final int OFFSET_DOCUMENT_ID = 6;

        public DocumentKey() {
            this.data = new byte[1];
            this.data[0] = 1;
            this.len = 1;
        }

        public DocumentKey(int collectionId) {
            this.data = new byte[5];
            this.data[0] = 1;
            ByteConversion.intToByte(collectionId, this.data, 1);
            this.len = 5;
            this.pos = 0;
        }

        public DocumentKey(int collectionId, byte type, int docId) {
            this.data = new byte[10];
            this.data[0] = 1;
            ByteConversion.intToByte(collectionId, this.data, 1);
            this.data[5] = type;
            ByteConversion.intToByte(docId, this.data, 6);
            this.len = 10;
            this.pos = 0;
        }

        public static int getCollectionId(Value key) {
            return ByteConversion.byteToInt(key.data(), key.start() + 1);
        }

        public static int getDocumentId(Value key) {
            return ByteConversion.byteToInt(key.data(), key.start() + 6);
        }
    }
}

