/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArray;
import org.exist.util.FixedByteArray;

public class OverflowAppendLoggable
extends AbstractBFileLoggable {
    protected long pageNum;
    protected ByteArray data;
    protected int chunkSize;
    protected int startOffset;

    public OverflowAppendLoggable(byte fileId, Txn transaction, long page, ByteArray chunk, int startOffset, int chunkSize) {
        super((byte)52, fileId, transaction);
        this.pageNum = page;
        this.data = chunk;
        this.chunkSize = chunkSize;
        this.startOffset = startOffset;
    }

    public OverflowAppendLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
        out.putInt(this.chunkSize);
        this.data.copyTo(this.startOffset, out, this.chunkSize);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
        this.chunkSize = in.getInt();
        byte[] b = new byte[this.chunkSize];
        in.get(b);
        this.data = new FixedByteArray(b);
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 8 + this.chunkSize;
    }

    @Override
    public void redo() throws LogException {
        this.getIndexFile().redoAppendOverflow(this);
    }

    @Override
    public void undo() throws LogException {
        this.getIndexFile().undoAppendOverflow(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - append to overflow page " + this.pageNum;
    }
}

