/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArray;
import org.exist.util.FixedByteArray;

public class StoreValueLoggable
extends AbstractBFileLoggable {
    protected long page;
    protected short tid;
    protected ByteArray value;

    public StoreValueLoggable(Txn transaction, byte fileId, long page, short tid, ByteArray value) {
        super((byte)49, fileId, transaction);
        this.page = page;
        this.tid = tid;
        this.value = value;
    }

    public StoreValueLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.page);
        out.putShort(this.tid);
        out.putShort((short)this.value.size());
        this.value.copyTo(out);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.page = in.getInt();
        this.tid = in.getShort();
        short len = in.getShort();
        byte[] data = new byte[len];
        in.get(data);
        this.value = new FixedByteArray(data, 0, len);
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 8 + this.value.size();
    }

    @Override
    public void redo() throws LogException {
        this.getIndexFile().redoStoreValue(this);
    }

    @Override
    public void undo() throws LogException {
        this.getIndexFile().undoStoreValue(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - stored value with tid " + this.tid + " on page " + this.page;
    }
}

