/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.io;

import java.io.IOException;
import java.io.InputStream;
import org.exist.storage.io.BlockingOutputStream;

public class BlockingInputStream
extends InputStream {
    private static final int EOS = -1;
    private static final int CAPACITY = 8192;
    private static final int SIZE = 8193;
    private byte[] buffer = new byte[8193];
    private int head;
    private int tail;
    private boolean inClosed;
    private boolean outClosed;
    private Exception inException;
    private Exception outException;
    private BlockingOutputStream bos = new BlockingOutputStream(this);

    public BlockingOutputStream getOutputStream() {
        return this.bos;
    }

    private boolean closed() {
        return this.inClosed || this.outClosed;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] bb = new byte[1];
        return this.read(bb, 0, 1) == -1 ? -1 : bb[0];
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int count = -1;
        try {
            while (this.empty() && !this.closed()) {
                this.wait();
            }
            if (this.outException != null) {
                throw new IOException("BlockingOutputStream closed with an exception.", this.outException);
            }
            if (!this.closed()) {
                count = Math.min(len, this.available());
                int count1 = Math.min(count, this.availablePart1());
                System.arraycopy(this.buffer, this.head, b, off, count1);
                int count2 = count - count1;
                if (count2 > 0) {
                    System.arraycopy(this.buffer, 0, b, off + count1, count2);
                }
                this.head = BlockingInputStream.next(this.head, count);
                if (this.empty()) {
                    this.tail = 0;
                    this.head = 0;
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Read operation interrupted.", e);
        }
        finally {
            this.notifyAll();
        }
        return count;
    }

    @Override
    public synchronized void close() {
        this.inClosed = true;
        this.buffer = null;
        this.notifyAll();
    }

    public synchronized void close(Exception ex) {
        this.inException = ex;
        this.close();
    }

    @Override
    public synchronized int available() {
        return (this.tail - this.head + 8193) % 8193;
    }

    private int availablePart1() {
        return this.tail >= this.head ? this.tail - this.head : 8193 - this.head;
    }

    private int availablePart2() {
        return this.tail >= this.head ? 0 : this.tail;
    }

    synchronized void writeOutputStream(int b) throws IOException {
        byte[] bb = new byte[]{(byte)b};
        this.writeOutputStream(bb, 0, 1);
    }

    synchronized void writeOutputStream(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int count;
            try {
                while (this.full() && !this.closed()) {
                    this.wait();
                }
                if (this.inException != null) {
                    throw new IOException("BlockingInputStream closed with exception.", this.inException);
                }
                if (this.closed()) {
                    throw new IOException("Writing to closed stream", this.inException);
                }
                count = Math.min(len, this.free());
                int count1 = Math.min(count, this.freePart1());
                System.arraycopy(b, off, this.buffer, this.tail, count1);
                int count2 = count - count1;
                if (count2 > 0) {
                    System.arraycopy(b, off + count1, this.buffer, 0, count2);
                }
                this.tail = BlockingInputStream.next(this.tail, count);
            }
            catch (InterruptedException e) {
                throw new IOException("Write operation interrupted.", e);
            }
            finally {
                this.notifyAll();
            }
            off += count;
            len -= count;
        }
    }

    synchronized void closeOutputStream() throws IOException {
        if (this.outException == null) {
            this.flushOutputStream();
        }
        this.outClosed = true;
        this.notifyAll();
        try {
            while (!this.inClosed) {
                this.wait();
            }
            if (this.inException != null) {
                throw new IOException("BlockingInputStream closed with an exception.", this.inException);
            }
            if (!this.empty()) {
                throw new IOException("Closing non empty closed stream.", this.inException);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Close OutputStream operation interrupted.", e);
        }
    }

    synchronized void closeOutputStream(Exception ex) throws IOException {
        this.outException = ex;
        this.closeOutputStream();
    }

    synchronized void flushOutputStream() throws IOException {
        try {
            while (!this.empty() && !this.closed()) {
                this.wait();
            }
            if (this.inException != null) {
                throw new IOException("BlockingInputStream closed with an exception.", this.inException);
            }
            if (!this.empty()) {
                throw new IOException("Flushing non empty closed stream.", this.inException);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Flush operation interrupted.", e);
        }
        finally {
            this.notifyAll();
        }
    }

    private synchronized int free() {
        int prevhead = BlockingInputStream.prev(this.head);
        return (prevhead - this.tail + 8193) % 8193;
    }

    private int freePart1() {
        int prevhead = BlockingInputStream.prev(this.head);
        return prevhead >= this.tail ? prevhead - this.tail : 8193 - this.tail;
    }

    private int freePart2() {
        int prevhead = BlockingInputStream.prev(this.head);
        return prevhead >= this.tail ? 0 : prevhead;
    }

    private boolean empty() {
        return this.head == this.tail;
    }

    private boolean full() {
        return BlockingInputStream.next(this.tail) == this.head;
    }

    private static int next(int pos) {
        return BlockingInputStream.next(pos, 1);
    }

    private static int next(int pos, int incr) {
        return (pos + incr) % 8193;
    }

    private static int prev(int pos) {
        return BlockingInputStream.prev(pos, 1);
    }

    private static int prev(int pos, int decr) {
        return (pos - decr + 8193) % 8193;
    }
}

