/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.exist.util.ByteArray;
import org.exist.util.FastByteBuffer;

public class VariableByteOutputStream
extends OutputStream {
    private static final int MAX_BUFFER_SIZE = 65536;
    private FastByteBuffer buf;
    private final byte[] temp = new byte[5];

    public VariableByteOutputStream() {
        this.buf = new FastByteBuffer(9);
    }

    public VariableByteOutputStream(int size) {
        this.buf = new FastByteBuffer(size);
    }

    public void clear() {
        if (this.buf.size() > 65536) {
            this.buf = new FastByteBuffer(9);
        } else {
            this.buf.setLength(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.buf = null;
    }

    public int size() {
        return this.buf.length();
    }

    @Override
    public void flush() throws IOException {
    }

    public int position() {
        return this.buf.size();
    }

    public byte[] toByteArray() {
        byte[] b = new byte[this.buf.size()];
        this.buf.copyTo(b, 0);
        return b;
    }

    public ByteArray data() {
        return this.buf;
    }

    @Override
    public void write(int b) throws IOException {
        this.buf.append((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.buf.append(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buf.append(b, off, len);
    }

    public void write(ByteArray b) {
        b.copyTo(this.buf);
    }

    public void writeByte(byte b) {
        this.buf.append(b);
    }

    public void writeShort(int s) {
        while ((s & 0xFFFFFF80) != 0) {
            this.buf.append((byte)(s & 0x7F | 0x80));
            s >>>= 7;
        }
        this.buf.append((byte)s);
    }

    public void writeInt(int i) {
        int count = 0;
        while ((i & 0xFFFFFF80) != 0) {
            this.temp[count++] = (byte)(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.temp[count++] = (byte)i;
        this.buf.append(this.temp, 0, count);
    }

    public void writeFixedInt(int i) {
        this.temp[0] = (byte)(i >>> 0 & 0xFF);
        this.temp[1] = (byte)(i >>> 8 & 0xFF);
        this.temp[2] = (byte)(i >>> 16 & 0xFF);
        this.temp[3] = (byte)(i >>> 24 & 0xFF);
        this.buf.append(this.temp, 0, 4);
    }

    public void writeFixedInt(int position, int i) {
        this.buf.set(position, (byte)(i >>> 0 & 0xFF));
        this.buf.set(position + 1, (byte)(i >>> 8 & 0xFF));
        this.buf.set(position + 2, (byte)(i >>> 16 & 0xFF));
        this.buf.set(position + 3, (byte)(i >>> 24 & 0xFF));
    }

    public void writeInt(int position, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            this.buf.set(position++, (byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.buf.set(position, (byte)i);
    }

    public void writeLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.buf.append((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
        this.buf.append((byte)l);
    }

    public void writeFixedLong(long l) {
        this.buf.append((byte)(l >>> 56 & 0xFFL));
        this.buf.append((byte)(l >>> 48 & 0xFFL));
        this.buf.append((byte)(l >>> 40 & 0xFFL));
        this.buf.append((byte)(l >>> 32 & 0xFFL));
        this.buf.append((byte)(l >>> 24 & 0xFFL));
        this.buf.append((byte)(l >>> 16 & 0xFFL));
        this.buf.append((byte)(l >>> 8 & 0xFFL));
        this.buf.append((byte)(l >>> 0 & 0xFFL));
    }

    public void writeUTF(String s) throws IOException {
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        this.writeInt(data.length);
        this.write(data, 0, data.length);
    }
}

