/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.journal;

import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileSyncThread
extends Thread {
    private FileChannel endOfLog;
    private final Object latch;
    private boolean syncTriggered = false;
    private volatile boolean shutdown = false;

    public FileSyncThread(Object latch) {
        super("exist-fileSyncThread");
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannel(FileChannel channel) {
        Object object = this.latch;
        synchronized (object) {
            this.endOfLog = channel;
        }
    }

    public synchronized void triggerSync() {
        this.syncTriggered = true;
        this.notifyAll();
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel() {
        Object object = this.latch;
        synchronized (object) {
            if (this.endOfLog != null) {
                try {
                    this.endOfLog.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            FileSyncThread fileSyncThread = this;
            synchronized (fileSyncThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.syncTriggered) {
                    this.sync();
                }
            }
        }
        this.sync();
        this.closeChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        Object object = this.latch;
        synchronized (object) {
            if (this.endOfLog != null) {
                try {
                    this.endOfLog.force(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.syncTriggered = false;
        }
    }
}

