/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.journal;

import java.util.function.BiFunction;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.txn.Checkpoint;
import org.exist.storage.txn.TxnAbort;
import org.exist.storage.txn.TxnCommit;
import org.exist.storage.txn.TxnStart;
import org.exist.util.hashtable.Int2ObjectHashMap;

public class LogEntryTypes {
    public static final byte TXN_START = 0;
    public static final byte TXN_COMMIT = 1;
    public static final byte CHECKPOINT = 2;
    public static final byte TXN_ABORT = 3;
    private static final Int2ObjectHashMap<BiFunction<DBBroker, Long, Loggable>> entryTypes = new Int2ObjectHashMap();

    public static final void addEntryType(byte type, BiFunction<DBBroker, Long, Loggable> cstr) {
        entryTypes.put(type, cstr);
    }

    public static final Loggable create(byte type, DBBroker broker, long transactionId) throws LogException {
        BiFunction<DBBroker, Long, Loggable> cstr = entryTypes.get(type);
        if (cstr == null) {
            return null;
        }
        return cstr.apply(broker, transactionId);
    }

    static {
        entryTypes.put(0, TxnStart::new);
        entryTypes.put(1, TxnCommit::new);
        entryTypes.put(2, Checkpoint::new);
        entryTypes.put(3, TxnAbort::new);
    }
}

