/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockInfo;
import org.exist.storage.lock.MultiReadReentrantLock;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.lock.WaitingThread;

public class DeadlockDetection {
    private static final Logger LOG = LogManager.getLogger(DeadlockDetection.class);
    private static final Map<Thread, WaitingThread> waitForResource = new HashMap<Thread, WaitingThread>();
    private static final Map<Thread, Lock> waitForCollection = new HashMap<Thread, Lock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceWaiter(Thread thread, WaitingThread waiter) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            waitForResource.put(thread, waiter);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock clearResourceWaiter(Thread thread) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            WaitingThread waiter = waitForResource.remove(thread);
            if (waiter != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return waiter.getLock();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaitingThread getResourceWaiter(Thread thread) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return waitForResource.get(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaitingThread deadlockCheckResource(Thread threadA, Thread threadB) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            WaitingThread waitingThread = waitForResource.get(threadB);
            if (waitingThread != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return waitingThread.getLock().hasLock(threadA) ? waitingThread : null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBlockedBy(Thread threadA, Thread threadB) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            WaitingThread waitingThread = waitForResource.get(threadB);
            if (waitingThread != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return waitingThread.getLock().hasLock(threadA);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wouldDeadlock(Thread waiter, Thread owner, List<WaitingThread> waiters) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            WaitingThread wt = waitForResource.get(owner);
            if (wt != null) {
                if (waiters.contains(wt)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                waiters.add(wt);
                Lock l = wt.getLock();
                Thread t = ((MultiReadReentrantLock)l).getWriteLockedThread();
                if (t == owner) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                if (t != null) {
                    if (t == waiter) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return DeadlockDetection.wouldDeadlock(waiter, t, waiters);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            Lock l = waitForCollection.get(owner);
            if (l != null) {
                Thread t = ((ReentrantReadWriteLock)l).getOwner();
                if (t == owner) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                if (t != null) {
                    if (t == waiter) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return DeadlockDetection.wouldDeadlock(waiter, t, waiters);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCollectionWaiter(Thread waiter, Lock lock) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            waitForCollection.put(waiter, lock);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock clearCollectionWaiter(Thread waiter) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return waitForCollection.remove(waiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock isWaitingFor(Thread waiter) {
        Class<DeadlockDetection> clazz = DeadlockDetection.class;
        synchronized (DeadlockDetection.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return waitForCollection.get(waiter);
        }
    }

    public static Map<String, LockInfo> getWaitingThreads() {
        HashMap<String, LockInfo> table = new HashMap<String, LockInfo>();
        for (WaitingThread waitingThread : waitForResource.values()) {
            table.put(waitingThread.getThread().getName(), waitingThread.getLock().getLockInfo());
        }
        for (Map.Entry entry : waitForCollection.entrySet()) {
            table.put(((Thread)entry.getKey()).getName(), ((Lock)entry.getValue()).getLockInfo());
        }
        return table;
    }

    public static void debug(String name, LockInfo info) {
        try (StringWriter sout = new StringWriter();
             PrintWriter writer = new PrintWriter(sout);){
            DeadlockDetection.debug(writer, name, info);
            System.out.println(sout.toString());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void debug(PrintWriter writer, String name, LockInfo info) {
        writer.println("Thread: " + name);
        if (info != null) {
            writer.format("%20s: %s\n", "Lock type", info.getLockType());
            writer.format("%20s: %s\n", "Lock mode", info.getLockMode());
            writer.format("%20s: %s\n", "Lock id", info.getId());
            writer.format("%20s: %s\n", "Held by", Arrays.toString(info.getOwners()));
            writer.format("%20s: %s\n", "Held by", Arrays.toString(info.getOwners()));
            writer.format("%20s: %s\n", "Held by", Arrays.toString(info.getOwners()));
            writer.format("%20s: %s\n", "Waiting for read", Arrays.toString(info.getWaitingForRead()));
            writer.format("%20s: %s\n\n", "Waiting for write", Arrays.toString(info.getWaitingForWrite()));
        }
    }

    public static void debug(PrintWriter writer) {
        writer.println("Threads currently waiting for a lock:");
        writer.println("=====================================");
        Map<String, LockInfo> threads = DeadlockDetection.getWaitingThreads();
        for (Map.Entry<String, LockInfo> entry : threads.entrySet()) {
            DeadlockDetection.debug(writer, entry.getKey(), entry.getValue());
        }
    }
}

