/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.lock.FileLock;
import org.exist.util.Configuration;
import org.exist.util.ReadOnlyException;

public class FileLockService
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(FileLockService.class);
    private final String lockFileName;
    private final String confDirPropName;
    private final String defaultDirName;
    private Path dataDir;
    private boolean writable;
    private AtomicReference<FileLock> dataLock = new AtomicReference();

    public FileLockService(String lockFileName, String confDirPropName, String defaultDirName) {
        this.lockFileName = lockFileName;
        this.confDirPropName = confDirPropName;
        this.defaultDirName = defaultDirName;
    }

    @Override
    public void configure(Configuration configuration) throws BrokerPoolServiceException {
        this.dataDir = Optional.ofNullable((Path)configuration.getProperty(this.confDirPropName)).orElse(Paths.get(this.defaultDirName, new String[0]));
        if (!Files.exists(this.dataDir, new LinkOption[0])) {
            try {
                LOG.info("Data directory '" + this.dataDir.toAbsolutePath().toString() + "' does not exist. Creating one ...");
                Files.createDirectories(this.dataDir, new FileAttribute[0]);
            }
            catch (IOException | SecurityException e) {
                throw new BrokerPoolServiceException("Cannot create data directory '" + this.dataDir.toAbsolutePath().toString() + "'", e);
            }
        }
        configuration.setProperty(this.confDirPropName, this.dataDir);
        if (!Files.isWritable(this.dataDir)) {
            LOG.warn("Cannot write to data directory: " + this.dataDir.toAbsolutePath().toString());
            this.writable = false;
        } else {
            this.writable = true;
        }
    }

    @Override
    public void prepare(BrokerPool brokerPool) throws BrokerPoolServiceException {
        FileLock fileLock = new FileLock(brokerPool, this.dataDir.resolve(this.lockFileName));
        this.dataLock.compareAndSet(null, fileLock);
        try {
            boolean locked = fileLock.tryLock();
            if (!locked) {
                throw new BrokerPoolServiceException(new EXistException("The directory seems to be locked by another database instance. Found a valid lock file: " + fileLock.getFile().toAbsolutePath().toString()));
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)e);
            this.writable = false;
        }
        if (!this.writable) {
            brokerPool.setReadOnly();
        }
    }

    public boolean isReadOnly() {
        return !this.writable;
    }

    public Path getFile() {
        FileLock fileLock = this.dataLock.get();
        if (fileLock == null) {
            return null;
        }
        return fileLock.getFile();
    }

    public void release() {
        FileLock fileLock = this.dataLock.get();
        if (fileLock != null) {
            fileLock.release();
        }
        this.dataLock.compareAndSet(fileLock, null);
    }
}

