/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.io.PrintStream;
import java.util.Arrays;
import org.exist.Debuggable;

public class LockInfo
implements Debuggable {
    public static final String COLLECTION_LOCK = "COLLECTION";
    public static final String RESOURCE_LOCK = "RESOURCE";
    public static final String READ_LOCK = "READ";
    public static final String WRITE_LOCK = "WRITE";
    private String lockType;
    private String lockMode;
    private String id;
    private String[] owners;
    private String[] waitingForWrite = new String[0];
    private String[] waitingForRead = new String[0];
    private String[] readLocks = new String[0];

    public LockInfo(String lockType, String lockMode, String id, String[] owners) {
        this.lockType = lockType;
        this.lockMode = lockMode;
        this.id = id;
        this.owners = owners;
    }

    public String getLockType() {
        return this.lockType;
    }

    public String getLockMode() {
        return this.lockMode;
    }

    public String getId() {
        return this.id;
    }

    public String[] getOwners() {
        return this.owners;
    }

    public String[] getWaitingForWrite() {
        return this.waitingForWrite;
    }

    public void setWaitingForWrite(String[] waitingForWrite) {
        this.waitingForWrite = waitingForWrite;
    }

    public String[] getWaitingForRead() {
        return this.waitingForRead;
    }

    public void setWaitingForRead(String[] waitingForRead) {
        this.waitingForRead = waitingForRead;
    }

    public String[] getReadLocks() {
        return this.readLocks;
    }

    public void setReadLocks(String[] readLocks) {
        this.readLocks = readLocks;
    }

    @Override
    public void debug(PrintStream out) {
        out.println("Lock type: " + this.getLockType());
        out.println("Lock mode: " + this.getLockMode());
        out.println("Lock id: " + this.getId());
        out.println("Held by: " + Arrays.toString(this.getOwners()));
        out.println("Read locks: " + Arrays.toString(this.getReadLocks()));
        out.println("Wait for read: " + Arrays.toString(this.getWaitingForRead()));
        out.println("Wait for write: " + Arrays.toString(this.getWaitingForWrite()));
    }
}

