/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import net.jcip.annotations.NotThreadSafe;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.storage.lock.Lock;
import org.exist.util.hashtable.Int2ObjectHashMap;

@NotThreadSafe
public class LockedDocumentMap
extends Int2ObjectHashMap<Object> {
    private static final int DEFAULT_SIZE = 29;
    private static final double DEFAULT_GROWTH = 1.75;

    public LockedDocumentMap() {
        super(29, 1.75);
    }

    public void add(DocumentImpl document) {
        LockedDocument entry = (LockedDocument)this.get(document.getDocId());
        if (entry == null) {
            entry = new LockedDocument(document);
            this.put(document.getDocId(), entry);
        }
        entry.locksAcquired++;
    }

    public MutableDocumentSet toDocumentSet() {
        DefaultDocumentSet docs = new DefaultDocumentSet(this.size());
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            LockedDocument lockedDocument = (LockedDocument)this.values[idx];
            docs.add(lockedDocument.document);
        }
        return docs;
    }

    public DocumentSet getDocsByCollection(Collection collection, MutableDocumentSet targetSet) {
        if (targetSet == null) {
            targetSet = new DefaultDocumentSet(this.size());
        }
        for (int idx = 0; idx < this.tabSize; ++idx) {
            LockedDocument lockedDocument;
            if (this.values[idx] == null || this.values[idx] == REMOVED || !(lockedDocument = (LockedDocument)this.values[idx]).document.getCollection().getURI().startsWith(collection.getURI())) continue;
            targetSet.add(lockedDocument.document);
        }
        return targetSet;
    }

    public void unlock() {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            LockedDocument lockedDocument = (LockedDocument)this.values[idx];
            this.unlockDocument(lockedDocument);
        }
    }

    public LockedDocumentMap unlockSome(DocumentSet keep) {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            LockedDocument lockedDocument;
            if (this.values[idx] == null || this.values[idx] == REMOVED || keep.contains((lockedDocument = (LockedDocument)this.values[idx]).document.getDocId())) continue;
            this.values[idx] = REMOVED;
            this.unlockDocument(lockedDocument);
        }
        return this;
    }

    private void unlockDocument(LockedDocument lockedDocument) {
        Lock documentLock = lockedDocument.document.getUpdateLock();
        documentLock.release(Lock.LockMode.WRITE_LOCK, lockedDocument.locksAcquired);
    }

    private static class LockedDocument {
        private final DocumentImpl document;
        private int locksAcquired = 0;

        LockedDocument(DocumentImpl document) {
            this.document = document;
        }
    }
}

