/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.serializers.ChainOfReceivers;

public class ChainOfReceiversFactory {
    private static final Logger LOG = LogManager.getLogger(ChainOfReceiversFactory.class);
    private ChainOfReceivers first = null;
    private ChainOfReceivers last = null;

    public ChainOfReceiversFactory(List<String> classes) {
        for (String className : classes) {
            try {
                Class<?> listenerClass = Class.forName(className);
                if (ChainOfReceivers.class.isAssignableFrom(listenerClass)) {
                    ChainOfReceivers listener = (ChainOfReceivers)listenerClass.newInstance();
                    if (this.first == null) {
                        this.first = listener;
                        this.last = listener;
                        continue;
                    }
                    this.last.setNextInChain(listener);
                    this.last = listener;
                    continue;
                }
                LOG.error("Failed to instantiate class " + listenerClass.getName() + ": it is not a subclass of ChainOfReceivers");
            }
            catch (Exception e) {
                LOG.error("An exception was caught while trying to instantiate a chain of receivers: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public ChainOfReceivers getFirst() {
        return this.first;
    }

    public ChainOfReceivers getLast() {
        return this.last;
    }
}

