/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.indexing.MatchListener;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.CustomMatchListener;
import org.exist.util.Configuration;

public class CustomMatchListenerFactory {
    private static final Logger LOG = LogManager.getLogger(CustomMatchListenerFactory.class);
    public static final String CONFIGURATION_ELEMENT = "custom-filter";
    public static final String CONFIGURATION_ATTR_CLASS = "class";
    public static final String CONFIG_MATCH_LISTENERS = "serialization.custom-match-listeners";
    private CustomMatchListener first = null;
    private CustomMatchListener last = null;

    public CustomMatchListenerFactory(DBBroker broker, Configuration config) {
        this(broker, config, null);
    }

    public CustomMatchListenerFactory(DBBroker broker, Configuration config, List<String> customClasses) {
        SequencedCollection<String> classes;
        List<String> classesAtConfig = (List<String>)config.getProperty(CONFIG_MATCH_LISTENERS);
        if (customClasses == null) {
            if (classesAtConfig == null) {
                return;
            }
            classes = classesAtConfig;
        } else if (classesAtConfig == null) {
            classes = customClasses;
        } else {
            classes = new LinkedHashSet();
            classes.addAll(classesAtConfig);
            classes.addAll(customClasses);
        }
        for (String className : classes) {
            try {
                Class<?> listenerClass = Class.forName(className);
                if (CustomMatchListener.class.isAssignableFrom(listenerClass)) {
                    CustomMatchListener listener = (CustomMatchListener)listenerClass.newInstance();
                    listener.setBroker(broker);
                    if (this.first == null) {
                        this.first = listener;
                        this.last = listener;
                        continue;
                    }
                    this.last.setNextInChain(listener);
                    this.last = listener;
                    continue;
                }
                LOG.error("Failed to instantiate class {}: it is not a subclass of CustomMatchListener", (Object)listenerClass.getName());
            }
            catch (Exception e) {
                LOG.error("An exception was caught while trying to instantiate a custom MatchListener: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public MatchListener getFirst() {
        if (this.first != null) {
            this.first.reset();
        }
        return this.first;
    }

    public MatchListener getLast() {
        return this.last;
    }
}

