/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.dom.QName;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.CDATASectionImpl;
import org.exist.dom.persistent.CommentImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.TextImpl;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.dom.INodeIterator;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Configuration;
import org.exist.util.serializer.AttrList;
import org.exist.xquery.value.Type;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NativeSerializer
extends Serializer {
    private static final QName TEXT_ELEMENT = new QName("text", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName ATTRIB_ELEMENT = new QName("attribute", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName SOURCE_ATTRIB = new QName("source", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName ID_ATTRIB = new QName("id", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName MATCHES_ATTRIB = new QName("matches", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName MATCHES_OFFSET_ATTRIB = new QName("matches-offset", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName MATCHES_LENGTH_ATTRIB = new QName("matches-length", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final Pattern P_ZERO_VALUES = Pattern.compile("0(,0)?");
    private static final Matcher M_ZERO_VALUES = P_ZERO_VALUES.matcher("");

    public NativeSerializer(DBBroker broker, Configuration config) {
        this(broker, config, null);
    }

    public NativeSerializer(DBBroker broker, Configuration config, List<String> chainOfReceivers) {
        super(broker, config, chainOfReceivers);
    }

    @Override
    protected void serializeToReceiver(NodeProxy p, boolean generateDocEvent, boolean checkAttributes) throws SAXException {
        if (Type.subTypeOf(p.getType(), 6) || p.getNodeId() == NodeId.DOCUMENT_NODE) {
            this.serializeToReceiver(p.getOwnerDocument(), generateDocEvent);
            return;
        }
        this.setDocument(p.getOwnerDocument());
        if (generateDocEvent) {
            this.receiver.startDocument();
        }
        try (INodeIterator domIter = this.broker.getNodeIterator(p);){
            this.serializeToReceiver(null, domIter, p.getOwnerDocument(), checkAttributes, p.getMatches(), new TreeSet<String>());
        }
        catch (IOException e) {
            LOG.warn("Unable to close node iterator", (Throwable)e);
        }
        if (generateDocEvent) {
            this.receiver.endDocument();
        }
    }

    @Override
    protected void serializeToReceiver(DocumentImpl doc, boolean generateDocEvent) throws SAXException {
        long start = System.currentTimeMillis();
        this.setDocument(doc);
        NodeList children = doc.getChildNodes();
        if (generateDocEvent) {
            this.receiver.startDocument();
        }
        if (doc.getDoctype() != null && "yes".equals(this.getProperty("output-doctype", "no"))) {
            DocumentTypeImpl docType = (DocumentTypeImpl)doc.getDoctype();
            this.serializeToReceiver(docType, null, docType.getOwnerDocument(), true, null, new TreeSet<String>());
        }
        for (int i = 0; i < children.getLength(); ++i) {
            IStoredNode node = (IStoredNode)children.item(i);
            try (INodeIterator domIter = this.broker.getNodeIterator(node);){
                domIter.next();
                NodeProxy p = new NodeProxy(node);
                this.serializeToReceiver(node, domIter, (DocumentImpl)node.getOwnerDocument(), true, p.getMatches(), new TreeSet<String>());
                continue;
            }
            catch (IOException ioe) {
                LOG.warn("Unable to close node iterator", (Throwable)ioe);
            }
        }
        if (generateDocEvent) {
            this.receiver.endDocument();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("serializing document " + doc.getDocId() + " (" + doc.getURI() + ") to SAX took " + (System.currentTimeMillis() - start) + " msec");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void serializeToReceiver(IStoredNode node, INodeIterator iter, DocumentImpl doc, boolean first, Match match, Set<String> namespaces) throws SAXException {
        if (node == null && iter.hasNext()) {
            node = (IStoredNode)iter.next();
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                this.receiver.setCurrentNode(node);
                defaultNS = null;
                if (((ElementImpl)node).declaresNamespacePrefixes()) {
                    i = ((ElementImpl)node).getPrefixes();
                    while (i.hasNext()) {
                        prefix = i.next();
                        if (prefix.isEmpty()) {
                            defaultNS = ((ElementImpl)node).getNamespaceForPrefix(prefix);
                            this.receiver.startPrefixMapping("", defaultNS);
                            namespaces.add(defaultNS);
                            continue;
                        }
                        uri = ((ElementImpl)node).getNamespaceForPrefix(prefix);
                        this.receiver.startPrefixMapping(prefix, uri);
                        namespaces.add(uri);
                    }
                }
                v0 = ns = defaultNS == null ? node.getNamespaceURI() : defaultNS;
                if (ns != null && ns.length() > 0 && !namespaces.contains(ns)) {
                    prefix = node.getPrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.receiver.startPrefixMapping(prefix, ns);
                }
                attribs = new AttrList();
                if (first && this.showId == 1 || this.showId == 2) {
                    attribs.addAttribute(NativeSerializer.ID_ATTRIB, node.getNodeId().toString());
                }
                if (first && this.showId > 0) {
                    attribs.addAttribute(NativeSerializer.SOURCE_ATTRIB, doc.getFileURI().toString());
                }
                children = node.getChildCount();
                child = null;
                matchAttrCdata = null;
                matchAttrOffsetsCdata = null;
                matchAttrLengthsCdata = null;
                for (count = 0; count < children; ++count) {
                    v1 = child = iter.hasNext() != false ? (IStoredNode)iter.next() : null;
                    if (child == null || child.getNodeType() != 2) break;
                    if ((this.getHighlightingMode() & 2) == 2 && match != null && child.getNodeId().equals(match.getNodeId())) {
                        if (matchAttrCdata == null) {
                            matchAttrCdata = new StringBuilder();
                            matchAttrOffsetsCdata = new StringBuilder();
                            matchAttrLengthsCdata = new StringBuilder();
                        } else {
                            matchAttrCdata.append(",");
                            matchAttrOffsetsCdata.append(",");
                            matchAttrLengthsCdata.append(",");
                        }
                        matchAttrCdata.append(child.getQName().toString());
                        matchAttrOffsetsCdata.append(match.getOffset(0).getOffset());
                        matchAttrLengthsCdata.append(match.getOffset(0).getLength());
                        match = match.getNextMatch();
                    }
                    cdata = ((AttrImpl)child).getValue();
                    attribs.addAttribute(child.getQName(), cdata);
                    child.release();
                }
                if (matchAttrCdata != null) {
                    attribs.addAttribute(NativeSerializer.MATCHES_ATTRIB, matchAttrCdata.toString());
                    NativeSerializer.M_ZERO_VALUES.reset(matchAttrOffsetsCdata);
                    offsetsIsZero = NativeSerializer.M_ZERO_VALUES.matches();
                    NativeSerializer.M_ZERO_VALUES.reset(matchAttrLengthsCdata);
                    lengthsIsZero = NativeSerializer.M_ZERO_VALUES.matches();
                    if (!offsetsIsZero && !lengthsIsZero) {
                        attribs.addAttribute(NativeSerializer.MATCHES_OFFSET_ATTRIB, matchAttrOffsetsCdata.toString());
                        attribs.addAttribute(NativeSerializer.MATCHES_LENGTH_ATTRIB, matchAttrLengthsCdata.toString());
                    }
                }
                this.receiver.setCurrentNode(node);
                this.receiver.startElement(node.getQName(), attribs);
                while (count < children) {
                    this.serializeToReceiver(child, iter, doc, false, match, namespaces);
                    if (++count >= children) break;
                    child = iter.hasNext() != false ? (IStoredNode)iter.next() : null;
                }
                this.receiver.setCurrentNode(node);
                this.receiver.endElement(node.getQName());
                if (((ElementImpl)node).declaresNamespacePrefixes()) {
                    i = ((ElementImpl)node).getPrefixes();
                    while (i.hasNext()) {
                        prefix = i.next();
                        this.receiver.endPrefixMapping(prefix);
                    }
                }
                if (ns != null && ns.length() > 0 && !namespaces.contains(ns)) {
                    prefix = node.getPrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.receiver.endPrefixMapping(prefix);
                }
                node.release();
                break;
            }
            case 3: {
                if (first && this.createContainerElements) {
                    tattribs = new AttrList();
                    if (this.showId > 0) {
                        tattribs.addAttribute(NativeSerializer.ID_ATTRIB, node.getNodeId().toString());
                        tattribs.addAttribute(NativeSerializer.SOURCE_ATTRIB, doc.getFileURI().toString());
                    }
                    this.receiver.startElement(NativeSerializer.TEXT_ELEMENT, tattribs);
                }
                this.receiver.setCurrentNode(node);
                this.receiver.characters(((TextImpl)node).getXMLString());
                if (first && this.createContainerElements) {
                    this.receiver.endElement(NativeSerializer.TEXT_ELEMENT);
                }
                node.release();
                break;
            }
            case 2: {
                if ((this.getHighlightingMode() & 2) != 2 || match == null || node.getNodeId().equals(match.getNodeId())) {
                    // empty if block
                }
                cdata = ((AttrImpl)node).getValue();
                if (!first) ** GOTO lbl131
                if (this.createContainerElements) {
                    tattribs = new AttrList();
                    if (this.showId > 0) {
                        tattribs.addAttribute(NativeSerializer.ID_ATTRIB, node.getNodeId().toString());
                        tattribs.addAttribute(NativeSerializer.SOURCE_ATTRIB, doc.getFileURI().toString());
                    }
                    tattribs.addAttribute(node.getQName(), cdata);
                    this.receiver.startElement(NativeSerializer.ATTRIB_ELEMENT, tattribs);
                    this.receiver.endElement(NativeSerializer.ATTRIB_ELEMENT);
                } else if (this.outputProperties.getProperty("output-method") != null && "text".equals(this.outputProperties.getProperty("output-method"))) {
                    this.receiver.characters(node.getNodeValue());
                } else {
                    NativeSerializer.LOG.warn("Error SENR0001: attribute '" + node.getQName() + "' has no parent element. While serializing document " + doc.getURI());
                    throw new SAXException("Error SENR0001: attribute '" + node.getQName() + "' has no parent element");
lbl131:
                    // 1 sources

                    this.receiver.attribute(node.getQName(), cdata);
                }
                node.release();
                break;
            }
            case 10: {
                systemId = ((DocumentTypeImpl)node).getSystemId();
                publicId = ((DocumentTypeImpl)node).getPublicId();
                name = ((DocumentTypeImpl)node).getName();
                this.receiver.documentType(name, publicId, systemId);
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstructionImpl)node).getTarget(), ((ProcessingInstructionImpl)node).getData());
                node.release();
                break;
            }
            case 8: {
                comment = ((CommentImpl)node).getData();
                data = new char[comment.length()];
                comment.getChars(0, data.length, data, 0);
                this.receiver.comment(data, 0, data.length);
                node.release();
                break;
            }
            case 4: {
                str = ((CDATASectionImpl)node).getData();
                if (first) {
                    this.receiver.characters(str);
                    break;
                }
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
                this.receiver.cdataSection(data, 0, data.length);
            }
        }
    }
}

