/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.statistics;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.IndexController;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.StreamListener;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.NodePath;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.Value;
import org.exist.storage.index.CollectionStore;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.statistics.DataGuide;
import org.exist.storage.statistics.IndexStatistics;
import org.exist.storage.statistics.NodeStats;
import org.exist.storage.txn.Txn;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.Occurrences;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.NodeList;

public class IndexStatisticsWorker
implements IndexWorker {
    private IndexStatistics index;
    private DataGuide perDocGuide = null;
    private StreamListener.ReindexMode mode = StreamListener.ReindexMode.STORE;
    private DocumentImpl currentDoc = null;
    private StatisticsListener listener = new StatisticsListener();

    public IndexStatisticsWorker(IndexStatistics index) {
        this.index = index;
    }

    @Override
    public String getIndexId() {
        return this.index.getIndexId();
    }

    @Override
    public String getIndexName() {
        return this.index.getIndexName();
    }

    @Override
    public QueryRewriter getQueryRewriter(XQueryContext context) {
        return null;
    }

    @Override
    public Object configure(IndexController controller, NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        return null;
    }

    @Override
    public void setDocument(DocumentImpl doc) {
        this.setDocument(doc, StreamListener.ReindexMode.UNKNOWN);
    }

    @Override
    public void setDocument(DocumentImpl doc, StreamListener.ReindexMode mode) {
        this.perDocGuide = new DataGuide();
        this.currentDoc = doc;
        this.mode = mode;
    }

    @Override
    public void setMode(StreamListener.ReindexMode mode) {
        this.perDocGuide = new DataGuide();
        this.mode = mode;
    }

    @Override
    public DocumentImpl getDocument() {
        return this.currentDoc;
    }

    @Override
    public StreamListener.ReindexMode getMode() {
        return this.mode;
    }

    @Override
    public <T extends IStoredNode> IStoredNode getReindexRoot(IStoredNode<T> node, NodePath path, boolean insert, boolean includeSelf) {
        return null;
    }

    @Override
    public StreamListener getListener() {
        if (this.mode == StreamListener.ReindexMode.STORE) {
            return this.listener;
        }
        return null;
    }

    @Override
    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy) {
        return null;
    }

    @Override
    public void flush() {
        if (this.perDocGuide != null) {
            this.index.mergeStats(this.perDocGuide);
        }
        this.perDocGuide = new DataGuide();
    }

    public void updateIndex(DBBroker broker) {
        this.perDocGuide = new DataGuide();
        DocumentCallback cb = new DocumentCallback(broker);
        try {
            broker.getResourcesFailsafe(cb, false);
        }
        catch (TerminatedException terminatedException) {
            // empty catch block
        }
        this.index.updateStats(this.perDocGuide);
    }

    private void updateDocument(DBBroker broker, DocumentImpl doc) {
        ElementImpl root = (ElementImpl)doc.getDocumentElement();
        try {
            NodePath path = new NodePath();
            Stack<NodeStats> stack = new Stack<NodeStats>();
            IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(root, false);
            while (reader.hasNext()) {
                int status = reader.next();
                switch (status) {
                    case 1: {
                        for (int i = 0; i < stack.size(); ++i) {
                            NodeStats next = (NodeStats)stack.elementAt(i);
                            next.incDepth();
                        }
                        QName qname = reader.getQName();
                        path.addComponent(qname);
                        NodeStats nodeStats = this.perDocGuide.add(path);
                        stack.push(nodeStats);
                        break;
                    }
                    case 2: {
                        path.removeLastComponent();
                        NodeStats stats = (NodeStats)stack.pop();
                        stats.updateMaxDepth();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeCollection(Collection collection, DBBroker broker, boolean reindex) {
    }

    @Override
    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    public Occurrences[] scanIndex(XQueryContext context, DocumentSet docs, NodeSet contextSet, Map hints) {
        return new Occurrences[0];
    }

    private class DocumentCallback
    implements BTreeCallback {
        private DBBroker broker;

        private DocumentCallback(DBBroker broker) {
            this.broker = broker;
        }

        @Override
        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            CollectionStore store = (CollectionStore)((NativeBroker)this.broker).getStorage((byte)0);
            try {
                byte type = key.data()[key.start() + 4 + 1];
                VariableByteInput istream = store.getAsStream(pointer);
                DocumentImpl doc = null;
                if (type == 0) {
                    doc = new DocumentImpl(this.broker.getBrokerPool());
                    doc.read(istream);
                    IndexStatisticsWorker.this.updateDocument(this.broker, doc);
                }
            }
            catch (Exception e) {
                IndexStatistics.LOG.warn("An error occurred while regenerating index statistics: " + e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }

    private class StatisticsListener
    extends AbstractStreamListener {
        private Stack<NodeStats> stack = new Stack();

        private StatisticsListener() {
        }

        @Override
        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            super.startElement(transaction, element, path);
            if (IndexStatisticsWorker.this.perDocGuide != null) {
                for (int i = 0; i < this.stack.size(); ++i) {
                    NodeStats next = (NodeStats)this.stack.elementAt(i);
                    next.incDepth();
                }
                NodeStats nodeStats = IndexStatisticsWorker.this.perDocGuide.add(path);
                this.stack.push(nodeStats);
            }
        }

        @Override
        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            super.endElement(transaction, element, path);
            if (IndexStatisticsWorker.this.perDocGuide != null) {
                NodeStats stats = this.stack.pop();
                stats.updateMaxDepth();
            }
        }

        @Override
        public IndexWorker getWorker() {
            return IndexStatisticsWorker.this;
        }
    }
}

