/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.structural;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.RawDataBackup;
import org.exist.dom.persistent.SymbolTable;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.storage.index.BTreeStore;
import org.exist.storage.lock.Lock;
import org.exist.storage.structural.NativeStructuralIndexWorker;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.w3c.dom.Element;

public class NativeStructuralIndex
extends AbstractIndex
implements RawBackupSupport {
    protected static final Logger LOG = LogManager.getLogger(NativeStructuralIndex.class);
    public static final String ID = NativeStructuralIndex.class.getName();
    public static final String FILE_NAME = "structure.dbx";
    public static final byte STRUCTURAL_INDEX_ID = 1;
    protected BTreeStore btree;
    protected SymbolTable symbols;

    @Override
    public void configure(BrokerPool pool, Path dataDir, Element config) throws DatabaseConfigurationException {
        super.configure(pool, dataDir, config);
        this.symbols = pool.getSymbols();
    }

    @Override
    public void open() throws DatabaseConfigurationException {
        Path file = this.getDataDir().resolve(FILE_NAME);
        LOG.debug("Creating '" + FileUtils.fileName(file) + "'...");
        try {
            this.btree = new BTreeStore(this.pool, 1, false, file, this.pool.getCacheManager());
        }
        catch (DBException e) {
            LOG.error("Failed to initialize structural index: " + e.getMessage(), (Throwable)e);
            throw new DatabaseConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws DBException {
        this.btree.close();
        this.btree = null;
    }

    @Override
    public void sync() throws DBException {
        if (this.btree == null) {
            return;
        }
        Lock lock = this.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.btree.flush();
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock for '" + FileUtils.fileName(this.btree.getFile()) + "'", (Throwable)e);
        }
        catch (DBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void remove() throws DBException {
        this.btree.closeAndRemove();
    }

    @Override
    public IndexWorker getWorker(DBBroker broker) {
        return new NativeStructuralIndexWorker(this);
    }

    @Override
    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    @Override
    public void backupToArchive(RawDataBackup backup) throws IOException {
        try {
            OutputStream os = backup.newEntry(FileUtils.fileName(this.btree.getFile()));
            this.btree.backupToStream(os);
        }
        finally {
            backup.closeEntry();
        }
    }
}

