/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.structural;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.TypedQNameComparator;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.ExtNodeSet;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.SymbolTable;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.IndexController;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.StreamListener;
import org.exist.indexing.StructuralIndex;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.lock.Lock;
import org.exist.storage.structural.NativeStructuralIndex;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteConversion;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeSelector;
import org.exist.xquery.NodeTest;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.NodeList;

public class NativeStructuralIndexWorker
implements IndexWorker,
StructuralIndex {
    private static final Logger LOG = LogManager.getLogger(NativeStructuralIndexWorker.class);
    private NativeStructuralIndex index;
    private StreamListener.ReindexMode mode = StreamListener.ReindexMode.STORE;
    private DocumentImpl document;
    private Map<QName, List<NodeProxy>> pending = new TreeMap<QName, List<NodeProxy>>(new TypedQNameComparator());
    private NativeStructuralStreamListener listener = new NativeStructuralStreamListener();

    public NativeStructuralIndexWorker(NativeStructuralIndex index) {
        this.index = index;
    }

    @Override
    public boolean matchElementsByTagName(byte type, DocumentSet docs, QName qname, NodeSelector selector) {
        return false;
    }

    @Override
    public boolean matchDescendantsByTagName(byte type, QName qname, int axis, DocumentSet docs, ExtNodeSet contextSet, int contextId) {
        return false;
    }

    @Override
    public NodeSet findElementsByTagName(byte type, DocumentSet docs, QName qname, NodeSelector selector) {
        return this.findElementsByTagName(type, docs, qname, selector, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSet findElementsByTagName(byte type, DocumentSet docs, QName qname, NodeSelector selector, Expression parent) {
        Lock lock = this.index.btree.getLock();
        NewArrayNodeSet result = new NewArrayNodeSet();
        FindElementsCallback callback = new FindElementsCallback(type, qname, result, docs, selector, parent);
        for (Range range : this.getDocIdRanges(docs)) {
            byte[] fromKey = this.computeKey(type, qname, range.start);
            byte[] toKey = this.computeKey(type, qname, range.end + 1);
            IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
            try {
                lock.acquire(Lock.LockMode.READ_LOCK);
                this.index.btree.query(query, callback);
            }
            catch (LockException e) {
                NativeStructuralIndex.LOG.warn("Lock problem while searching structural index: " + e.getMessage(), (Throwable)e);
            }
            catch (TerminatedException e) {
                NativeStructuralIndex.LOG.warn("Query was terminated while searching structural index: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                NativeStructuralIndex.LOG.error("Error while searching structural index: " + e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(Lock.LockMode.READ_LOCK);
            }
        }
        return result;
    }

    List<Range> getDocIdRanges(DocumentSet docs) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        Range next = null;
        Iterator<DocumentImpl> i = docs.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl doc = i.next();
            if (next == null) {
                next = new Range(doc.getDocId());
                continue;
            }
            if (next.end + 1 == doc.getDocId()) {
                ++next.end;
                continue;
            }
            ranges.add(next);
            next = new Range(doc.getDocId());
        }
        if (next != null) {
            ranges.add(next);
        }
        return ranges;
    }

    @Override
    public NodeSet findDescendantsByTagName(byte type, QName qname, int axis, DocumentSet docs, NodeSet contextSet, int contextId) {
        return this.findDescendantsByTagName(type, qname, axis, docs, contextSet, contextId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSet findDescendantsByTagName(byte type, QName qname, int axis, DocumentSet docs, NodeSet contextSet, int contextId, Expression parent) {
        Lock lock = this.index.btree.getLock();
        NewArrayNodeSet result = new NewArrayNodeSet();
        FindDescendantsCallback callback = new FindDescendantsCallback(type, axis, qname, contextId, result, parent);
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            for (NodeProxy ancestor : contextSet) {
                byte[] toKey;
                byte[] fromKey;
                DocumentImpl doc = ancestor.getOwnerDocument();
                NodeId ancestorId = ancestor.getNodeId();
                callback.setAncestor(doc, ancestor);
                if (ancestorId == NodeId.DOCUMENT_NODE) {
                    fromKey = this.computeKey(type, qname, doc.getDocId());
                    toKey = this.computeKey(type, qname, doc.getDocId() + 1);
                } else {
                    fromKey = this.computeKey(type, qname, doc.getDocId(), ancestorId);
                    toKey = this.computeKey(type, qname, doc.getDocId(), ancestorId.nextSibling());
                }
                IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
                try {
                    this.index.btree.query(query, callback);
                }
                catch (Exception e) {
                    NativeStructuralIndex.LOG.error("Error while searching structural index: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (LockException e) {
            NativeStructuralIndex.LOG.warn("Lock problem while searching structural index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
        result.updateNoSort();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSet findAncestorsByTagName(byte type, QName qname, int axis, DocumentSet docs, NodeSet contextSet, int contextId) {
        Lock lock = this.index.btree.getLock();
        NewArrayNodeSet result = new NewArrayNodeSet();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            block7: for (NodeProxy descendant : contextSet) {
                DocumentImpl doc = descendant.getOwnerDocument();
                for (NodeId parentId = axis == 1 || axis == 12 ? descendant.getNodeId() : descendant.getNodeId().getParentId(); parentId != NodeId.DOCUMENT_NODE; parentId = parentId.getParentId()) {
                    byte[] key = this.computeKey(type, qname, doc.getDocId(), parentId);
                    long address = this.index.btree.findValue(new Value(key));
                    if (address != -1L) {
                        NodeProxy storedNode = new NodeProxy(doc, parentId, type == 1 ? (short)2 : 1, address);
                        result.add(storedNode);
                        if (-1 != contextId) {
                            storedNode.deepCopyContext(descendant, contextId);
                        } else {
                            storedNode.copyContext(descendant);
                        }
                        if (contextSet.getTrackMatches()) {
                            storedNode.addMatches(descendant);
                        }
                    }
                    if (axis == 12 || axis == 2) continue block7;
                }
            }
        }
        catch (LockException e) {
            NativeStructuralIndex.LOG.warn("Lock problem while searching structural index: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            NativeStructuralIndex.LOG.error("Error while searching structural index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
        result.sort(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSet scanByType(byte type, int axis, NodeTest test, boolean useSelfAsContext, DocumentSet docs, NodeSet contextSet, int contextId) {
        Lock lock = this.index.btree.getLock();
        NewArrayNodeSet result = new NewArrayNodeSet();
        FindDescendantsCallback callback = new FindDescendantsCallback(type, axis, null, contextId, useSelfAsContext, result, null);
        for (NodeProxy ancestor : contextSet) {
            DocumentImpl doc = ancestor.getOwnerDocument();
            NodeId ancestorId = ancestor.getNodeId();
            List<QName> qnames = this.getQNamesForDoc(doc);
            try {
                lock.acquire(Lock.LockMode.READ_LOCK);
                for (QName qname : qnames) {
                    byte[] toKey;
                    byte[] fromKey;
                    if (test.getName() != null && !test.matches(qname)) continue;
                    callback.setAncestor(doc, ancestor);
                    if (ancestorId == NodeId.DOCUMENT_NODE) {
                        fromKey = this.computeKey(type, qname, doc.getDocId());
                        toKey = this.computeKey(type, qname, doc.getDocId() + 1);
                    } else {
                        fromKey = this.computeKey(type, qname, doc.getDocId(), ancestorId);
                        toKey = this.computeKey(type, qname, doc.getDocId(), ancestorId.nextSibling());
                    }
                    IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
                    try {
                        this.index.btree.query(query, callback);
                    }
                    catch (Exception e) {
                        NativeStructuralIndex.LOG.error("Error while searching structural index: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (LockException e) {
                NativeStructuralIndex.LOG.warn("Lock problem while searching structural index: " + e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(Lock.LockMode.READ_LOCK);
            }
        }
        return result;
    }

    @Override
    public String getIndexId() {
        return NativeStructuralIndex.ID;
    }

    @Override
    public String getIndexName() {
        return this.index.getIndexName();
    }

    @Override
    public Object configure(IndexController controller, NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        return null;
    }

    @Override
    public void setDocument(DocumentImpl doc) {
        this.setDocument(doc, StreamListener.ReindexMode.UNKNOWN);
    }

    @Override
    public void setDocument(DocumentImpl doc, StreamListener.ReindexMode mode) {
        this.document = doc;
        this.mode = mode;
    }

    @Override
    public void setMode(StreamListener.ReindexMode mode) {
        this.mode = mode;
    }

    @Override
    public DocumentImpl getDocument() {
        return this.document;
    }

    @Override
    public StreamListener.ReindexMode getMode() {
        return this.mode;
    }

    @Override
    public <T extends IStoredNode> IStoredNode getReindexRoot(IStoredNode<T> node, NodePath path, boolean insert, boolean includeSelf) {
        return insert ? null : node;
    }

    @Override
    public StreamListener getListener() {
        return this.listener;
    }

    @Override
    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy) {
        return null;
    }

    @Override
    public void flush() {
        switch (this.mode) {
            case STORE: {
                this.processPending();
                break;
            }
            case REMOVE_ALL_NODES: {
                this.removeDocument(this.document);
                break;
            }
            case REMOVE_SOME_NODES: {
                this.removeSome();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSome() {
        if (this.pending.size() == 0) {
            return;
        }
        try {
            Lock lock = this.index.btree.getLock();
            for (Map.Entry<QName, List<NodeProxy>> entry : this.pending.entrySet()) {
                QName qname = entry.getKey();
                try {
                    lock.acquire(Lock.LockMode.WRITE_LOCK);
                    List<NodeProxy> nodes = entry.getValue();
                    for (NodeProxy proxy : nodes) {
                        NodeId nodeId = proxy.getNodeId();
                        byte[] key = this.computeKey(qname.getNameType(), qname, this.document.getDocId(), nodeId);
                        this.index.btree.removeValue(new Value(key));
                    }
                }
                catch (LockException e) {
                    NativeStructuralIndex.LOG.warn("Failed to lock structural index: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    NativeStructuralIndex.LOG.warn("Exception caught while writing to structural index: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.WRITE_LOCK);
                }
            }
        }
        finally {
            this.pending.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDocument(DocumentImpl docToRemove) {
        if (this.index.btree == null) {
            return;
        }
        List<QName> qnames = this.getQNamesForDoc(docToRemove);
        for (QName qname : qnames) {
            byte[] fromKey = this.computeKey(qname.getNameType(), qname, docToRemove.getDocId());
            byte[] toKey = this.computeKey(qname.getNameType(), qname, docToRemove.getDocId() + 1);
            IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
            Lock lock = this.index.btree.getLock();
            try {
                lock.acquire(Lock.LockMode.WRITE_LOCK);
                this.index.btree.remove(query, null);
            }
            catch (LockException e) {
                NativeStructuralIndex.LOG.warn("Failed to lock structural index: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                NativeStructuralIndex.LOG.warn("Exception caught while removing structural index for document " + docToRemove.getURI() + ": " + e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(Lock.LockMode.WRITE_LOCK);
            }
        }
        this.removeQNamesForDoc(docToRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeQNamesForDoc(DocumentImpl doc) {
        byte[] fromKey = this.computeDocKey(doc.getDocId());
        byte[] toKey = this.computeDocKey(doc.getDocId() + 1);
        IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.index.btree.remove(query, null);
        }
        catch (LockException e) {
            NativeStructuralIndex.LOG.warn("Failed to lock structural index: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            NativeStructuralIndex.LOG.warn("Exception caught while reading structural index for document " + doc.getURI() + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<QName> getQNamesForDoc(DocumentImpl doc) {
        final ArrayList<QName> qnames = new ArrayList<QName>();
        if (this.index.btree == null) {
            return qnames;
        }
        byte[] fromKey = this.computeDocKey(doc.getDocId());
        byte[] toKey = this.computeDocKey(doc.getDocId() + 1);
        IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.index.btree.query(query, new BTreeCallback(){

                @Override
                public boolean indexInfo(Value value, long pointer) throws TerminatedException {
                    QName qname = NativeStructuralIndexWorker.this.readQName(value.getData());
                    qnames.add(qname);
                    return true;
                }
            });
        }
        catch (LockException e) {
            NativeStructuralIndex.LOG.warn("Failed to lock structural index: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            NativeStructuralIndex.LOG.warn("Exception caught while reading structural index for document " + doc.getURI() + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
        return qnames;
    }

    @Override
    public void removeCollection(Collection collection, DBBroker broker, boolean reindex) throws PermissionDeniedException {
        try {
            Iterator<DocumentImpl> i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = i.next();
                this.removeDocument(doc);
            }
        }
        catch (LockException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrences[] scanIndex(XQueryContext context, DocumentSet docs, NodeSet contextSet, Map hints) {
        final TreeMap occurrences = new TreeMap();
        Iterator<DocumentImpl> i = docs.getDocumentIterator();
        while (i.hasNext()) {
            final DocumentImpl doc = i.next();
            List<QName> qnames = this.getQNamesForDoc(doc);
            for (QName qname : qnames) {
                final String name = qname.getNameType() == 1 ? "@" + qname.getLocalPart() : qname.getLocalPart();
                byte[] fromKey = this.computeKey(qname.getNameType(), qname, doc.getDocId());
                byte[] toKey = this.computeKey(qname.getNameType(), qname, doc.getDocId() + 1);
                IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
                Lock lock = this.index.btree.getLock();
                try {
                    lock.acquire(Lock.LockMode.READ_LOCK);
                    this.index.btree.query(query, new BTreeCallback(){

                        @Override
                        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
                            Occurrences oc = (Occurrences)occurrences.get(name);
                            if (oc == null) {
                                oc = new Occurrences((Comparable)((Object)name));
                                occurrences.put(name, oc);
                                oc.addDocument(doc);
                                oc.addOccurrences(1);
                            } else {
                                oc.addOccurrences(1);
                                oc.addDocument(doc);
                            }
                            return true;
                        }
                    });
                }
                catch (LockException e) {
                    NativeStructuralIndex.LOG.warn("Failed to lock structural index: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    NativeStructuralIndex.LOG.warn("Exception caught while reading structural index for document " + doc.getURI() + ": " + e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        Occurrences[] result = new Occurrences[occurrences.size()];
        int i2 = 0;
        for (Occurrences occ : occurrences.values()) {
            result[i2++] = occ;
        }
        return result;
    }

    @Override
    public QueryRewriter getQueryRewriter(XQueryContext context) {
        return null;
    }

    public BTree getStorage() {
        return this.index.btree;
    }

    private void addNode(QName qname, NodeProxy proxy) {
        if (this.document.getDocId() != proxy.getOwnerDocument().getDocId()) {
            throw new IllegalArgumentException("Document id ('" + this.document.getDocId() + "') and proxy id ('" + proxy.getOwnerDocument().getDocId() + "') differ !");
        }
        List<NodeProxy> buf = this.pending.get(qname);
        if (buf == null) {
            buf = new ArrayList<NodeProxy>(50);
            this.pending.put(qname, buf);
        }
        buf.add(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPending() {
        if (this.pending.size() == 0) {
            return;
        }
        try {
            Lock lock = this.index.btree.getLock();
            for (Map.Entry<QName, List<NodeProxy>> entry : this.pending.entrySet()) {
                QName qname = entry.getKey();
                try {
                    lock.acquire(Lock.LockMode.WRITE_LOCK);
                    List<NodeProxy> nodes = entry.getValue();
                    for (NodeProxy proxy : nodes) {
                        NodeId nodeId = proxy.getNodeId();
                        byte[] key = this.computeKey(qname.getNameType(), qname, this.document.getDocId(), nodeId);
                        this.index.btree.addValue(new Value(key), this.computeValue(proxy));
                    }
                    Value docKey = new Value(this.computeDocKey(qname.getNameType(), this.document.getDocId(), qname));
                    if (this.index.btree.findValue(docKey) != -1L) continue;
                    this.index.btree.addValue(docKey, 0L);
                }
                catch (LockException e) {
                    NativeStructuralIndex.LOG.warn("Failed to lock structural index: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    NativeStructuralIndex.LOG.warn("Exception caught while writing to structural index: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(Lock.LockMode.WRITE_LOCK);
                }
            }
        }
        finally {
            this.pending.clear();
        }
    }

    private byte[] computeKey(byte type, QName qname, int documentId, NodeId nodeId) {
        SymbolTable symbols = this.index.getBrokerPool().getSymbols();
        short sym = symbols.getSymbol(qname.getLocalPart());
        short nsSym = symbols.getNSSymbol(qname.getNamespaceURI());
        byte[] data = new byte[9 + nodeId.size()];
        data[0] = type;
        ByteConversion.shortToByteH(sym, data, 1);
        ByteConversion.shortToByteH(nsSym, data, 3);
        ByteConversion.intToByteH(documentId, data, 5);
        nodeId.serialize(data, 9);
        return data;
    }

    private byte[] computeKey(byte type, QName qname, int documentId) {
        SymbolTable symbols = this.index.getBrokerPool().getSymbols();
        short sym = symbols.getSymbol(qname.getLocalPart());
        short nsSym = symbols.getNSSymbol(qname.getNamespaceURI());
        byte[] data = new byte[9];
        data[0] = type;
        ByteConversion.shortToByteH(sym, data, 1);
        ByteConversion.shortToByteH(nsSym, data, 3);
        ByteConversion.intToByteH(documentId, data, 5);
        return data;
    }

    private byte[] computeKey(byte type, int documentId) {
        byte[] data = new byte[5];
        data[0] = type;
        ByteConversion.intToByteH(documentId, data, 1);
        return data;
    }

    private byte[] computeDocKey(byte type, int documentId, QName qname) {
        SymbolTable symbols = this.index.getBrokerPool().getSymbols();
        short sym = symbols.getSymbol(qname.getLocalPart());
        short nsSym = symbols.getNSSymbol(qname.getNamespaceURI());
        byte[] data = new byte[10];
        data[0] = 2;
        ByteConversion.intToByteH(documentId, data, 1);
        data[5] = type;
        ByteConversion.shortToByteH(sym, data, 6);
        ByteConversion.shortToByteH(nsSym, data, 8);
        return data;
    }

    private byte[] computeDocKey(int documentId) {
        byte[] data = new byte[5];
        data[0] = 2;
        ByteConversion.intToByteH(documentId, data, 1);
        return data;
    }

    private long computeValue(NodeProxy proxy) {
        long address = proxy.getInternalAddress();
        short nodeIdLen = (short)(proxy.getNodeId().units() % 8);
        return address | (long)(nodeIdLen << 24) & 0xFF000000L;
    }

    private int readDocId(byte[] key) {
        return ByteConversion.byteToIntH(key, 5);
    }

    private NodeId readNodeId(byte[] key, long value) {
        int bits = (int)(value >>> 24 & 0xFFL);
        if (bits == 0) {
            bits = 8;
        }
        int units = (key.length - 10) * 8 + bits;
        return this.index.getBrokerPool().getNodeFactory().createFromData(units, key, 9);
    }

    private QName readQName(byte[] key) {
        SymbolTable symbols = this.index.getBrokerPool().getSymbols();
        byte type = key[5];
        short sym = ByteConversion.byteToShortH(key, 6);
        short nsSym = ByteConversion.byteToShortH(key, 8);
        return new QName(symbols.getName(sym), symbols.getNamespace(nsSym), type);
    }

    private class NativeStructuralStreamListener
    extends AbstractStreamListener {
        private NativeStructuralStreamListener() {
        }

        @Override
        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            super.startElement(transaction, element, path);
            if (NativeStructuralIndexWorker.this.mode == StreamListener.ReindexMode.STORE || NativeStructuralIndexWorker.this.mode == StreamListener.ReindexMode.REMOVE_SOME_NODES) {
                short indexType = 0;
                if (element.getIndexType() != 0) {
                    indexType = (short)element.getIndexType();
                }
                NodeProxy proxy = new NodeProxy(NativeStructuralIndexWorker.this.document, element.getNodeId(), 1, element.getInternalAddress());
                proxy.setIndexType(indexType);
                NativeStructuralIndexWorker.this.addNode(element.getQName(), proxy);
            }
        }

        @Override
        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            super.endElement(transaction, element, path);
        }

        @Override
        public void attribute(Txn transaction, AttrImpl attrib, NodePath path) {
            if (NativeStructuralIndexWorker.this.mode == StreamListener.ReindexMode.STORE || NativeStructuralIndexWorker.this.mode == StreamListener.ReindexMode.REMOVE_SOME_NODES) {
                short indexType = 0;
                if (attrib.getIndexType() != 0) {
                    indexType = (short)attrib.getIndexType();
                }
                NodeProxy proxy = new NodeProxy(NativeStructuralIndexWorker.this.document, attrib.getNodeId(), 2, attrib.getInternalAddress());
                proxy.setIndexType(indexType);
                NativeStructuralIndexWorker.this.addNode(attrib.getQName(), proxy);
            }
            super.attribute(transaction, attrib, path);
        }

        @Override
        public IndexWorker getWorker() {
            return NativeStructuralIndexWorker.this;
        }
    }

    private class FindDescendantsCallback
    implements BTreeCallback {
        int axis;
        byte type;
        QName qname;
        NodeProxy ancestor;
        DocumentImpl doc;
        int contextId;
        NewArrayNodeSet result;
        boolean selfAsContext = false;
        Expression parent;

        FindDescendantsCallback(byte type, int axis, QName qname, int contextId, NewArrayNodeSet result, Expression parent) {
            this(type, axis, qname, contextId, false, result, parent);
        }

        FindDescendantsCallback(byte type, int axis, QName qname, int contextId, boolean selfAsContext, NewArrayNodeSet result, Expression parent) {
            this.type = type;
            this.axis = axis;
            this.contextId = contextId;
            this.result = result;
            this.selfAsContext = selfAsContext;
            this.parent = parent;
            this.qname = qname != null && qname.getNameType() != type ? new QName(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix(), type) : qname;
        }

        void setAncestor(DocumentImpl doc, NodeProxy ancestor) {
            this.doc = doc;
            this.ancestor = ancestor;
        }

        @Override
        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            boolean match;
            if (this.parent != null) {
                this.parent.getContext().proceed(this.parent);
            }
            NodeId nodeId = NativeStructuralIndexWorker.this.readNodeId(value.getData(), pointer);
            boolean bl = match = this.axis == 8 || this.axis == 13;
            if (!match) {
                int relation = nodeId.computeRelation(this.ancestor.getNodeId());
                boolean bl2 = match = (this.axis == 5 || this.axis == 6) && relation == 1 || this.axis == 7 && (relation == 2 || relation == 1);
            }
            if (match) {
                NodeProxy storedNode = new NodeProxy(this.doc, nodeId, this.type == 1 ? (short)2 : 1, pointer);
                if (this.qname != null) {
                    storedNode.setQName(this.qname);
                }
                this.result.add(storedNode);
                if (-1 != this.contextId) {
                    if (this.selfAsContext) {
                        storedNode.addContextNode(this.contextId, storedNode);
                    } else {
                        storedNode.deepCopyContext(this.ancestor, this.contextId);
                    }
                } else {
                    storedNode.copyContext(this.ancestor);
                }
                storedNode.addMatches(this.ancestor);
            }
            return true;
        }
    }

    private class FindElementsCallback
    implements BTreeCallback {
        byte type;
        QName qname;
        DocumentSet docs;
        NewArrayNodeSet result;
        NodeSelector selector;
        Expression parent;

        FindElementsCallback(byte type, QName qname, NewArrayNodeSet result, DocumentSet docs, NodeSelector selector, Expression parent) {
            this.type = type;
            this.result = result;
            this.docs = docs;
            this.selector = selector;
            this.parent = parent;
            this.qname = qname != null && qname.getNameType() != type ? new QName(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix(), type) : qname;
        }

        @Override
        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            if (this.parent != null) {
                this.parent.getContext().proceed(this.parent);
            }
            byte[] key = value.getData();
            NodeId nodeId = NativeStructuralIndexWorker.this.readNodeId(key, pointer);
            DocumentImpl doc = this.docs.getDoc(NativeStructuralIndexWorker.this.readDocId(key));
            if (doc != null) {
                if (this.selector == null) {
                    NodeProxy storedNode = new NodeProxy(doc, nodeId, this.type == 1 ? (short)2 : 1, pointer);
                    if (this.qname != null) {
                        storedNode.setQName(this.qname);
                    }
                    this.result.add(storedNode);
                } else {
                    NodeProxy storedNode = this.selector.match(doc, nodeId);
                    if (storedNode != null) {
                        storedNode.setNodeType(this.type == 1 ? (short)2 : 1);
                        storedNode.setInternalAddress(pointer);
                        if (this.qname != null) {
                            storedNode.setQName(this.qname);
                        }
                        this.result.add(storedNode);
                    }
                }
            }
            return true;
        }
    }

    static class Range {
        int start = -1;
        int end = -1;

        private Range(int start) {
            this.start = start;
            this.end = start;
        }
    }
}

