/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.txn;

import java.util.ArrayList;
import java.util.List;
import org.exist.Transaction;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.TxnListener;
import org.exist.util.LockException;

public class Txn
implements Transaction {
    private final TransactionManager tm;
    private final long id;
    private State state;
    private String originId;
    private List<LockInfo> locksHeld = new ArrayList<LockInfo>();
    private List<TxnListener> listeners = new ArrayList<TxnListener>();

    public Txn(TransactionManager tm, long transactionId) {
        this.tm = tm;
        this.id = transactionId;
        this.state = State.STARTED;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public long getId() {
        return this.id;
    }

    @Deprecated
    public void registerLock(Lock lock, Lock.LockMode lockMode) {
        this.locksHeld.add(new LockInfo(lock, lockMode));
    }

    public void acquireLock(Lock lock, Lock.LockMode lockMode) throws LockException {
        lock.acquire(lockMode);
        this.locksHeld.add(new LockInfo(lock, lockMode));
    }

    public void releaseAll() {
        for (int i = this.locksHeld.size() - 1; i >= 0; --i) {
            LockInfo info = this.locksHeld.get(i);
            info.lock.release(info.lockMode);
        }
        this.locksHeld.clear();
    }

    public void registerListener(TxnListener listener) {
        this.listeners.add(listener);
    }

    protected void signalAbort() {
        this.state = State.ABORTED;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).abort();
        }
    }

    protected void signalCommit() {
        this.state = State.COMMITTED;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).commit();
        }
    }

    @Override
    public void success() throws TransactionException {
        this.commit();
    }

    @Override
    public void commit() throws TransactionException {
        this.tm.commit(this);
    }

    @Override
    public void failure() {
        this.abort();
    }

    @Override
    public void abort() {
        this.tm.abort(this);
    }

    @Override
    public void close() {
        this.tm.close(this);
    }

    @Deprecated
    public String getOriginId() {
        return this.originId;
    }

    @Deprecated
    public void setOriginId(String id) {
        this.originId = id;
    }

    private static class LockInfo {
        final Lock lock;
        final Lock.LockMode lockMode;

        public LockInfo(Lock lock, Lock.LockMode lockMode) {
            this.lock = lock;
            this.lockMode = lockMode;
        }
    }

    public static enum State {
        STARTED,
        ABORTED,
        COMMITTED,
        CLOSED;

    }
}

